/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import wile.redstonepen.libmc.Auxiliaries;

public class StandardBlocks {
    public static final long CFG_DEFAULT = 0L;
    public static final long CFG_CUTOUT = 1L;
    public static final long CFG_MIPPED = 2L;
    public static final long CFG_TRANSLUCENT = 4L;
    public static final long CFG_WATERLOGGABLE = 8L;
    public static final long CFG_HORIZIONTAL = 16L;
    public static final long CFG_LOOK_PLACEMENT = 32L;
    public static final long CFG_FACING_PLACEMENT = 64L;
    public static final long CFG_OPPOSITE_PLACEMENT = 128L;
    public static final long CFG_FLIP_PLACEMENT_IF_SAME = 256L;
    public static final long CFG_FLIP_PLACEMENT_SHIFTCLICK = 512L;
    public static final long CFG_STRICT_CONNECTIONS = 1024L;
    public static final long CFG_AI_PASSABLE = 2048L;

    public static class HorizontalFourWayWaterLoggable
    extends WaterLoggable
    implements IStandardBlock {
        public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
        public static final BooleanProperty EAST = BlockStateProperties.EAST;
        public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
        public static final BooleanProperty WEST = BlockStateProperties.WEST;
        protected final Map<BlockState, VoxelShape> shapes;
        protected final Map<BlockState, VoxelShape> collision_shapes;

        public HorizontalFourWayWaterLoggable(long config, BlockBehaviour.Properties properties, AABB base_aabb, AABB[] side_aabb, int railing_height_extension) {
            super(config, properties, base_aabb);
            HashMap<BlockState, VoxelShape> build_shapes = new HashMap<BlockState, VoxelShape>();
            HashMap<BlockState, VoxelShape> build_collision_shapes = new HashMap<BlockState, VoxelShape>();
            for (BlockState state : this.getStateDefinition().getPossibleStates()) {
                VoxelShape shape2;
                VoxelShape voxelShape = shape2 = base_aabb.getXsize() == 0.0 || base_aabb.getYsize() == 0.0 || base_aabb.getZsize() == 0.0 ? Shapes.empty() : Shapes.create((AABB)base_aabb);
                if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
                    shape2 = Shapes.joinUnoptimized((VoxelShape)shape2, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(side_aabb, Direction.NORTH, true)), (BooleanOp)BooleanOp.OR);
                }
                if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
                    shape2 = Shapes.joinUnoptimized((VoxelShape)shape2, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(side_aabb, Direction.EAST, true)), (BooleanOp)BooleanOp.OR);
                }
                if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
                    shape2 = Shapes.joinUnoptimized((VoxelShape)shape2, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(side_aabb, Direction.SOUTH, true)), (BooleanOp)BooleanOp.OR);
                }
                if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                    shape2 = Shapes.joinUnoptimized((VoxelShape)shape2, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(side_aabb, Direction.WEST, true)), (BooleanOp)BooleanOp.OR);
                }
                if (shape2.isEmpty()) {
                    shape2 = Shapes.block();
                }
                build_shapes.put((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), shape2);
                build_shapes.put((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), shape2);
                VoxelShape voxelShape2 = shape2 = base_aabb.getXsize() == 0.0 || base_aabb.getYsize() == 0.0 || base_aabb.getZsize() == 0.0 ? Shapes.empty() : Shapes.create((AABB)base_aabb);
                if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
                    shape2 = Shapes.joinUnoptimized((VoxelShape)shape2, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getMappedAABB(Auxiliaries.getRotatedAABB(side_aabb, Direction.NORTH, true), bb -> bb.expandTowards(0.0, (double)railing_height_extension, 0.0))), (BooleanOp)BooleanOp.OR);
                }
                if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
                    shape2 = Shapes.joinUnoptimized((VoxelShape)shape2, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getMappedAABB(Auxiliaries.getRotatedAABB(side_aabb, Direction.EAST, true), bb -> bb.expandTowards(0.0, (double)railing_height_extension, 0.0))), (BooleanOp)BooleanOp.OR);
                }
                if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
                    shape2 = Shapes.joinUnoptimized((VoxelShape)shape2, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getMappedAABB(Auxiliaries.getRotatedAABB(side_aabb, Direction.SOUTH, true), bb -> bb.expandTowards(0.0, (double)railing_height_extension, 0.0))), (BooleanOp)BooleanOp.OR);
                }
                if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                    shape2 = Shapes.joinUnoptimized((VoxelShape)shape2, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getMappedAABB(Auxiliaries.getRotatedAABB(side_aabb, Direction.WEST, true), bb -> bb.expandTowards(0.0, (double)railing_height_extension, 0.0))), (BooleanOp)BooleanOp.OR);
                }
                if (shape2.isEmpty()) {
                    shape2 = Shapes.block();
                }
                build_collision_shapes.put((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), shape2);
                build_collision_shapes.put((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), shape2);
            }
            this.shapes = build_shapes;
            this.collision_shapes = build_collision_shapes;
            this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        public HorizontalFourWayWaterLoggable(long config, BlockBehaviour.Properties properties, AABB base_aabb, AABB side_aabb, int railing_height_extension) {
            this(config, properties, base_aabb, new AABB[]{side_aabb}, railing_height_extension);
        }

        @Override
        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{NORTH, EAST, SOUTH, WEST});
        }

        @Override
        @Nullable
        public BlockState getStateForPlacement(BlockPlaceContext context) {
            BlockState state = super.getStateForPlacement(context);
            if (state == null) {
                return null;
            }
            return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false));
        }

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return this.shapes.getOrDefault(state, Shapes.block());
        }

        @Override
        public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return this.collision_shapes.getOrDefault(state, Shapes.block());
        }

        public static BooleanProperty getDirectionProperty(Direction face) {
            return switch (face) {
                case Direction.EAST -> EAST;
                case Direction.SOUTH -> SOUTH;
                case Direction.WEST -> WEST;
                default -> NORTH;
            };
        }
    }

    public static class HorizontalWaterLoggable
    extends Horizontal
    implements IStandardBlock {
        public HorizontalWaterLoggable(long config, BlockBehaviour.Properties properties, AABB aabb) {
            super(config | 8L | 0x10L, properties, aabb);
        }

        public HorizontalWaterLoggable(long config, BlockBehaviour.Properties properties, AABB[] aabbs) {
            super(config | 8L | 0x10L, properties, aabbs);
        }

        public HorizontalWaterLoggable(long config, BlockBehaviour.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config | 8L | 0x10L, properties, shape_supplier);
        }

        public HorizontalWaterLoggable(long config, BlockBehaviour.Properties properties, Function<List<BlockState>, Map<BlockState, VoxelShape>> shape_supplier) {
            super(config | 8L | 0x10L, properties, shape_supplier);
        }

        @Override
        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{WATERLOGGED});
        }
    }

    public static class AxisAlignedWaterLoggable
    extends AxisAligned
    implements IStandardBlock {
        public AxisAlignedWaterLoggable(long config, BlockBehaviour.Properties properties, AABB aabb) {
            super(config | 8L, properties, aabb);
        }

        public AxisAlignedWaterLoggable(long config, BlockBehaviour.Properties properties, AABB[] aabbs) {
            super(config | 8L, properties, aabbs);
        }

        public AxisAlignedWaterLoggable(long config, BlockBehaviour.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config | 8L, properties, shape_supplier);
        }

        @Override
        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{WATERLOGGED});
        }
    }

    public static class DirectedWaterLoggable
    extends Directed
    implements IStandardBlock {
        public DirectedWaterLoggable(long config, BlockBehaviour.Properties properties, AABB aabb) {
            super(config | 8L, properties, aabb);
        }

        public DirectedWaterLoggable(long config, BlockBehaviour.Properties properties, AABB[] aabbs) {
            super(config | 8L, properties, aabbs);
        }

        public DirectedWaterLoggable(long config, BlockBehaviour.Properties properties, Function<List<BlockState>, Map<BlockState, VoxelShape>> shape_supplier) {
            super(config | 8L, properties, shape_supplier);
        }

        public DirectedWaterLoggable(long config, BlockBehaviour.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config | 8L, properties, shape_supplier);
        }

        @Override
        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{WATERLOGGED});
        }
    }

    public static class Horizontal
    extends Cutout
    implements IStandardBlock {
        public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
        protected final Map<BlockState, VoxelShape> vshapes;
        protected final Map<BlockState, VoxelShape> cshapes;

        public Horizontal(long config, BlockBehaviour.Properties properties, Function<List<BlockState>, Map<BlockState, VoxelShape>> shape_supplier) {
            super(config | 0x10L, properties);
            this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
            this.vshapes = shape_supplier.apply((List<BlockState>)this.getStateDefinition().getPossibleStates());
            this.cshapes = shape_supplier.apply((List<BlockState>)this.getStateDefinition().getPossibleStates());
        }

        public Horizontal(long config, BlockBehaviour.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            this(config, properties, (List<BlockState> states) -> {
                HashMap<BlockState, VoxelShape> vshapes = new HashMap<BlockState, VoxelShape>();
                ArrayList indexed_shapes = (ArrayList)shape_supplier.get();
                for (BlockState state : states) {
                    vshapes.put(state, (VoxelShape)indexed_shapes.get(((Direction)state.getValue((Property)HORIZONTAL_FACING)).get3DDataValue()));
                }
                return vshapes;
            });
        }

        public Horizontal(long config, BlockBehaviour.Properties properties, AABB unrotatedAABB) {
            this(config, properties, new AABB[]{unrotatedAABB});
        }

        public Horizontal(long config, BlockBehaviour.Properties properties, AABB[] unrotatedAABBs) {
            this(config, properties, (List<BlockState> states) -> {
                HashMap<BlockState, VoxelShape> vshapes = new HashMap<BlockState, VoxelShape>();
                for (BlockState state : states) {
                    vshapes.put(state, Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, (Direction)state.getValue((Property)HORIZONTAL_FACING), true)));
                }
                return vshapes;
            });
        }

        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{HORIZONTAL_FACING});
        }

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter source, BlockPos pos, CollisionContext selectionContext) {
            return this.vshapes.get(state);
        }

        @Override
        public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return this.cshapes.get(state);
        }

        @Override
        @Nullable
        public BlockState getStateForPlacement(BlockPlaceContext context) {
            BlockState state = super.getStateForPlacement(context);
            if (state == null) {
                return null;
            }
            Direction facing = context.getClickedFace();
            if ((this.config & 0x20L) != 0L) {
                facing = context.getHorizontalDirection();
            } else {
                Direction direction = facing = facing == Direction.UP || facing == Direction.DOWN ? context.getHorizontalDirection() : facing;
            }
            if ((this.config & 0x80L) != 0L) {
                facing = facing.getOpposite();
            }
            if ((this.config & 0x200L) != 0L && context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
                facing = facing.getOpposite();
            }
            return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)facing);
        }

        public BlockState rotate(BlockState state, Rotation rot) {
            return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)HORIZONTAL_FACING)));
        }

        public BlockState mirror(BlockState state, Mirror mirrorIn) {
            return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)HORIZONTAL_FACING)));
        }
    }

    public static class AxisAligned
    extends Cutout
    implements IStandardBlock {
        public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
        protected final ArrayList<VoxelShape> vshapes;

        public AxisAligned(long config, BlockBehaviour.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config, properties);
            this.registerDefaultState((BlockState)super.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.X));
            this.vshapes = shape_supplier.get();
        }

        public AxisAligned(long config, BlockBehaviour.Properties properties, AABB[] unrotatedAABBs) {
            this(config, properties, () -> new ArrayList<VoxelShape>(Arrays.asList(Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.EAST, false)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.UP, false)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.SOUTH, false)), Shapes.block())));
        }

        public AxisAligned(long config, BlockBehaviour.Properties properties, AABB unrotatedAABB) {
            this(config, properties.isValidSpawn((s, w, p, e) -> false), new AABB[]{unrotatedAABB});
        }

        @Override
        public boolean isPossibleToRespawnInThis(BlockState state) {
            return false;
        }

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter source, BlockPos pos, CollisionContext selectionContext) {
            return this.vshapes.get(((Direction.Axis)state.getValue(AXIS)).ordinal() & 3);
        }

        @Override
        public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return this.getShape(state, world, pos, selectionContext);
        }

        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{AXIS});
        }

        @Override
        @Nullable
        public BlockState getStateForPlacement(BlockPlaceContext context) {
            Direction facing = (this.config & 0x20L) != 0L ? context.getNearestLookingDirection() : context.getClickedFace();
            BlockState state = super.getStateForPlacement(context);
            if (state == null) {
                return null;
            }
            return (BlockState)state.setValue(AXIS, (Comparable)facing.getAxis());
        }

        public BlockState rotate(BlockState state, Rotation rotation) {
            switch (rotation) {
                case CLOCKWISE_90: 
                case COUNTERCLOCKWISE_90: {
                    switch ((Direction.Axis)state.getValue(AXIS)) {
                        case X: {
                            return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                        }
                        case Z: {
                            return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                        }
                    }
                }
            }
            return state;
        }
    }

    public static class Directed
    extends Cutout
    implements IStandardBlock {
        public static final DirectionProperty FACING = BlockStateProperties.FACING;
        protected final Map<BlockState, VoxelShape> vshapes;

        public Directed(long config, BlockBehaviour.Properties properties, Function<List<BlockState>, Map<BlockState, VoxelShape>> shape_supplier) {
            super(config, properties);
            this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP));
            this.vshapes = shape_supplier.apply((List<BlockState>)this.getStateDefinition().getPossibleStates());
        }

        public Directed(long config, BlockBehaviour.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            this(config, properties, (List<BlockState> states) -> {
                HashMap<BlockState, VoxelShape> vshapes = new HashMap<BlockState, VoxelShape>();
                ArrayList indexed_shapes = (ArrayList)shape_supplier.get();
                for (BlockState state : states) {
                    vshapes.put(state, (VoxelShape)indexed_shapes.get(((Direction)state.getValue((Property)FACING)).get3DDataValue()));
                }
                return vshapes;
            });
        }

        public Directed(long config, BlockBehaviour.Properties properties, AABB[] unrotatedAABBs) {
            this(config, properties.isValidSpawn((s, w, p, e) -> false), (List<BlockState> states) -> {
                boolean is_horizontal = (config & 0x10L) != 0L;
                HashMap<BlockState, VoxelShape> vshapes = new HashMap<BlockState, VoxelShape>();
                for (BlockState state : states) {
                    vshapes.put(state, Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, (Direction)state.getValue((Property)FACING), is_horizontal)));
                }
                return vshapes;
            });
        }

        public Directed(long config, BlockBehaviour.Properties properties, AABB unrotatedAABB) {
            this(config, properties, new AABB[]{unrotatedAABB});
        }

        @Override
        public boolean isPossibleToRespawnInThis(BlockState state) {
            return false;
        }

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter source, BlockPos pos, CollisionContext selectionContext) {
            return this.vshapes.get(state);
        }

        @Override
        public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return this.getShape(state, world, pos, selectionContext);
        }

        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{FACING});
        }

        @Override
        @Nullable
        public BlockState getStateForPlacement(BlockPlaceContext context) {
            BlockState state = super.getStateForPlacement(context);
            if (state == null) {
                return null;
            }
            Direction facing = context.getClickedFace();
            if ((this.config & 0x30L) == 48L) {
                facing = context.getHorizontalDirection();
            } else if ((this.config & 0x30L) == 16L) {
                if (facing == Direction.UP || facing == Direction.DOWN) {
                    return null;
                }
            } else if ((this.config & 0x20L) != 0L) {
                facing = context.getNearestLookingDirection();
            }
            if ((this.config & 0x80L) != 0L) {
                facing = facing.getOpposite();
            }
            if ((this.config & 0x200L) != 0L && context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
                facing = facing.getOpposite();
            }
            return (BlockState)state.setValue((Property)FACING, (Comparable)facing);
        }
    }

    public static class WaterLoggable
    extends Cutout
    implements IStandardBlock {
        public WaterLoggable(long config, BlockBehaviour.Properties properties) {
            super(config | 8L, properties);
        }

        public WaterLoggable(long config, BlockBehaviour.Properties properties, AABB aabb) {
            super(config | 8L, properties, aabb);
        }

        public WaterLoggable(long config, BlockBehaviour.Properties properties, VoxelShape voxel_shape) {
            super(config | 8L, properties, voxel_shape);
        }

        public WaterLoggable(long config, BlockBehaviour.Properties properties, AABB[] aabbs) {
            super(config | 8L, properties, aabbs);
        }

        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{WATERLOGGED});
        }
    }

    public static class Cutout
    extends BaseBlock
    implements IStandardBlock {
        private final VoxelShape vshape;

        public Cutout(long conf, BlockBehaviour.Properties properties) {
            this(conf, properties, Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0));
        }

        public Cutout(long conf, BlockBehaviour.Properties properties, AABB aabb) {
            this(conf, properties, Shapes.create((AABB)aabb));
        }

        public Cutout(long conf, BlockBehaviour.Properties properties, AABB[] aabbs) {
            this(conf, properties, Arrays.stream(aabbs).map(Shapes::create).reduce(Shapes.empty(), (shape2, aabb) -> Shapes.joinUnoptimized((VoxelShape)shape2, (VoxelShape)aabb, (BooleanOp)BooleanOp.OR)));
        }

        public Cutout(long conf, BlockBehaviour.Properties properties, VoxelShape voxel_shape) {
            super(conf, properties);
            this.vshape = voxel_shape;
        }

        public VoxelShape getShape(BlockState state, BlockGetter source, BlockPos pos, CollisionContext selectionContext) {
            return this.vshape;
        }

        public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return this.vshape;
        }

        @Nullable
        public BlockState getStateForPlacement(BlockPlaceContext context) {
            BlockState state = super.getStateForPlacement(context);
            if (state == null) {
                return null;
            }
            if ((this.config & 8L) != 0L) {
                FluidState fs = context.getLevel().getFluidState(context.getClickedPos());
                state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.getType() == Fluids.WATER));
            }
            return state;
        }

        public boolean isPossibleToRespawnInThis(BlockState state) {
            return false;
        }

        @Override
        public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
            if ((this.config & 8L) != 0L && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                return false;
            }
            return super.propagatesSkylightDown(state, reader, pos);
        }

        @Override
        public FluidState getFluidState(BlockState state) {
            if ((this.config & 8L) != 0L) {
                return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
            }
            return super.getFluidState(state);
        }

        @Override
        public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
            if ((this.config & 8L) != 0L && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
            }
            return state;
        }
    }

    public static class BaseBlock
    extends Block
    implements IStandardBlock,
    SimpleWaterloggedBlock {
        public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
        public final long config;

        public BaseBlock(long conf, BlockBehaviour.Properties properties) {
            super(properties);
            this.config = conf;
            BlockState state = (BlockState)this.getStateDefinition().any();
            if ((conf & 8L) != 0L) {
                state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            this.registerDefaultState(state);
        }

        @Override
        public long config() {
            return this.config;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
            Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
        }

        @Override
        public IStandardBlock.RenderTypeHint getRenderTypeHint() {
            return this.getRenderTypeHint(this.config);
        }

        public boolean isPathfindable(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
            return (this.config & 0x800L) != 0L && super.isPathfindable(state, world, pos, type);
        }

        public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
            boolean rsup = state.hasBlockEntity() && state.getBlock() != newState.getBlock();
            super.onRemove(state, world, pos, newState, isMoving);
            if (rsup) {
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
        }

        public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
            ServerLevel world = builder.getLevel();
            Float explosion_radius = (Float)builder.getOptionalParameter(LootContextParams.EXPLOSION_RADIUS);
            BlockEntity te = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
            if (!this.hasDynamicDropList() || world == null) {
                return super.getDrops(state, builder);
            }
            boolean is_explosion = explosion_radius != null && explosion_radius.floatValue() > 0.0f;
            return this.dropList(state, (Level)world, te, is_explosion);
        }

        public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
            return ((this.config & 8L) == 0L || (Boolean)state.getValue((Property)WATERLOGGED) == false) && super.propagatesSkylightDown(state, reader, pos);
        }

        public FluidState getFluidState(BlockState state) {
            return (this.config & 8L) != 0L && (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
        }

        public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
            if ((this.config & 8L) != 0L && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
            }
            return state;
        }

        public boolean canPlaceLiquid(@Nullable Player player, BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
            return (this.config & 8L) != 0L && super.canPlaceLiquid(player, world, pos, state, fluid);
        }

        public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
            return (this.config & 8L) != 0L && super.placeLiquid(world, pos, state, fluidState);
        }

        public ItemStack pickupBlock(@Nullable Player player, LevelAccessor world, BlockPos pos, BlockState state) {
            return (this.config & 8L) != 0L ? super.pickupBlock(player, world, pos, state) : ItemStack.EMPTY;
        }

        public Optional<SoundEvent> getPickupSound() {
            return (this.config & 8L) != 0L ? super.getPickupSound() : Optional.empty();
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return state.isRedstoneConductor((BlockGetter)world, pos);
        }
    }

    public static interface IStandardBlock {
        default public long config() {
            return 0L;
        }

        default public boolean hasDynamicDropList() {
            return false;
        }

        default public List<ItemStack> dropList(BlockState state, Level world, @Nullable BlockEntity te, boolean explosion) {
            return Collections.singletonList(!world.isClientSide() ? new ItemStack((ItemLike)state.getBlock().asItem()) : ItemStack.EMPTY);
        }

        default public RenderTypeHint getRenderTypeHint() {
            return this.getRenderTypeHint(this.config());
        }

        default public RenderTypeHint getRenderTypeHint(long config) {
            if ((config & 1L) != 0L) {
                return RenderTypeHint.CUTOUT;
            }
            if ((config & 2L) != 0L) {
                return RenderTypeHint.CUTOUT_MIPPED;
            }
            if ((config & 4L) != 0L) {
                return RenderTypeHint.TRANSLUCENT;
            }
            return RenderTypeHint.SOLID;
        }

        public static enum RenderTypeHint {
            SOLID,
            CUTOUT,
            CUTOUT_MIPPED,
            TRANSLUCENT,
            TRANSLUCENT_NO_CRUMBLING;

        }
    }
}

