/*
 * Decompiled with CFR 0.152.
 */
package com.kettle.jlme.enchantment;

import com.kettle.jlme.configuration.JLMEConfiguration;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;

public class AdvancedProtectionEnchantment
extends Enchantment {
    public AdvancedProtectionEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.ARMOR, slots);
    }

    public int getMaxLevel() {
        return (Integer)JLMEConfiguration.ADVANCED_PROTECTION_LEVELS.get();
    }

    public boolean isDiscoverable() {
        return (Boolean)JLMEConfiguration.ADVANCED_PROTECTION.get();
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)JLMEConfiguration.ADVANCED_PROTECTION.get();
    }

    public int getDamageProtection(int level, DamageSource source) {
        return 1 + level * 1;
    }

    protected boolean checkCompatibility(Enchantment ench) {
        return this != ench && !List.of(Enchantments.ALL_DAMAGE_PROTECTION, Enchantments.FIRE_PROTECTION, Enchantments.BLAST_PROTECTION, Enchantments.PROJECTILE_PROTECTION).contains(ench);
    }
}

