/*
 * Decompiled with CFR 0.152.
 */
package com.kettle.jlme.enchantment;

import com.kettle.jlme.configuration.JLMEConfiguration;
import com.kettle.jlme.init.JlmeModEnchantments;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;

@Mod.EventBusSubscriber
public class CriticalStrikeEnchantment
extends Enchantment {
    public CriticalStrikeEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, slots);
    }

    public boolean canEnchant(ItemStack p_44642_) {
        return (p_44642_.getItem() instanceof AxeItem || super.canEnchant(p_44642_)) && (Boolean)JLMEConfiguration.CRITICAL.get() != false;
    }

    public int getMaxLevel() {
        return (Integer)JLMEConfiguration.CRITICAL_LEVELS.get();
    }

    public boolean isDiscoverable() {
        return (Boolean)JLMEConfiguration.CRITICAL.get();
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)JLMEConfiguration.CRITICAL.get();
    }

    protected boolean checkCompatibility(Enchantment ench) {
        return this != ench && !List.of((Enchantment)JlmeModEnchantments.GIANT_SLAYER.get(), (Enchantment)JlmeModEnchantments.EXECUTIONER.get()).contains(ench) && !List.of((Enchantment)JlmeModEnchantments.ASH_DESTROYER.get()).contains(ench);
    }

    @SubscribeEvent
    public static void onCriticalEvent(CriticalHitEvent event) {
        if (event.getEntity().getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.CRITICAL_STRIKE.get()) > 0) {
            event.setResult(Event.Result.DENY);
        }
    }
}

