/*
 * Decompiled with CFR 0.152.
 */
package com.kettle.jlme.enchantment;

import com.kettle.jlme.configuration.JLMEConfiguration;
import com.kettle.jlme.init.JlmeModEnchantments;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;

@Mod.EventBusSubscriber
public class ShieldedEnchantment
extends Enchantment {
    public ShieldedEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR_CHEST, slots);
    }

    protected boolean checkCompatibility(Enchantment ench) {
        return this != ench && !List.of((Enchantment)JlmeModEnchantments.VITALITY.get()).contains(ench);
    }

    public int getMaxLevel() {
        return (Integer)JLMEConfiguration.SHIELDED_LEVELS.get();
    }

    public boolean isDiscoverable() {
        return (Boolean)JLMEConfiguration.SHIELDED.get();
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)JLMEConfiguration.SHIELDED.get();
    }

    @SubscribeEvent
    public static void onHealEvent(LivingHealEvent event) {
        if (!event.isCanceled() && event.getEntity().getItemBySlot(EquipmentSlot.CHEST).getEnchantmentLevel((Enchantment)JlmeModEnchantments.SHIELDED.get()) > 0) {
            float diff;
            int level = event.getEntity().getItemBySlot(EquipmentSlot.CHEST).getEnchantmentLevel((Enchantment)JlmeModEnchantments.SHIELDED.get());
            float heal = event.getAmount() * (float)(1.0 + (Double)JLMEConfiguration.SHIELDED_INCREASE.get() * (double)level);
            if (event.getEntity().getHealth() + heal > event.getEntity().getMaxHealth() && (diff = event.getEntity().getHealth() + heal - event.getEntity().getMaxHealth()) > 1.0f) {
                float max = (float)((double)level * (Double)JLMEConfiguration.SHIELDED_HEALTH.get());
                if (event.getEntity().hasEffect(MobEffects.ABSORPTION)) {
                    max += (float)((double)(event.getEntity().getEffect(MobEffects.ABSORPTION).getAmplifier() + 1) * 4.0);
                }
                float absorption = Mth.clamp((float)(event.getEntity().getAbsorptionAmount() + diff), (float)0.0f, (float)max);
                event.getEntity().setAbsorptionAmount(absorption);
            }
            event.setAmount(heal);
        }
    }
}

