/*
 * Decompiled with CFR 0.152.
 */
package com.kettle.jlme.enchantment;

import com.kettle.jlme.configuration.JLMEConfiguration;
import com.kettle.jlme.init.JlmeModEnchantments;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class SupremeSharpnessEnchantment
extends Enchantment {
    public SupremeSharpnessEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.WEAPON, slots);
    }

    public int getMaxLevel() {
        return 5;
    }

    public boolean isDiscoverable() {
        return (Boolean)JLMEConfiguration.SUPREME_SHARPNESS.get();
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)JLMEConfiguration.SUPREME_SHARPNESS.get();
    }

    public boolean isTreasureOnly() {
        return true;
    }

    public float getDamageBonus(int p_44635_, MobType p_44636_) {
        return 4.0f + (float)Math.max(0, p_44635_ - 1) * 2.0f;
    }

    public boolean checkCompatibility(Enchantment p_44644_) {
        return this != p_44644_ && !(p_44644_ instanceof DamageEnchantment) && !List.of((Enchantment)JlmeModEnchantments.ADVANCED_SHARPNESS.get()).contains(p_44644_);
    }

    public boolean canEnchant(ItemStack p_44642_) {
        return p_44642_.getItem() instanceof AxeItem ? true : super.canEnchant(p_44642_);
    }

    public boolean isTradeable() {
        return false;
    }
}

