/*
 * Decompiled with CFR 0.152.
 */
package com.kettle.jlme.events;

import com.kettle.jlme.configuration.JLMEConfiguration;
import com.kettle.jlme.init.JlmeModEnchantments;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.living.LivingAttackEvent;

@Mod.EventBusSubscriber
public class AvoidingdamageProcedure {
    private static final Random RANDOM = new Random();

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        float evasiveValue;
        if (event == null || event.isCanceled() || event.getEntity() == null) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        Entity sourceEntity = event.getSource().getEntity();
        if (sourceEntity == null || !(sourceEntity instanceof LivingEntity) || sourceEntity.level().isClientSide()) {
            return;
        }
        Level world = entity.level();
        LivingEntity livingEntity = entity;
        if (livingEntity.isDamageSourceBlocked(event.getSource())) {
            return;
        }
        double PARRY_CHANCE = (Double)JLMEConfiguration.PARRY_CHANCE.get();
        double EVASIVE_CHANCE = (Double)JLMEConfiguration.EVASIVE_CHANCE.get();
        float parryValue = (float)livingEntity.getItemBySlot(EquipmentSlot.MAINHAND).getEnchantmentLevel((Enchantment)JlmeModEnchantments.PARRY.get()) * (float)PARRY_CHANCE;
        float totalChance = parryValue + (evasiveValue = (float)livingEntity.getItemBySlot(EquipmentSlot.LEGS).getEnchantmentLevel((Enchantment)JlmeModEnchantments.EVASIVE.get()) * (float)EVASIVE_CHANCE);
        if (totalChance > 0.0f && RANDOM.nextFloat() <= totalChance) {
            SoundEvent parrySound;
            Level level;
            double which = RANDOM.nextDouble();
            double x = entity.getX();
            double y = entity.getY();
            double z = entity.getZ();
            double evasionRate = evasiveValue / totalChance;
            if (evasiveValue > 0.0f && which <= evasionRate) {
                SoundEvent evasionSound;
                Level level2;
                double angle = Math.atan2(sourceEntity.getZ() - z, sourceEntity.getX() - x);
                boolean side = RANDOM.nextBoolean();
                double deltaX = 1.0 * Math.cos(angle + (side ? 1.5707963267948966 : -1.5707963267948966));
                double deltaZ = 1.0 * Math.sin(angle + (side ? 1.5707963267948966 : -1.5707963267948966));
                entity.hurtMarked = true;
                entity.setDeltaMovement(new Vec3(deltaX, 0.5, deltaZ));
                if (world instanceof Level && !(level2 = world).isClientSide() && (evasionSound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("jlme:evasion_trigger"))) != null) {
                    level2.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), evasionSound, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else if (parryValue > 0.0f && which > evasionRate && world instanceof Level && !(level = world).isClientSide() && (parrySound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("jlme:parry_trigger"))) != null) {
                level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), parrySound, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            event.setCanceled(true);
        }
    }
}

