/*
 * Decompiled with CFR 0.152.
 */
package com.kettle.jlme.events;

import com.kettle.jlme.configuration.JLMEConfiguration;
import com.kettle.jlme.init.JlmeModEnchantments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingHurtEvent;

@Mod.EventBusSubscriber
public class DamageHandler {
    private static Map<DamageSource, Float> originalamount = new HashMap<DamageSource, Float>();
    public static Map<DamageSource, Float> armor = new WeakHashMap<DamageSource, Float>();
    public static Map<DamageSource, Float> enchantments = new WeakHashMap<DamageSource, Float>();
    public static DamageSource lastDamageSource;

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void RegisterInitial(LivingHurtEvent event) {
        if (!event.isCanceled() && event.getEntity() != null && event.getSource().getEntity() instanceof LivingEntity) {
            lastDamageSource = event.getSource();
            armor.put(lastDamageSource, Float.valueOf(0.0f));
            enchantments.put(lastDamageSource, Float.valueOf(0.0f));
            originalamount.put(lastDamageSource, Float.valueOf(event.getAmount()));
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null && event.getSource().getEntity() instanceof LivingEntity && event.getEntity() instanceof LivingEntity) {
            LivingEntity entity = event.getEntity();
            LivingEntity sourceentity = (LivingEntity)event.getSource().getEntity();
            double enve_lvl = sourceentity.getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.ENVENOMED.get());
            double purgelvl = sourceentity.getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.PURGE.get());
            double ashlvl = sourceentity.getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.ASH_DESTROYER.get());
            double bonusdamage = 0.0;
            double viperlvl = sourceentity.getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.VIPER.get());
            double giantlvl = sourceentity.getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.GIANT_SLAYER.get());
            double executioner = sourceentity.getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.EXECUTIONER.get());
            float vulnerability = 0.0f;
            float doubledge = sourceentity.getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.DOUBLE_EDGE.get());
            double amount = event.getAmount();
            int temp = 0;
            double VULNERABILITY_PERCENTAGE = (Double)JLMEConfiguration.VULNERABILITY_PERCENTAGE.get();
            double DE_SELF = (Double)JLMEConfiguration.DE_SELF.get();
            double critical_level = sourceentity.getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.CRITICAL_STRIKE.get());
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack armorPiece;
                if (slot.getType() != EquipmentSlot.Type.ARMOR || (armorPiece = entity.getItemBySlot(slot)).isEmpty() || (temp = armorPiece.getEnchantmentLevel((Enchantment)JlmeModEnchantments.VULNERABILITY.get())) <= 0) continue;
                vulnerability += (float)VULNERABILITY_PERCENTAGE * (float)temp;
            }
            Random random = new Random();
            if (enve_lvl > 0.0) {
                entity.addEffect(new MobEffectInstance(MobEffects.POISON, 60, (int)(enve_lvl - 1.0)));
                entity.addEffect(new MobEffectInstance(MobEffects.WITHER, 60, (int)(enve_lvl - 1.0)));
            }
            if (purgelvl > 0.0 && random.nextDouble() <= (Double)JLMEConfiguration.PURGE_CHANCE.get() * purgelvl) {
                Collection activeEffects = entity.getActiveEffects();
                ArrayList<MobEffectInstance> positiveEffects = new ArrayList<MobEffectInstance>();
                for (MobEffectInstance effect : activeEffects) {
                    if (!effect.getEffect().isBeneficial()) continue;
                    positiveEffects.add(effect);
                }
                if (!positiveEffects.isEmpty()) {
                    MobEffectInstance effectToRemove = (MobEffectInstance)positiveEffects.get(random.nextInt(positiveEffects.size()));
                    entity.removeEffect(effectToRemove.getEffect());
                    bonusdamage += 0.5 * purgelvl;
                }
            }
            if (viperlvl > 0.0) {
                if (entity.hasEffect(MobEffects.POISON)) {
                    bonusdamage = bonusdamage + (Double)JLMEConfiguration.VIPER_POISON_BASE.get() + (Double)JLMEConfiguration.VIPER_POISON_LEVEL.get() * viperlvl;
                }
                if (entity.hasEffect(MobEffects.WITHER)) {
                    bonusdamage = bonusdamage + (Double)JLMEConfiguration.VIPER_WITHER_BASE.get() + (Double)JLMEConfiguration.VIPER_WITHER_LEVEL.get() * viperlvl;
                }
            }
            if (vulnerability > 0.0f) {
                bonusdamage += (bonusdamage + amount) * (double)vulnerability;
            }
            if (giantlvl > 0.0) {
                bonusdamage += (double)entity.getMaxHealth() * ((Double)JLMEConfiguration.GIANT_DMG.get() + (Double)JLMEConfiguration.GIANT_LEVEL_DMG.get() * giantlvl);
            }
            if (executioner > 0.0) {
                bonusdamage += (double)(entity.getMaxHealth() - entity.getHealth()) * ((Double)JLMEConfiguration.EXECUTIONER_DMG.get() + (Double)JLMEConfiguration.EXECUTIONER_LEVEL_DMG.get() * executioner);
            }
            if (ashlvl > 0.0 && entity.isOnFire() && !entity.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                bonusdamage += (bonusdamage + amount) * (Double)JLMEConfiguration.ASH_DMG.get() * ashlvl;
            }
            if (doubledge > 0.0f) {
                bonusdamage += (bonusdamage + amount) * (Double)JLMEConfiguration.DE_DMG.get();
                sourceentity.hurt(event.getSource(), ((float)amount + (float)bonusdamage) * (float)DE_SELF);
            }
            if (critical_level > 0.0 && random.nextDouble() <= (Double)JLMEConfiguration.CRITICAL_CHANCE.get() * critical_level) {
                bonusdamage += (bonusdamage + amount) * ((Double)JLMEConfiguration.CRITICAL_DMG.get() + (Double)JLMEConfiguration.CRITICAL_LEVEL_DMG.get() * critical_level);
                SoundEvent critSound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("jlme:critical_strike"));
                if (critSound != null) {
                    entity.level().playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), critSound, SoundSource.PLAYERS, 0.25f, 1.0f);
                }
            }
            if (bonusdamage > 0.0) {
                event.setAmount((float)amount + (float)bonusdamage);
                originalamount.replace(event.getSource(), Float.valueOf((float)amount + (float)bonusdamage));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void DefenseBypass(LivingDamageEvent event) {
        if (!event.isCanceled() && event.getEntity() != null && event.getSource().getEntity() != null && event.getSource().getEntity() instanceof LivingEntity) {
            float diff;
            LivingEntity sourceentity = (LivingEntity)event.getSource().getEntity();
            float pclvl = sourceentity.getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.PIERCING_CAPABILITIES.get());
            float arrow_piercing = sourceentity.getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.ARROW_PIERCING.get());
            float armor_piercing = sourceentity.getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.ARMOR_PIERCING.get());
            float magic_piercing = sourceentity.getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.MAGIC_PIERCING.get());
            if (armor_piercing > 0.0f && armor.get(event.getSource()) != null && armor.get(event.getSource()).floatValue() > 0.0f) {
                event.setAmount(event.getAmount() + armor.get(event.getSource()).floatValue() * (float)((Double)JLMEConfiguration.ARMOR_PIERCING_PERCENTAGE.get() * (double)armor_piercing));
            }
            if (magic_piercing > 0.0f && enchantments.get(event.getSource()) != null && enchantments.get(event.getSource()).floatValue() > 0.0f) {
                event.setAmount(event.getAmount() + enchantments.get(event.getSource()).floatValue() * (float)((Double)JLMEConfiguration.MAGIC_PIERCING_PERCENTAGE.get() * (double)magic_piercing));
            }
            if (pclvl > 0.0f && originalamount.get(event.getSource()) != null) {
                diff = originalamount.get(event.getSource()).floatValue() - event.getAmount();
                event.setAmount((float)((double)event.getAmount() + (double)diff * ((Double)JLMEConfiguration.PC_PERCENTAGE.get() * (double)pclvl)));
            }
            if (arrow_piercing > 0.0f && originalamount.get(event.getSource()) != null && event.getSource().getDirectEntity() instanceof AbstractArrow) {
                diff = originalamount.get(event.getSource()).floatValue() - event.getAmount();
                event.setAmount((float)((double)event.getAmount() + (double)diff * ((Double)JLMEConfiguration.AP_PERCENTAGE.get() * (double)arrow_piercing)));
            }
        }
    }

    @SubscribeEvent
    public static void AdvProtection(LivingDamageEvent event) {
        if (!event.isCanceled() && event.getEntity() != null && event.getEntity() instanceof LivingEntity && event.getSource().getEntity() instanceof LivingEntity) {
            LivingEntity entity;
            LivingEntity dum = entity = event.getEntity();
            float k = 0.0f;
            for (ItemStack stack : dum.getArmorSlots()) {
                float i;
                if (stack == null || !((i = (float)stack.getEnchantmentLevel((Enchantment)JlmeModEnchantments.ADVANCED_PROTECTION.get())) > 0.0f)) continue;
                k = k + 1.0f + i;
            }
            if (k > 0.0f) {
                event.setAmount(event.getAmount() * (1.0f - k * 0.025f));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void LastModification(LivingDamageEvent event) {
        if (event != null && event.getEntity() != null && event.getSource().getEntity() != null && event.getSource().getEntity() instanceof LivingEntity) {
            LivingEntity sourceentity = (LivingEntity)event.getSource().getEntity();
            double life_lvl = sourceentity.getMainHandItem().getEnchantmentLevel((Enchantment)JlmeModEnchantments.LIFESTEAL.get());
            if (life_lvl > 0.0) {
                sourceentity.heal((float)((double)event.getAmount() * (Double)JLMEConfiguration.LIFESTEAL_STEAL.get() * life_lvl));
            }
            originalamount.replace(event.getSource(), Float.valueOf(0.0f));
        }
    }
}

