/*
 * Decompiled with CFR 0.152.
 */
package com.kettle.jlme.mixin;

import com.kettle.jlme.events.DamageHandler;
import net.minecraft.world.damagesource.CombatRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CombatRules.class})
public class CombatRulesMixin {
    @Inject(method={"getDamageAfterAbsorb"}, at={@At(value="RETURN")}, cancellable=true)
    private static void captureArmorReduction(float damage, float armorValue, float toughness, CallbackInfoReturnable<Float> cir) {
        if (DamageHandler.lastDamageSource != null && DamageHandler.armor.get(DamageHandler.lastDamageSource) != null) {
            float originalDamage = damage;
            float reducedDamage = ((Float)cir.getReturnValue()).floatValue();
            DamageHandler.armor.put(DamageHandler.lastDamageSource, Float.valueOf(originalDamage - reducedDamage));
        }
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="RETURN")}, cancellable=true)
    private static void captureEnchantmentReduction(float damage, float armorValue, CallbackInfoReturnable<Float> cir) {
        if (DamageHandler.lastDamageSource != null && DamageHandler.enchantments.get(DamageHandler.lastDamageSource) != null) {
            float originalDamage = damage;
            float reducedDamage = ((Float)cir.getReturnValue()).floatValue();
            DamageHandler.enchantments.put(DamageHandler.lastDamageSource, Float.valueOf(originalDamage - reducedDamage));
        }
    }
}

