/*
 * Decompiled with CFR 0.152.
 */
package com.kettle.jlme.network;

import com.kettle.jlme.JlmeMod;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class JlmeModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"jlme");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());
    public static double damagedone = 0.0;
    public static double initialhealth = 0.0;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        JlmeMod.addNetworkMessage(PlayerVariablesSyncMessage.ID, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handleData);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final ResourceLocation ID = new ResourceLocation("jlme", "player_variables_sync");

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this(new PlayerVariables());
            this.data.deserializeNBT(buffer.readNbt());
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeNbt((Tag)this.data.serializeNBT());
        }

        public ResourceLocation id() {
            return ID;
        }

        public static void handleData(PlayerVariablesSyncMessage message, PlayPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.workHandler().submitAsync(() -> ((PlayerVariables)Minecraft.getInstance().player.getData(PLAYER_VARIABLES)).deserializeNBT(message.data.serializeNBT())).exceptionally(e -> {
                    context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean pants = false;
        public boolean helmet = false;
        public boolean chest = false;
        public boolean boots = false;
        public double health_added = 0.0;
        public boolean pants_changed = false;
        public boolean chest_changed = false;
        public double movspeed_added = 0.0;
        public boolean helmet_changed = false;
        public boolean boots_changed = false;

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("pants", this.pants);
            nbt.putBoolean("helmet", this.helmet);
            nbt.putBoolean("chest", this.chest);
            nbt.putBoolean("boots", this.boots);
            nbt.putDouble("health_added", this.health_added);
            nbt.putBoolean("pants_changed", this.pants_changed);
            nbt.putBoolean("chest_changed", this.chest_changed);
            nbt.putDouble("movspeed_added", this.movspeed_added);
            nbt.putBoolean("helmet_changed", this.helmet_changed);
            nbt.putBoolean("boots_changed", this.boots_changed);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.pants = nbt.getBoolean("pants");
            this.helmet = nbt.getBoolean("helmet");
            this.chest = nbt.getBoolean("chest");
            this.boots = nbt.getBoolean("boots");
            this.health_added = nbt.getDouble("health_added");
            this.pants_changed = nbt.getBoolean("pants_changed");
            this.chest_changed = nbt.getBoolean("chest_changed");
            this.movspeed_added = nbt.getDouble("movspeed_added");
            this.helmet_changed = nbt.getBoolean("helmet_changed");
            this.boots_changed = nbt.getBoolean("boots_changed");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.PLAYER.with((Object)serverPlayer).send(new CustomPacketPayload[]{new PlayerVariablesSyncMessage(this)});
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.pants = original.pants;
            clone.helmet = original.helmet;
            clone.chest = original.chest;
            clone.boots = original.boots;
            clone.health_added = original.health_added;
            clone.pants_changed = original.pants_changed;
            clone.chest_changed = original.chest_changed;
            clone.movspeed_added = original.movspeed_added;
            clone.helmet_changed = original.helmet_changed;
            clone.boots_changed = original.boots_changed;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }
    }
}

