/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.animation;

import de.keksuccino.fancymenu.customization.animation.ResourcePackAnimationRenderer;
import de.keksuccino.fancymenu.customization.animation.exceptions.AnimationNotFoundException;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.resource.PlayableResource;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import de.keksuccino.konkrete.rendering.animation.ExternalTextureAnimationRenderer;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedAnimation
implements IAnimationRenderer,
RenderableResource,
PlayableResource {
    private final IAnimationRenderer introRenderer;
    private final IAnimationRenderer animationRenderer;
    private boolean started = false;
    private final String mainAudioPath;
    private final String introAudioPath;
    private boolean muted = false;
    private final boolean replayIntro;
    public String propertiesPath = null;
    protected boolean prepared = false;
    protected boolean playing = false;

    public AdvancedAnimation(@Nullable IAnimationRenderer introAnimation, IAnimationRenderer mainAnimation, @Nullable String introAudioPath, @Nullable String mainAudioPath, boolean replayIntro) throws AnimationNotFoundException {
        if (mainAnimation == null) {
            throw new AnimationNotFoundException("Animation cannot be null!");
        }
        this.animationRenderer = mainAnimation;
        this.introRenderer = introAnimation;
        this.mainAudioPath = mainAudioPath;
        this.introAudioPath = introAudioPath;
        this.replayIntro = replayIntro;
    }

    public boolean hasIntro() {
        return this.introRenderer != null;
    }

    @Override
    @Nullable
    public InputStream open() throws IOException {
        return null;
    }

    @Override
    public boolean isReady() {
        if (this.animationRenderer != null && this.hasIntro()) {
            if (this.animationRenderer.isReady() && this.introRenderer.isReady()) {
                return true;
            }
        } else if (this.animationRenderer != null) {
            return this.animationRenderer.isReady();
        }
        return false;
    }

    @Override
    public boolean isLoadingCompleted() {
        return true;
    }

    @Override
    public boolean isLoadingFailed() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public void prepareAnimation() {
        if (!this.prepared) {
            if (this.animationRenderer != null) {
                this.animationRenderer.prepareAnimation();
            }
            if (this.hasIntro()) {
                this.introRenderer.prepareAnimation();
            }
            this.prepared = true;
        }
    }

    public void resetAnimation() {
        this.stopAudio();
        this.resetAudio();
        if (this.animationRenderer != null) {
            this.animationRenderer.resetAnimation();
        }
        if (this.hasIntro()) {
            this.introRenderer.resetAnimation();
        }
        this.started = false;
    }

    public boolean hasStarted() {
        return this.started;
    }

    @Deprecated
    public void render(GuiGraphics graphics) {
        if (this.isReady()) {
            this.playing = true;
            this.started = true;
            if (!this.muted) {
                if (this.hasIntroAudio() && !this.introRenderer.isFinished() && (this.introRenderer.currentFrame() == 1 || this.introRenderer.currentFrame() > 1 && !SoundHandler.isPlaying((String)this.introAudioPath))) {
                    SoundHandler.stopSound((String)this.mainAudioPath);
                    SoundHandler.registerSound((String)this.introAudioPath, (String)this.introAudioPath);
                    SoundHandler.resetSound((String)this.introAudioPath);
                    SoundHandler.playSound((String)this.introAudioPath);
                }
                if (this.hasIntroAudio() && this.introRenderer.isFinished()) {
                    SoundHandler.stopSound((String)this.introAudioPath);
                }
                if (this.hasMainAudio() && !this.animationRenderer.isFinished() && (this.animationRenderer.currentFrame() == 1 || this.animationRenderer.currentFrame() > 1 && !SoundHandler.isPlaying((String)this.mainAudioPath))) {
                    if (this.hasIntroAudio()) {
                        SoundHandler.stopSound((String)this.introAudioPath);
                    }
                    SoundHandler.registerSound((String)this.mainAudioPath, (String)this.mainAudioPath);
                    SoundHandler.resetSound((String)this.mainAudioPath);
                    SoundHandler.playSound((String)this.mainAudioPath);
                    SoundHandler.setLooped((String)this.mainAudioPath, (boolean)true);
                }
            }
            if (this.hasIntro()) {
                this.introRenderer.setFPS(this.animationRenderer.getFPS());
                this.introRenderer.setWidth(this.animationRenderer.getWidth());
                this.introRenderer.setHeight(this.animationRenderer.getHeight());
                this.introRenderer.setPosX(this.animationRenderer.getPosX());
                this.introRenderer.setPosY(this.animationRenderer.getPosY());
                this.introRenderer.setLooped(false);
                if (!this.introRenderer.isFinished()) {
                    if (AdvancedAnimation.canRenderFrameOf(this.introRenderer, this.introRenderer.currentFrame())) {
                        this.introRenderer.render(graphics);
                    }
                } else if (AdvancedAnimation.canRenderFrameOf(this.animationRenderer, this.animationRenderer.currentFrame())) {
                    this.animationRenderer.render(graphics);
                }
            } else if (AdvancedAnimation.canRenderFrameOf(this.animationRenderer, this.animationRenderer.currentFrame())) {
                this.animationRenderer.render(graphics);
            }
        }
        if (this.isFinished() || this.muted) {
            this.stopAudio();
        }
    }

    public void setStretchImageToScreensize(boolean b) {
        if (this.hasIntro()) {
            this.introRenderer.setStretchImageToScreensize(b);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setStretchImageToScreensize(b);
        }
    }

    public void setHideAfterLastFrame(boolean b) {
        if (this.hasIntro()) {
            this.introRenderer.setHideAfterLastFrame(b);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setHideAfterLastFrame(b);
        }
    }

    public boolean isFinished() {
        if (this.hasIntro() && this.animationRenderer != null) {
            if (this.introRenderer.isFinished() && this.animationRenderer.isFinished()) {
                return true;
            }
        } else if (this.animationRenderer != null) {
            return this.animationRenderer.isFinished();
        }
        return false;
    }

    public void setWidth(int width) {
        if (this.hasIntro()) {
            this.introRenderer.setWidth(width);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setWidth(width);
        }
    }

    public void setHeight(int height) {
        if (this.hasIntro()) {
            this.introRenderer.setHeight(height);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setHeight(height);
        }
    }

    public void setPosX(int x) {
        if (this.hasIntro()) {
            this.introRenderer.setPosX(x);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setPosX(x);
        }
    }

    public void setPosY(int y) {
        if (this.hasIntro()) {
            this.introRenderer.setPosY(y);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setPosY(y);
        }
    }

    public int currentFrame() {
        int i = 0;
        if (this.hasIntro()) {
            i = this.introRenderer.currentFrame();
        }
        if (this.animationRenderer != null) {
            i += this.animationRenderer.currentFrame();
        }
        return i;
    }

    public int animationFrames() {
        int i = 0;
        if (this.hasIntro()) {
            i = this.introRenderer.animationFrames();
        }
        if (this.animationRenderer != null) {
            i += this.animationRenderer.animationFrames();
        }
        return i;
    }

    public String getPath() {
        if (this.animationRenderer != null) {
            return new File(this.animationRenderer.getPath()).toPath().getParent().toString();
        }
        return null;
    }

    public void setFPS(int fps) {
        if (this.hasIntro()) {
            this.introRenderer.setFPS(fps);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setFPS(fps);
        }
    }

    public void setLooped(boolean b) {
        if (this.animationRenderer != null) {
            this.animationRenderer.setLooped(b);
        }
    }

    public int getFPS() {
        if (this.animationRenderer != null) {
            return this.animationRenderer.getFPS();
        }
        return 0;
    }

    public boolean isGettingLooped() {
        return this.animationRenderer.isGettingLooped();
    }

    public boolean isStretchedToStreensize() {
        if (this.animationRenderer != null) {
            return this.animationRenderer.isStretchedToStreensize();
        }
        return false;
    }

    @Override
    public int getWidth() {
        return this.animationRenderer.getWidth();
    }

    @Override
    public int getHeight() {
        return this.animationRenderer.getHeight();
    }

    @Override
    @NotNull
    public AspectRatio getAspectRatio() {
        return null;
    }

    public int getPosX() {
        return this.animationRenderer.getPosX();
    }

    public int getPosY() {
        return this.animationRenderer.getPosY();
    }

    public void setMuteAudio(boolean b) {
        this.muted = b;
    }

    public boolean hasMainAudio() {
        return this.mainAudioPath != null;
    }

    public boolean hasIntroAudio() {
        return this.hasIntro() && this.introAudioPath != null;
    }

    public void stopAudio() {
        SoundHandler.stopSound((String)this.mainAudioPath);
        if (this.hasIntro()) {
            SoundHandler.stopSound((String)this.introAudioPath);
        }
    }

    public void resetAudio() {
        SoundHandler.resetSound((String)this.mainAudioPath);
        if (this.hasIntro()) {
            SoundHandler.resetSound((String)this.introAudioPath);
        }
    }

    public IAnimationRenderer getMainAnimationRenderer() {
        return this.animationRenderer;
    }

    public IAnimationRenderer getIntroAnimationRenderer() {
        return this.introRenderer;
    }

    public boolean replayIntro() {
        return this.replayIntro;
    }

    public void setOpacity(float opacity) {
        if (this.animationRenderer != null) {
            this.animationRenderer.setOpacity(opacity);
        }
        if (this.introRenderer != null) {
            this.introRenderer.setOpacity(opacity);
        }
    }

    protected static void tickRenderer(@NotNull IAnimationRenderer renderer) {
        List<ResourceLocation> frames = AdvancedAnimation.getFramesOf(renderer);
        int fps = renderer.getFPS();
        if (frames.isEmpty()) {
            return;
        }
        if (fps <= 0) {
            fps = -1;
        }
        if (renderer.currentFrame() >= frames.size() && renderer.isGettingLooped()) {
            renderer.resetAnimation();
        }
        Consumer<Long> updateFrameInvoker = time -> {
            if (renderer.currentFrame() >= frames.size()) {
                return;
            }
            try {
                if (renderer instanceof ResourcePackAnimationRenderer) {
                    ResourcePackAnimationRenderer r = (ResourcePackAnimationRenderer)renderer;
                    r.updateFrame((long)time);
                } else if (renderer instanceof ExternalTextureAnimationRenderer) {
                    ExternalTextureAnimationRenderer e = (ExternalTextureAnimationRenderer)renderer;
                    Method m = ExternalTextureAnimationRenderer.class.getDeclaredMethod("updateFrame", Long.TYPE);
                    m.setAccessible(true);
                    m.invoke((Object)e, time);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        Supplier<Long> prevTimeSupplier = () -> {
            try {
                if (renderer instanceof ResourcePackAnimationRenderer) {
                    ResourcePackAnimationRenderer r = (ResourcePackAnimationRenderer)renderer;
                    return r.prevTime;
                }
                if (renderer instanceof ExternalTextureAnimationRenderer) {
                    ExternalTextureAnimationRenderer e = (ExternalTextureAnimationRenderer)renderer;
                    Field f = ExternalTextureAnimationRenderer.class.getDeclaredField("prevTime");
                    f.setAccessible(true);
                    return (Long)f.get(e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0L;
        };
        long time2 = System.currentTimeMillis();
        if (fps == -1) {
            updateFrameInvoker.accept(time2);
        } else if (prevTimeSupplier.get() + (long)(1000 / fps) <= time2) {
            updateFrameInvoker.accept(time2);
        }
    }

    @NotNull
    protected static List<ResourceLocation> getFramesOf(@NotNull IAnimationRenderer renderer) {
        try {
            if (renderer.isReady()) {
                if (renderer instanceof ResourcePackAnimationRenderer) {
                    ResourcePackAnimationRenderer r = (ResourcePackAnimationRenderer)renderer;
                    return r.resources;
                }
                if (renderer instanceof ExternalTextureAnimationRenderer) {
                    ExternalTextureAnimationRenderer e = (ExternalTextureAnimationRenderer)renderer;
                    Field f = ExternalTextureAnimationRenderer.class.getDeclaredField("resources");
                    f.setAccessible(true);
                    List resources = (List)f.get(renderer);
                    ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
                    for (ExternalTextureResourceLocation external : resources) {
                        ResourceLocation loc = external.getResourceLocation();
                        if (loc == null) {
                            loc = FULLY_TRANSPARENT_TEXTURE;
                        }
                        locations.add(loc);
                    }
                    return locations;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<ResourceLocation>();
    }

    @Nullable
    protected static ResourceLocation getCurrentFrameOf(@NotNull IAnimationRenderer renderer) {
        List<ResourceLocation> locations = AdvancedAnimation.getFramesOf(renderer);
        if (!locations.isEmpty()) {
            if (renderer.currentFrame() < locations.size()) {
                return locations.get(renderer.currentFrame());
            }
            return locations.get(locations.size() - 1);
        }
        return null;
    }

    protected static boolean canRenderFrameOf(@NotNull IAnimationRenderer renderer, int frame) {
        block8: {
            try {
                if (!renderer.isReady()) break block8;
                if (renderer instanceof ResourcePackAnimationRenderer) {
                    List<ResourceLocation> l = ((ResourcePackAnimationRenderer)renderer).resources;
                    if (!l.isEmpty()) {
                        if (l.size() > frame) {
                            ResourceLocation r = l.get(frame);
                            Resource res = (Resource)Minecraft.getInstance().getResourceManager().getResource(r).get();
                            return res != null;
                        }
                        return true;
                    }
                    break block8;
                }
                if (renderer instanceof ExternalTextureAnimationRenderer) {
                    Field f = ExternalTextureAnimationRenderer.class.getDeclaredField("resources");
                    f.setAccessible(true);
                    List l = (List)f.get(renderer);
                    if (l != null && l.size() > frame) {
                        ResourceLocation r = ((ExternalTextureResourceLocation)l.get(frame)).getResourceLocation();
                        if (r != null) {
                            Resource res = (Resource)Minecraft.getInstance().getResourceManager().getResource(r).get();
                            return res != null;
                        }
                        break block8;
                    }
                    return true;
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void play() {
        this.playing = true;
        this.started = true;
    }

    @Override
    public void pause() {
        this.playing = false;
        this.stopAudio();
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public void stop() {
        this.playing = false;
        this.started = false;
        this.resetAnimation();
        this.stopAudio();
    }

    @Override
    public boolean isPlaying() {
        return !this.isFinished() && this.playing;
    }

    @Override
    @Nullable
    public ResourceLocation getResourceLocation() {
        if (!this.playing) {
            return null;
        }
        if (!this.muted) {
            if (this.hasIntroAudio() && !this.introRenderer.isFinished() && (this.introRenderer.currentFrame() == 1 || this.introRenderer.currentFrame() > 1 && !SoundHandler.isPlaying((String)this.introAudioPath))) {
                SoundHandler.stopSound((String)this.mainAudioPath);
                SoundHandler.registerSound((String)this.introAudioPath, (String)this.introAudioPath);
                SoundHandler.resetSound((String)this.introAudioPath);
                SoundHandler.playSound((String)this.introAudioPath);
            }
            if (this.hasIntroAudio() && this.introRenderer.isFinished()) {
                SoundHandler.stopSound((String)this.introAudioPath);
            }
            if (this.hasMainAudio() && !this.animationRenderer.isFinished() && (this.animationRenderer.currentFrame() == 1 || this.animationRenderer.currentFrame() > 1 && !SoundHandler.isPlaying((String)this.mainAudioPath))) {
                if (this.hasIntroAudio()) {
                    SoundHandler.stopSound((String)this.introAudioPath);
                }
                SoundHandler.registerSound((String)this.mainAudioPath, (String)this.mainAudioPath);
                SoundHandler.resetSound((String)this.mainAudioPath);
                SoundHandler.playSound((String)this.mainAudioPath);
                SoundHandler.setLooped((String)this.mainAudioPath, (boolean)true);
            }
        }
        if (this.hasIntro()) {
            this.introRenderer.setFPS(this.animationRenderer.getFPS());
            this.introRenderer.setLooped(false);
            if (!this.introRenderer.isFinished()) {
                ResourceLocation current = AdvancedAnimation.getCurrentFrameOf(this.introRenderer);
                AdvancedAnimation.tickRenderer(this.introRenderer);
                return current;
            }
        }
        ResourceLocation current = AdvancedAnimation.getCurrentFrameOf(this.animationRenderer);
        AdvancedAnimation.tickRenderer(this.animationRenderer);
        return current;
    }

    @Override
    public void reset() {
        this.playing = false;
        this.resetAnimation();
    }

    @Override
    public void close() throws IOException {
    }
}

