/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.variables;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.variables.Variable;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedEnumValueCycle;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.TextInputScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageVariablesScreen
extends Screen {
    protected Consumer<List<Variable>> callback;
    protected ScrollArea variableListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton doneButton;
    protected ExtendedButton setValueButton;
    protected ExtendedButton deleteVariableButton;
    protected ExtendedButton addVariableButton;
    protected ExtendedButton toggleResetOnLaunchButton;

    public ManageVariablesScreen(@NotNull Consumer<List<Variable>> callback) {
        super((Component)Component.translatable((String)"fancymenu.overlay.menu_bar.variables.manage"));
        this.callback = callback;
        this.updateVariableScrollArea();
    }

    protected void init() {
        this.addVariableButton = new ExtendedButton(0, 0, 220, 20, (Component)Component.translatable((String)"fancymenu.overlay.menu_bar.variables.manage.add_variable"), button -> {
            TextInputScreen s = new TextInputScreen((Component)Component.translatable((String)"fancymenu.overlay.menu_bar.variables.manage.add_variable.input_name"), CharacterFilter.buildOnlyLowercaseFileNameFilter(), call -> {
                if (call != null && !VariableHandler.variableExists(call)) {
                    VariableHandler.setVariable(call, "");
                    this.updateVariableScrollArea();
                }
                Minecraft.getInstance().setScreen((Screen)this);
            });
            Minecraft.getInstance().setScreen((Screen)s);
        });
        this.addWidget((GuiEventListener)this.addVariableButton);
        UIBase.applyDefaultWidgetSkinTo(this.addVariableButton);
        this.setValueButton = new ExtendedButton(0, 0, 220, 20, (Component)Component.translatable((String)"fancymenu.overlay.menu_bar.variables.manage.set_value"), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                TextInputScreen s = new TextInputScreen((Component)Component.translatable((String)"fancymenu.overlay.menu_bar.variables.manage.set_value"), null, call -> {
                    if (call != null) {
                        e.variable.setValue((String)call);
                    }
                    Minecraft.getInstance().setScreen((Screen)this);
                });
                s.setText(e.variable.getValue());
                Minecraft.getInstance().setScreen((Screen)s);
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null);
        this.addWidget((GuiEventListener)this.setValueButton);
        UIBase.applyDefaultWidgetSkinTo(this.setValueButton);
        this.deleteVariableButton = new ExtendedButton(0, 0, 220, 20, (Component)Component.translatable((String)"fancymenu.overlay.menu_bar.variables.manage.delete_variable"), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                Minecraft.getInstance().setScreen((Screen)ConfirmationScreen.ofStrings(call -> {
                    if (call.booleanValue()) {
                        VariableHandler.removeVariable(e.variable.getName());
                        this.updateVariableScrollArea();
                    }
                    Minecraft.getInstance().setScreen((Screen)this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.overlay.menu_bar.variables.manage.delete_variable.confirm", new String[0])));
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null);
        this.addWidget((GuiEventListener)this.deleteVariableButton);
        UIBase.applyDefaultWidgetSkinTo(this.deleteVariableButton);
        LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> resetOnLaunchDisabled = CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.variables.manage.clear_on_launch", false);
        this.toggleResetOnLaunchButton = new ExtendedButton(0, 0, 220, 20, (Component)Component.empty(), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                e.variable.setResetOnLaunch(!e.variable.isResetOnLaunch());
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null).setLabelSupplier(consumes -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> enabledDisabled = CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.variables.manage.clear_on_launch");
                enabledDisabled.setCurrentValue(CommonCycles.CycleEnabledDisabled.getByBoolean(e.variable.isResetOnLaunch()));
                return enabledDisabled.getCycleComponent();
            }
            return resetOnLaunchDisabled.getCycleComponent();
        });
        this.addWidget((GuiEventListener)this.toggleResetOnLaunchButton);
        UIBase.applyDefaultWidgetSkinTo(this.toggleResetOnLaunchButton);
        this.doneButton = new ExtendedButton(0, 0, 220, 20, (Component)Component.translatable((String)"fancymenu.guicomponents.done"), button -> this.callback.accept(VariableHandler.getVariables()));
        this.addWidget((GuiEventListener)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
    }

    public void onClose() {
        this.callback.accept(VariableHandler.getVariables());
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        RenderSystem.enableBlend();
        graphics.fill(0, 0, this.width, this.height, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.title.copy().withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
        graphics.drawString(this.font, (Component)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"fancymenu.overlay.menu_bar.variables.manage.variables"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.variableListScrollArea.setWidth(this.width / 2 - 40, true);
        this.variableListScrollArea.setHeight(this.height - 85, true);
        this.variableListScrollArea.setX(20, true);
        this.variableListScrollArea.setY(65, true);
        this.variableListScrollArea.render(graphics, mouseX, mouseY, partial);
        int buttonWidth = this.width - 20 - (this.variableListScrollArea.getXWithBorder() + (this.variableListScrollArea.getWidthWithBorder() + 20));
        if (buttonWidth < 150) {
            buttonWidth = 150;
        }
        if (buttonWidth > 220) {
            buttonWidth = 220;
        }
        this.doneButton.setWidth(buttonWidth);
        this.doneButton.setX(this.width - 20 - this.doneButton.getWidth());
        this.doneButton.setY(this.height - 20 - 20);
        this.doneButton.render(graphics, mouseX, mouseY, partial);
        this.toggleResetOnLaunchButton.setWidth(buttonWidth);
        this.toggleResetOnLaunchButton.setX(this.width - 20 - this.toggleResetOnLaunchButton.getWidth());
        this.toggleResetOnLaunchButton.setY(this.doneButton.getY() - 15 - 20);
        this.toggleResetOnLaunchButton.render(graphics, mouseX, mouseY, partial);
        this.deleteVariableButton.setWidth(buttonWidth);
        this.deleteVariableButton.setX(this.width - 20 - this.deleteVariableButton.getWidth());
        this.deleteVariableButton.setY(this.toggleResetOnLaunchButton.getY() - 5 - 20);
        this.deleteVariableButton.render(graphics, mouseX, mouseY, partial);
        this.setValueButton.setWidth(buttonWidth);
        this.setValueButton.setX(this.width - 20 - this.setValueButton.getWidth());
        this.setValueButton.setY(this.deleteVariableButton.getY() - 5 - 20);
        this.setValueButton.render(graphics, mouseX, mouseY, partial);
        this.addVariableButton.setWidth(buttonWidth);
        this.addVariableButton.setX(this.width - 20 - this.addVariableButton.getWidth());
        this.addVariableButton.setY(this.setValueButton.getY() - 15 - 20);
        this.addVariableButton.render(graphics, mouseX, mouseY, partial);
        super.render(graphics, mouseX, mouseY, partial);
    }

    public void renderBackground(@NotNull GuiGraphics $$0, int $$1, int $$2, float $$3) {
    }

    @Nullable
    protected VariableScrollEntry getSelectedEntry() {
        for (ScrollAreaEntry e : this.variableListScrollArea.getEntries()) {
            VariableScrollEntry s;
            if (!(e instanceof VariableScrollEntry) || !(s = (VariableScrollEntry)e).isSelected()) continue;
            return s;
        }
        return null;
    }

    protected void updateVariableScrollArea() {
        this.variableListScrollArea.clearEntries();
        for (Variable v : VariableHandler.getVariables()) {
            VariableScrollEntry e = new VariableScrollEntry(this.variableListScrollArea, v, entry -> {});
            this.variableListScrollArea.addEntry(e);
        }
        if (this.variableListScrollArea.getEntries().isEmpty()) {
            this.variableListScrollArea.addEntry(new TextScrollAreaEntry(this.variableListScrollArea, (Component)Component.translatable((String)"fancymenu.overlay.menu_bar.variables.manage.no_variables").setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().error_text_color.getColorInt())), entry -> {}));
        }
    }

    public static class VariableScrollEntry
    extends TextListScrollAreaEntry {
        public Variable variable;

        public VariableScrollEntry(ScrollArea parent, @NotNull Variable variable, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, (Component)Component.literal((String)variable.name).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.variable = variable;
        }
    }
}

