/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.filebrowser;

import de.keksuccino.fancymenu.util.rendering.ui.screen.filebrowser.AbstractFileBrowserScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.io.File;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseFileScreen
extends AbstractFileBrowserScreen {
    @NotNull
    public static ChooseFileScreen build(@NotNull File rootDirectory, @NotNull Consumer<File> callback) {
        return new ChooseFileScreen(rootDirectory, rootDirectory, callback);
    }

    public ChooseFileScreen(@Nullable File rootDirectory, @NotNull File startDirectory, @NotNull Consumer<File> callback) {
        super((Component)Component.translatable((String)"fancymenu.ui.filechooser.choose.file"), rootDirectory, startDirectory, callback);
    }

    @Override
    @NotNull
    protected ExtendedButton buildConfirmButton() {
        return new ExtendedButton(0, 0, 150, 20, (Component)Component.translatable((String)"fancymenu.guicomponents.ok"), button -> {
            AbstractFileBrowserScreen.AbstractFileScrollAreaEntry selected = this.getSelectedEntry();
            if (selected != null && !selected.resourceUnfriendlyFileName) {
                this.callback.accept(new File(selected.file.getPath().replace("\\", "/")));
            }
        }){

            @Override
            public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                AbstractFileBrowserScreen.AbstractFileScrollAreaEntry e = ChooseFileScreen.this.getSelectedEntry();
                this.active = e != null && !e.resourceUnfriendlyFileName && e.file.isFile();
                super.render(graphics, mouseX, mouseY, partial);
            }
        };
    }

    @Override
    protected AbstractFileBrowserScreen.AbstractFileScrollAreaEntry buildFileEntry(@NotNull File f) {
        return new FileScrollAreaEntry(this.fileListScrollArea, f);
    }

    public boolean keyPressed(int keycode, int scancode, int modifiers) {
        AbstractFileBrowserScreen.AbstractFileScrollAreaEntry selected;
        if (keycode == 257 && (selected = this.getSelectedEntry()) != null) {
            this.callback.accept(new File(selected.file.getPath().replace("\\", "/")));
            return true;
        }
        return super.keyPressed(keycode, scancode, modifiers);
    }

    public class FileScrollAreaEntry
    extends AbstractFileBrowserScreen.AbstractFileScrollAreaEntry {
        public FileScrollAreaEntry(@NotNull ScrollArea parent, File file) {
            super(parent, file);
        }

        @Override
        public void onClick(ScrollAreaEntry entry) {
            if (this.resourceUnfriendlyFileName) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastClick < 400L) {
                if (this.file.isFile()) {
                    ChooseFileScreen.this.callback.accept(new File(this.file.getPath().replace("\\", "/")));
                } else if (this.file.isDirectory()) {
                    ChooseFileScreen.this.setDirectory(this.file, true);
                }
            }
            ChooseFileScreen.this.updatePreview(this.file);
            this.lastClick = now;
        }
    }
}

