/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.resource.resources.texture;

import com.mojang.blaze3d.platform.NativeImage;
import de.keksuccino.fancymenu.util.CloseableUtils;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.fancymenu.util.input.TextValidators;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpegTexture
implements ITexture {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    protected ResourceLocation resourceLocation;
    protected volatile int width = 10;
    protected volatile int height = 10;
    protected volatile AspectRatio aspectRatio = new AspectRatio(10, 10);
    protected volatile boolean decoded = false;
    protected volatile boolean loadedIntoMinecraft = false;
    protected volatile NativeImage nativeImage;
    protected DynamicTexture dynamicTexture;
    protected ResourceLocation sourceLocation;
    protected File sourceFile;
    protected String sourceURL;
    protected volatile boolean loadingCompleted = false;
    protected volatile boolean loadingFailed = false;
    protected volatile boolean closed = false;

    @NotNull
    public static JpegTexture location(@NotNull ResourceLocation location) {
        return JpegTexture.location(location, null);
    }

    @NotNull
    public static JpegTexture location(@NotNull ResourceLocation location, @Nullable JpegTexture writeTo) {
        Objects.requireNonNull(location);
        JpegTexture texture = writeTo != null ? writeTo : new JpegTexture();
        texture.sourceLocation = location;
        try {
            Optional resource = Minecraft.getInstance().getResourceManager().getResource(location);
            if (resource.isPresent()) {
                JpegTexture.of(Objects.requireNonNull(((Resource)resource.get()).open()), location.toString(), texture);
            }
        }
        catch (Exception ex) {
            texture.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read texture from ResourceLocation: " + location, (Throwable)ex);
        }
        return texture;
    }

    @NotNull
    public static JpegTexture local(@NotNull File textureFile) {
        return JpegTexture.local(textureFile, null);
    }

    @NotNull
    public static JpegTexture local(@NotNull File textureFile, @Nullable JpegTexture writeTo) {
        Objects.requireNonNull(textureFile);
        JpegTexture texture = writeTo != null ? writeTo : new JpegTexture();
        texture.sourceFile = textureFile;
        if (!textureFile.isFile()) {
            texture.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read texture from file! File not found: " + textureFile.getPath());
            return texture;
        }
        try {
            FileInputStream in = new FileInputStream(textureFile);
            JpegTexture.of(in, textureFile.getPath(), texture);
        }
        catch (Exception ex) {
            texture.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read texture from file: " + textureFile.getPath(), (Throwable)ex);
        }
        return texture;
    }

    @NotNull
    public static JpegTexture web(@NotNull String textureURL) {
        return JpegTexture.web(textureURL, null);
    }

    @NotNull
    public static JpegTexture web(@NotNull String textureURL, @Nullable JpegTexture writeTo) {
        Objects.requireNonNull(textureURL);
        JpegTexture texture = writeTo != null ? writeTo : new JpegTexture();
        texture.sourceURL = textureURL;
        if (!TextValidators.BASIC_URL_TEXT_VALIDATOR.get(textureURL).booleanValue()) {
            texture.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read texture from URL! Invalid URL: " + textureURL);
            return texture;
        }
        new Thread(() -> {
            try {
                InputStream in = WebUtils.openResourceStream(textureURL);
                if (in == null) {
                    throw new NullPointerException("Web resource input stream was NULL!");
                }
                JpegTexture.of(in, textureURL, texture);
            }
            catch (Exception ex) {
                texture.loadingFailed = true;
                LOGGER.error("[FANCYMENU] Failed to read texture from URL: " + textureURL, (Throwable)ex);
            }
        }).start();
        return texture;
    }

    @NotNull
    public static JpegTexture of(@NotNull InputStream in, @Nullable String textureName, @Nullable JpegTexture writeTo) {
        Objects.requireNonNull(in);
        JpegTexture texture = writeTo != null ? writeTo : new JpegTexture();
        new Thread(() -> {
            JpegTexture.populateTexture(texture, in, textureName != null ? textureName : "[Generic InputStream Source]");
            if (texture.closed) {
                MainThreadTaskExecutor.executeInMainThread(texture::close, MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK);
            }
        }).start();
        return texture;
    }

    @NotNull
    public static JpegTexture of(@NotNull InputStream in) {
        return JpegTexture.of(in, null, null);
    }

    @NotNull
    public static JpegTexture of(@NotNull NativeImage nativeImage) {
        Objects.requireNonNull(nativeImage);
        JpegTexture texture = new JpegTexture();
        texture.nativeImage = nativeImage;
        texture.width = nativeImage.getWidth();
        texture.height = nativeImage.getHeight();
        texture.aspectRatio = new AspectRatio(nativeImage.getWidth(), nativeImage.getHeight());
        texture.decoded = true;
        texture.loadingCompleted = true;
        return texture;
    }

    protected JpegTexture() {
    }

    protected static void populateTexture(@NotNull JpegTexture texture, @NotNull InputStream in, @NotNull String textureName) {
        if (!texture.closed) {
            try {
                SizedNativeImage image = JpegTexture.convertJpegToPng(in);
                if (image != null) {
                    texture.nativeImage = image.image;
                    texture.width = image.width;
                    texture.height = image.height;
                    texture.aspectRatio = new AspectRatio(texture.width, texture.height);
                    texture.loadingCompleted = true;
                } else {
                    texture.loadingFailed = true;
                    LOGGER.error("[FANCYMENU] Failed to read texture, NativeImage was NULL: " + textureName);
                }
            }
            catch (Exception ex) {
                texture.loadingFailed = true;
                LOGGER.error("[FANCYMENU] Failed to load texture: " + textureName, (Throwable)ex);
            }
        }
        texture.decoded = true;
        CloseableUtils.closeQuietly(in);
    }

    @Nullable
    protected static SizedNativeImage convertJpegToPng(@NotNull InputStream in) {
        int w = 1;
        int h = 1;
        NativeImage nativeImage = null;
        ByteArrayOutputStream byteArrayOut = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(in);
            w = bufferedImage.getWidth();
            h = bufferedImage.getHeight();
            byteArrayOut = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOut);
            nativeImage = NativeImage.read((InputStream)new ByteArrayInputStream(byteArrayOut.toByteArray()));
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to convert JPEG image to PNG!", (Throwable)ex);
        }
        CloseableUtils.closeQuietly(in);
        CloseableUtils.closeQuietly(byteArrayOut);
        return nativeImage != null ? new SizedNativeImage(nativeImage, w, h) : null;
    }

    @Override
    @Nullable
    public ResourceLocation getResourceLocation() {
        if (this.closed) {
            return FULLY_TRANSPARENT_TEXTURE;
        }
        if (this.resourceLocation == null && !this.loadedIntoMinecraft && this.nativeImage != null) {
            try {
                this.dynamicTexture = new DynamicTexture(this.nativeImage);
                this.resourceLocation = Minecraft.getInstance().getTextureManager().register("fancymenu_simple_texture", this.dynamicTexture);
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to get ResourceLocation of JpegTexture!", (Throwable)ex);
            }
            this.loadedIntoMinecraft = true;
        }
        return this.resourceLocation;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    @Override
    @Nullable
    public InputStream open() throws IOException {
        if (this.nativeImage != null) {
            return new ByteArrayInputStream(this.nativeImage.asByteArray());
        }
        return null;
    }

    @Override
    public boolean isReady() {
        return this.decoded;
    }

    @Override
    public boolean isLoadingCompleted() {
        return !this.closed && !this.loadingFailed && this.loadingCompleted;
    }

    @Override
    public boolean isLoadingFailed() {
        return this.loadingFailed;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            if (this.dynamicTexture != null) {
                this.dynamicTexture.close();
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] An error happened while trying to close the DynamicTexture!", (Throwable)ex);
        }
        try {
            if (this.nativeImage != null) {
                this.nativeImage.close();
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] An error happened while trying to close the NativeImage!", (Throwable)ex);
        }
        this.dynamicTexture = null;
        this.nativeImage = null;
        this.resourceLocation = null;
        this.decoded = false;
        this.loadedIntoMinecraft = true;
    }

    protected record SizedNativeImage(@NotNull NativeImage image, int width, int height) {
    }
}

