/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.components;

import it.unimi.dsi.fastutil.booleans.Boolean2ObjectFunction;
import java.util.function.Consumer;
import me.codexadrian.tempad.client.components.ModSprites;
import me.codexadrian.tempad.client.components.SpriteButton;
import me.codexadrian.tempad.client.components.ToggleButton;
import me.codexadrian.tempad.client.config.TempadClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class ModWidgets {
    private static final Component DOWNLOAD = Component.translatable((String)"gui.tempad.download");
    private static final Component DOWNLOAD_DISABLED = Component.translatable((String)"gui.tempad.download_disabled");
    private static final Component TELEPORT = Component.translatable((String)"gui.tempad.teleport");
    private static final Component TELEPORT_DISABLED = Component.translatable((String)"gui.tempad.teleport_disabled");
    private static final Component DELETE = Component.translatable((String)"gui.tempad.delete");
    private static final Component DELETE_DISABLED = Component.translatable((String)"gui.tempad.delete_disabled");
    private static final Component FAVORITE = Component.translatable((String)"gui.tempad.favorite");
    private static final Component UNFAVORITE = Component.translatable((String)"gui.tempad.unfavorite");
    private static final Component SEARCH = Component.translatable((String)"gui.tempad.search_field");
    private static final Component ADD = Component.translatable((String)"gui.tempad.add_location");

    public static SpriteButton download(int x, int y, int width, int height, Runnable onPress) {
        SpriteButton button = SpriteButton.hidden(x, y, width, height, ModSprites.DOWNLOAD, onPress);
        button.setTooltip(Tooltip.create((Component)DOWNLOAD));
        button.setDisabledTooltip(Tooltip.create((Component)DOWNLOAD_DISABLED));
        return button;
    }

    public static SpriteButton teleport(int x, int y, int width, int height, Runnable onPress) {
        SpriteButton button = SpriteButton.hidden(x, y, width, height, ModSprites.TELEPORT, onPress);
        button.setTooltip(Tooltip.create((Component)TELEPORT));
        button.setDisabledTooltip(Tooltip.create((Component)TELEPORT_DISABLED));
        return button;
    }

    public static SpriteButton delete(int x, int y, int width, int height, Runnable onPress) {
        SpriteButton button = SpriteButton.hidden(x, y, width, height, ModSprites.DELETE, onPress);
        button.setTooltip(Tooltip.create((Component)DELETE));
        button.setDisabledTooltip(Tooltip.create((Component)DELETE_DISABLED));
        return button;
    }

    public static ToggleButton favorite(int x, int y, int width, int height, Runnable onPress) {
        ToggleButton button = new ToggleButton(x, y, width, height, ModSprites.UNFAVORITE, ModSprites.FAVORITE, b -> onPress.run());
        button.setTooltip((Boolean2ObjectFunction<Tooltip>)((Boolean2ObjectFunction)value -> Tooltip.create((Component)(value ? UNFAVORITE : FAVORITE))));
        button.visible = false;
        return button;
    }

    public static EditBox search(int x, int y, int width, int height, Consumer<String> updater) {
        EditBox editBox = new EditBox(Minecraft.getInstance().font, x, y, width, height, SEARCH);
        editBox.setBordered(false);
        editBox.setHint(SEARCH);
        editBox.setTextColor(TempadClientConfig.color);
        editBox.setResponder(updater);
        return editBox;
    }

    public static SpriteButton add(int x, int y, int width, int height, Runnable onPress) {
        SpriteButton button = new SpriteButton(x, y, width, height, ModSprites.ADD, onPress);
        button.setTooltip(Tooltip.create((Component)ADD));
        return button;
    }
}

