/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.codexadrian.tempad.common.entity.TimedoorEntity;
import me.codexadrian.tempad.common.utils.ShaderUtils;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class TimedoorRenderer
extends EntityRenderer<TimedoorEntity> {
    private static final int uv00 = LightTexture.pack((int)0, (int)0);
    private static final int uv01 = LightTexture.pack((int)0, (int)1);
    private static final int uv10 = LightTexture.pack((int)1, (int)0);
    private static final int uv11 = LightTexture.pack((int)1, (int)1);

    public TimedoorRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TimedoorEntity entity, float yaw, float deltaTime, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light) {
        float width = 1.4f;
        float height = 2.3f;
        float depth = 0.4f;
        int closingTime = entity.getClosingTime();
        int tickLength = 8;
        int phaseLength = tickLength / 2;
        int ticks = entity.tickCount;
        float animation = ((float)ticks + deltaTime) / (float)tickLength;
        if (ticks < phaseLength) {
            width = Mth.lerp((float)(animation * 2.0f), (float)0.0f, (float)width);
            height = 0.2f;
        }
        if (ticks >= phaseLength && ticks < tickLength) {
            height = Mth.lerp((float)((animation - 0.5f) * 2.0f), (float)0.2f, (float)height);
        }
        if (closingTime != -1) {
            if (ticks > closingTime && ticks < closingTime + phaseLength) {
                height = Mth.lerp((float)(1.0f - (animation - (float)closingTime / (float)tickLength) * 2.0f), (float)0.2f, (float)height);
            }
            if (ticks >= closingTime + phaseLength) {
                width = Mth.lerp((float)(1.0f - (animation - (float)closingTime / (float)tickLength - 0.5f) * 2.0f), (float)0.0f, (float)width);
                height = 0.2f;
            }
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(entity.getYRot()));
        poseStack.translate(0.0f, 1.15f, 0.0f);
        Matrix4f model = poseStack.last().pose();
        if (width >= 0.0f) {
            this.renderTimedoor(model, multiBufferSource, width, height, depth, light, entity.getColor());
        }
        super.render((Entity)entity, yaw, deltaTime, poseStack, multiBufferSource, light);
        poseStack.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull TimedoorEntity entity) {
        return new ResourceLocation("tempad", "");
    }

    public void renderTimedoor(Matrix4f model, MultiBufferSource multiBufferSource, float width, float height, float depth, int i, int color) {
        float xBound = width * 0.5f;
        float yBound = height * 0.5f;
        float zBound = depth * -0.5f;
        float xBoundN = -xBound;
        float yBoundN = -yBound;
        float zBoundP = -zBound;
        VertexConsumer buffer = multiBufferSource.getBuffer(ShaderUtils.getTimedoorShaderType());
        float red = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float green = (float)((color & 0xFF00) >> 8) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = 1.0f;
        buffer.vertex(model, xBoundN, yBound, zBoundP).color(red, green, blue, alpha).uv(xBound, yBound).uv2(uv00).endVertex();
        buffer.vertex(model, xBoundN, yBoundN, zBoundP).color(red, green, blue, alpha).uv(xBound, yBound).uv2(uv01).endVertex();
        buffer.vertex(model, xBound, yBoundN, zBoundP).color(red, green, blue, alpha).uv(xBound, yBound).uv2(uv11).endVertex();
        buffer.vertex(model, xBound, yBound, zBoundP).color(red, green, blue, alpha).uv(xBound, yBound).uv2(uv10).endVertex();
        buffer.vertex(model, xBound, yBound, zBound).color(red, green, blue, alpha).uv(xBound, yBound).uv2(uv00).endVertex();
        buffer.vertex(model, xBound, yBoundN, zBound).color(red, green, blue, alpha).uv(xBound, yBound).uv2(uv01).endVertex();
        buffer.vertex(model, xBoundN, yBoundN, zBound).color(red, green, blue, alpha).uv(xBound, yBound).uv2(uv11).endVertex();
        buffer.vertex(model, xBoundN, yBound, zBound).color(red, green, blue, alpha).uv(xBound, yBound).uv2(uv10).endVertex();
        buffer.vertex(model, xBoundN, yBound, zBound).color(red, green, blue, alpha).uv(xBound, zBoundP).uv2(uv00).endVertex();
        buffer.vertex(model, xBoundN, yBound, zBoundP).color(red, green, blue, alpha).uv(xBound, zBoundP).uv2(uv01).endVertex();
        buffer.vertex(model, xBound, yBound, zBoundP).color(red, green, blue, alpha).uv(xBound, zBoundP).uv2(uv11).endVertex();
        buffer.vertex(model, xBound, yBound, zBound).color(red, green, blue, alpha).uv(xBound, zBoundP).uv2(uv10).endVertex();
        buffer.vertex(model, xBoundN, yBoundN, zBoundP).color(red, green, blue, alpha).uv(xBound, zBoundP).uv2(uv00).endVertex();
        buffer.vertex(model, xBoundN, yBoundN, zBound).color(red, green, blue, alpha).uv(xBound, zBoundP).uv2(uv01).endVertex();
        buffer.vertex(model, xBound, yBoundN, zBound).color(red, green, blue, alpha).uv(xBound, zBoundP).uv2(uv11).endVertex();
        buffer.vertex(model, xBound, yBoundN, zBoundP).color(red, green, blue, alpha).uv(xBound, zBoundP).uv2(uv10).endVertex();
        buffer.vertex(model, xBoundN, yBound, zBound).color(red, green, blue, alpha).uv(zBoundP, yBound).uv2(uv00).endVertex();
        buffer.vertex(model, xBoundN, yBoundN, zBound).color(red, green, blue, alpha).uv(zBoundP, yBound).uv2(uv01).endVertex();
        buffer.vertex(model, xBoundN, yBoundN, zBoundP).color(red, green, blue, alpha).uv(zBoundP, yBound).uv2(uv11).endVertex();
        buffer.vertex(model, xBoundN, yBound, zBoundP).color(red, green, blue, alpha).uv(zBoundP, yBound).uv2(uv10).endVertex();
        buffer.vertex(model, xBound, yBound, zBoundP).color(red, green, blue, alpha).uv(zBoundP, yBound).uv2(uv00).endVertex();
        buffer.vertex(model, xBound, yBoundN, zBoundP).color(red, green, blue, alpha).uv(zBoundP, yBound).uv2(uv01).endVertex();
        buffer.vertex(model, xBound, yBoundN, zBound).color(red, green, blue, alpha).uv(zBoundP, yBound).uv2(uv11).endVertex();
        buffer.vertex(model, xBound, yBound, zBound).color(red, green, blue, alpha).uv(zBoundP, yBound).uv2(uv10).endVertex();
    }
}

