/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import me.codexadrian.tempad.client.components.ModSprites;
import me.codexadrian.tempad.client.config.TempadClientConfig;
import me.codexadrian.tempad.client.screens.BackgroundScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ModalScreen
extends BackgroundScreen {
    private static final Component NAME_FIELD = Component.translatable((String)"gui.tempad.name_field");
    private final Screen background;
    private final Consumer<String> callback;

    protected ModalScreen(Screen background, Consumer<String> callback) {
        super(94, 32, ModSprites.MODAL);
        this.background = background;
        this.callback = callback;
    }

    @Override
    protected void init() {
        super.init();
        EditBox box = new EditBox(this.font, this.left + 16, this.top + 5, 74, 8, CommonComponents.EMPTY);
        box.setMaxLength(32);
        box.setBordered(false);
        box.setHint(NAME_FIELD);
        box.setTextColor(TempadClientConfig.color);
        this.addRenderableWidget((GuiEventListener)box);
        LinearLayout layout = LinearLayout.horizontal().spacing(3);
        ((ImageButton)layout.addChild((LayoutElement)new ImageButton(0, 0, 12, 12, ModSprites.BACK, b -> this.onClose()))).setTooltip(Tooltip.create((Component)CommonComponents.GUI_CANCEL));
        ((ImageButton)layout.addChild((LayoutElement)new ImageButton(0, 0, 12, 12, ModSprites.SAVE, b -> {
            this.callback.accept(box.getValue());
            if (this.minecraft != null) {
                this.minecraft.setScreen(null);
            }
        }))).setTooltip(Tooltip.create((Component)CommonComponents.GUI_DONE));
        layout.arrangeElements();
        layout.setPosition(this.left + this.screenWidth - layout.getWidth() - 3, this.top + this.screenHeight - layout.getHeight() - 3);
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void added() {
        super.added();
        this.background.clearFocus();
    }

    protected void repositionElements() {
        this.background.resize(Minecraft.getInstance(), this.width, this.height);
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.background.render(graphics, -1, -1, partialTick);
        graphics.flush();
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        if (this.minecraft == null) {
            return;
        }
        this.minecraft.setScreen(this.background);
    }

    public static void open(Consumer<String> callback) {
        Minecraft.getInstance().setScreen((Screen)new ModalScreen(Minecraft.getInstance().screen, callback));
    }
}

