/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.screens;

import com.teamresourceful.resourcefullib.common.network.Packet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.codexadrian.tempad.api.options.TempadOption;
import me.codexadrian.tempad.client.components.InformationPanel;
import me.codexadrian.tempad.client.components.LocationPanel;
import me.codexadrian.tempad.client.components.ModSprites;
import me.codexadrian.tempad.client.components.ModWidgets;
import me.codexadrian.tempad.client.components.SpriteButton;
import me.codexadrian.tempad.client.components.TextEntry;
import me.codexadrian.tempad.client.components.ToggleButton;
import me.codexadrian.tempad.client.config.TempadClientConfig;
import me.codexadrian.tempad.client.screens.BackgroundScreen;
import me.codexadrian.tempad.client.screens.ModalScreen;
import me.codexadrian.tempad.common.config.ConfigCache;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.items.TempadItem;
import me.codexadrian.tempad.common.network.NetworkHandler;
import me.codexadrian.tempad.common.network.messages.c2s.AddLocationPacket;
import me.codexadrian.tempad.common.network.messages.c2s.DeleteLocationPacket;
import me.codexadrian.tempad.common.network.messages.c2s.ExportLocationPacket;
import me.codexadrian.tempad.common.network.messages.c2s.FavoriteLocationPacket;
import me.codexadrian.tempad.common.network.messages.c2s.SummonTimedoorPacket;
import me.codexadrian.tempad.common.utils.TeleportUtils;
import net.minecraft.Optionull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TempadScreen
extends BackgroundScreen {
    private final List<LocationData> locations;
    private UUID favorite;
    private LocationData selectedLocation;
    private InformationPanel informationPanel;
    private LocationPanel locationPanel;
    private EditBox search;
    private ToggleButton favoriteButton;
    private SpriteButton downloadButton;
    private SpriteButton deleteButton;
    private SpriteButton teleportButton;

    public TempadScreen(List<LocationData> locations, UUID favorite) {
        super(249, 138, ModSprites.SCREEN);
        this.locations = locations;
        this.favorite = favorite;
    }

    @Override
    protected void init() {
        super.init();
        this.informationPanel = (InformationPanel)this.addRenderableWidget((GuiEventListener)new InformationPanel(this.left + 16, this.top + 33, 91, 78));
        this.locationPanel = (LocationPanel)this.addRenderableWidget((GuiEventListener)new LocationPanel(this.left + 129, this.top + 31, 91, 92, this.locations, id -> id.equals(this.favorite), this::select));
        String searchValue = (String)Optionull.mapOrDefault((Object)this.search, EditBox::getValue, (Object)"");
        this.search = (EditBox)this.addRenderableWidget((GuiEventListener)ModWidgets.search(this.left + 139, this.top + 16, 66, 12, this.locationPanel::update));
        this.search.setValue(searchValue);
        if (!this.locations.isEmpty()) {
            this.informationPanel.update(null);
        }
        this.favoriteButton = (ToggleButton)this.addRenderableWidget((GuiEventListener)ModWidgets.favorite(this.left + 46, this.top + 110, 14, 14, this::favoriteAction));
        this.downloadButton = (SpriteButton)this.addRenderableWidget((GuiEventListener)ModWidgets.download(this.left + 62, this.top + 110, 14, 14, this::exportAction));
        this.deleteButton = (SpriteButton)this.addRenderableWidget((GuiEventListener)ModWidgets.delete(this.left + 78, this.top + 110, 14, 14, this::deleteAction));
        this.teleportButton = (SpriteButton)this.addRenderableWidget((GuiEventListener)ModWidgets.teleport(this.left + 94, this.top + 110, 14, 14, this::teleportAction));
        this.addRenderableWidget((GuiEventListener)ModWidgets.add(this.left + 208, this.top + 14, 12, 12, () -> ModalScreen.open(name -> NetworkHandler.CHANNEL.sendToServer((Packet)new AddLocationPacket((String)name)))));
        this.locationPanel.select(this.selectedLocation);
    }

    private void select(TextEntry entry) {
        if (entry == null) {
            return;
        }
        if (entry.data == null) {
            return;
        }
        this.selectedLocation = entry.data;
        this.informationPanel.update(this.selectedLocation);
        this.favoriteButton.setSelected(this.selectedLocation.getId().equals(this.favorite));
        this.favoriteButton.visible = true;
        this.downloadButton.visible = true;
        this.deleteButton.visible = true;
        this.teleportButton.visible = true;
        if (this.minecraft != null && this.minecraft.player != null) {
            TempadItem tempadItem;
            ItemStack itemInHand = TeleportUtils.findTempad((Player)this.minecraft.player);
            Item item = itemInHand.getItem();
            boolean isTempadUsable = item instanceof TempadItem && (tempadItem = (TempadItem)item).getOption().canTimedoorOpen((Player)this.minecraft.player, itemInHand);
            this.teleportButton.setActivated(this.selectedLocation.isTeleportable() && TeleportUtils.mayTeleport(this.selectedLocation.getLevelKey(), (Player)this.minecraft.player) && isTempadUsable);
            this.downloadButton.setActivated(this.selectedLocation.isDownloadable() && ConfigCache.allowExporting && (!ConfigCache.consumeCooldown || isTempadUsable));
            this.deleteButton.setActivated(this.selectedLocation.isDeletable());
        }
    }

    private void favoriteAction() {
        if (this.minecraft != null && this.minecraft.player != null) {
            this.favorite = this.selectedLocation.getId().equals(this.favorite) ? null : this.selectedLocation.getId();
            NetworkHandler.CHANNEL.sendToServer((Packet)new FavoriteLocationPacket(this.favorite));
        }
    }

    private void teleportAction() {
        if (this.minecraft != null && this.minecraft.player != null) {
            NetworkHandler.CHANNEL.sendToServer((Packet)new SummonTimedoorPacket(this.selectedLocation.getId(), TempadClientConfig.color));
            Minecraft.getInstance().setScreen(null);
        }
    }

    private void deleteAction() {
        if (this.minecraft != null && this.minecraft.player != null) {
            NetworkHandler.CHANNEL.sendToServer((Packet)new DeleteLocationPacket(this.selectedLocation.getId()));
            this.locations.removeIf(locationData -> locationData.getId().equals(this.selectedLocation.getId()));
            this.selectedLocation = null;
            this.locationPanel.update(this.search.getValue());
            this.informationPanel.update(null);
            this.favoriteButton.visible = false;
            this.downloadButton.visible = false;
            this.deleteButton.visible = false;
            this.teleportButton.visible = false;
        }
    }

    private void exportAction() {
        if (this.minecraft != null && this.minecraft.player != null && ConfigCache.allowExporting) {
            Minecraft.getInstance().setScreen(null);
            NetworkHandler.CHANNEL.sendToServer((Packet)new ExportLocationPacket(this.selectedLocation.getId()));
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.minecraft == null) {
            return;
        }
        ItemStack tempad = TeleportUtils.findTempad((Player)this.minecraft.player);
        Item item = tempad.getItem();
        if (item instanceof TempadItem) {
            TempadItem item2 = (TempadItem)item;
            TempadOption option = item2.getOption();
            int barHeight = option.isDurabilityBarVisible(tempad) ? (int)(option.getPercentage(tempad) * 54.0) : (option.canTimedoorOpen((Player)this.minecraft.player, tempad) ? 54 : 0);
            graphics.blitSprite(ModSprites.BAR, 6, 54, 0, 0, this.left + 234, this.top + 42 + 54 - barHeight, 6, barHeight);
            if (mouseX >= this.left + 234 && mouseX <= this.left + 240 && mouseY >= this.top + 42 && mouseY <= this.top + 96) {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                option.addToolTip(tempad, (Level)this.minecraft.level, tooltip, (TooltipFlag)TooltipFlag.NORMAL);
                this.setTooltipForNextRenderPass(tooltip.stream().map(Component::getVisualOrderText).toList());
            }
        }
    }
}

