/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import me.codexadrian.tempad.client.config.TempadClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.slf4j.Logger;

public class BlurReloader
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private PostChain timedoorBlur;
    private PostPass filterTimedoor;
    private RenderTarget blurTarget;
    private RenderTarget blurSwapTarget;

    public void onResourceManagerReload(ResourceManager resourceManager) {
        if (!TempadClientConfig.isFancyTimedoorRendererEnabled) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (this.timedoorBlur != null) {
            this.timedoorBlur.close();
        }
        if (this.blurSwapTarget != null) {
            this.blurSwapTarget.destroyBuffers();
        }
        if (this.blurTarget != null) {
            this.blurTarget.destroyBuffers();
        }
        if (this.filterTimedoor != null) {
            this.filterTimedoor.close();
        }
        ResourceLocation resourceLocation = new ResourceLocation("shaders/post/timedoorblur.json");
        try {
            this.timedoorBlur = new PostChain(minecraft.getTextureManager(), resourceManager, minecraft.getMainRenderTarget(), resourceLocation);
            this.timedoorBlur.resize(minecraft.getWindow().getWidth(), minecraft.getWindow().getHeight());
            this.blurTarget = this.timedoorBlur.getTempTarget("blur_target");
            this.blurSwapTarget = new TextureTarget(minecraft.getWindow().getWidth(), minecraft.getWindow().getHeight(), true, Minecraft.ON_OSX);
            this.filterTimedoor = new PostPass(resourceManager, "filter_timedoor_rendering", this.blurTarget, this.blurSwapTarget);
            RenderTarget mainRenderTarget = Minecraft.getInstance().getMainRenderTarget();
            this.filterTimedoor.addAuxAsset("DiffuseDepthSampler", () -> ((RenderTarget)this.blurTarget).getDepthTextureId(), this.blurTarget.width, this.blurTarget.height);
            this.filterTimedoor.addAuxAsset("WorldDepthSampler", () -> ((RenderTarget)mainRenderTarget).getDepthTextureId(), mainRenderTarget.width, mainRenderTarget.height);
        }
        catch (JsonSyntaxException | IOException exception) {
            LOGGER.error("Failed to load Tempad shaders", exception);
            this.timedoorBlur = null;
            this.blurTarget = null;
            this.filterTimedoor = null;
        }
    }

    public PostChain getTimedoorBlur() {
        return this.timedoorBlur;
    }

    public RenderTarget getBlurTarget() {
        return this.blurTarget;
    }

    public RenderTarget getBlurSwapTarget() {
        return this.blurSwapTarget;
    }

    public PostPass getFilterTimedoor() {
        return this.filterTimedoor;
    }
}

