/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.data;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocationData
implements Comparable<LocationData> {
    private final UUID id;
    private final String name;
    private final BlockPos blockPos;
    private final ResourceKey<Level> levelKey;
    private boolean isTeleportable;
    private boolean isDeletable;
    private boolean isDownloadable;

    public LocationData(String name, @Nullable ResourceKey<Level> levelKey, BlockPos pos, UUID uuid, boolean isTeleportable, boolean isDeletable, boolean isDownloadable) {
        this.name = name;
        this.levelKey = levelKey;
        this.blockPos = pos;
        this.id = uuid;
        this.isTeleportable = isTeleportable;
        this.isDeletable = isDeletable;
        this.isDownloadable = isDownloadable;
    }

    public LocationData(String name, @Nullable ResourceKey<Level> levelKey, BlockPos pos, UUID uuid) {
        this(name, levelKey, pos, uuid, true, true, true);
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("uuid", this.id);
        tag.putString("name", this.name);
        tag.put("blockpos", (Tag)NbtUtils.writeBlockPos((BlockPos)this.blockPos));
        if (this.levelKey != null) {
            Optional optTag = Level.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.levelKey).result();
            tag.put("levelKey", (Tag)optTag.get());
        }
        return tag;
    }

    public static LocationData fromTag(CompoundTag tag) {
        UUID uuid = tag.getUUID("uuid");
        String name = tag.getString("name");
        BlockPos pos = NbtUtils.readBlockPos((CompoundTag)tag.getCompound("blockpos"));
        ResourceKey key = null;
        if (tag.contains("levelKey")) {
            Optional optKey = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("levelKey")).result();
            key = (ResourceKey)optKey.get();
        }
        return new LocationData(name, key, pos, uuid);
    }

    public UUID getId() {
        return this.id;
    }

    @Nullable
    public ResourceKey<Level> getLevelKey() {
        return this.levelKey;
    }

    public String getName() {
        return this.name;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public boolean isTeleportable() {
        return this.isTeleportable;
    }

    public boolean isDeletable() {
        return this.isDeletable;
    }

    public boolean isDownloadable() {
        return this.isDownloadable;
    }

    @Override
    public int compareTo(@NotNull LocationData o) {
        return this.getName().compareTo(o.getName());
    }
}

