/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.entity;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import me.codexadrian.tempad.common.Tempad;
import me.codexadrian.tempad.common.config.TempadConfig;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.entity.neoforge.TimedoorEntityImpl;
import me.codexadrian.tempad.common.registry.TempadRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimedoorEntity
extends Entity {
    public static final int ANIMATION_LENGTH = 8;
    private static final EntityDataAccessor<Integer> CLOSING_TIME = SynchedEntityData.defineId(TimedoorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(TimedoorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private LocationData locationData = null;
    private UUID owner = null;
    private UUID linkedPortalId = null;
    private TimedoorEntity linkedPortalEntity = null;

    public TimedoorEntity(EntityType<TimedoorEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData() {
        this.entityData.define(CLOSING_TIME, (Object)TempadConfig.timedoorWait);
        this.entityData.define(COLOR, (Object)-37120);
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        if (compoundTag.contains("location")) {
            this.setLocation(LocationData.fromTag(compoundTag.getCompound("location")));
        }
        this.setClosingTime(compoundTag.getInt("closing_time"));
        if (compoundTag.hasUUID("owner")) {
            this.setOwner(compoundTag.getUUID("owner"));
        }
        this.setColor(compoundTag.getInt("outline_color"));
        if (compoundTag.contains("linked_portal")) {
            this.setLinkedPortalId(compoundTag.getUUID("linked_portal"));
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        if (this.locationData != null) {
            compoundTag.put("location", (Tag)this.locationData.toTag());
        }
        compoundTag.putInt("closing_time", this.getClosingTime());
        if (this.owner != null) {
            compoundTag.putUUID("owner", this.getOwner());
        }
        compoundTag.putInt("outline_color", this.getColor());
        if (this.getLinkedPortalId() != null) {
            compoundTag.putUUID("linked_portal", this.getLinkedPortalId());
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void tick() {
        AABB box = this.getBoundingBox();
        if (this.getDirection() == Direction.NORTH || this.getDirection() == Direction.SOUTH) {
            box = box.inflate(0.5, 0.0, 0.0);
        }
        if (this.getDirection() == Direction.EAST || this.getDirection() == Direction.WEST) {
            box = box.inflate(0.0, 0.0, 0.5);
        }
        if (this.getLocation() != null) {
            Predicate<Entity> b = entity -> (entity instanceof LivingEntity || entity instanceof ItemEntity) && !entity.getType().is(Tempad.TEMPAD_ENTITY_BLACKLIST) || entity.getType().is(Tempad.TEMPAD_ENTITY_WHITELIST);
            List entities = this.level().getEntitiesOfClass(Entity.class, box, b);
            if (!entities.isEmpty() && !this.level().isClientSide()) {
                ServerLevel destinationLevel = Objects.requireNonNull(this.level().getServer()).getLevel(this.getLocation().getLevelKey());
                entities.stream().flatMap(entity -> entity.getRootVehicle().getSelfAndPassengers()).distinct().forEach(entity -> {
                    Player player;
                    entity.ejectPassengers();
                    Vec3 deltaMovement = entity.getDeltaMovement();
                    BlockPos pos = this.getLocation().getBlockPos();
                    if (destinationLevel != null) {
                        if (!this.getLocation().getLevelKey().location().equals((Object)this.level().dimension().location())) {
                            TimedoorEntity.teleportEntity(destinationLevel, pos, deltaMovement, entity);
                        } else {
                            entity.teleportToWithTicket((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                            entity.setDeltaMovement(deltaMovement);
                            entity.hasImpulse = true;
                        }
                    }
                    if (this.getLinkedPortalEntity() != null) {
                        this.getLinkedPortalEntity().resetClosingTime();
                    }
                    this.resetClosingTime();
                    if (entity instanceof Player && (player = (Player)entity).getUUID().equals(this.getOwner())) {
                        this.setClosingTime(this.tickCount + TempadConfig.timedoorAddWaitTime);
                        if (this.getLinkedPortalEntity() != null) {
                            this.getLinkedPortalEntity().setClosingTime(this.getLinkedPortalEntity().tickCount + TempadConfig.timedoorAddWaitTime);
                        }
                    }
                });
                if (this.getLinkedPortalEntity() == null) {
                    TimedoorEntity recipientPortal = new TimedoorEntity((EntityType<TimedoorEntity>)((EntityType)TempadRegistry.TIMEDOOR_ENTITY.get()), (Level)destinationLevel);
                    recipientPortal.setOwner(this.getOwner());
                    recipientPortal.setClosingTime(TempadConfig.timedoorAddWaitTime);
                    recipientPortal.setLocation(null);
                    recipientPortal.setColor(this.getColor());
                    this.setLinkedPortalId(recipientPortal.getUUID());
                    recipientPortal.setLinkedPortalId(this.getUUID());
                    BlockPos position = this.getLocation().getBlockPos().relative(this.getDirection(), 1);
                    recipientPortal.setPos((double)position.getX() + 0.5, position.getY(), (double)position.getZ() + 0.5);
                    recipientPortal.setYRot(this.getYRot());
                    this.level().addFreshEntity((Entity)recipientPortal);
                }
            }
        }
        if (this.tickCount > this.getClosingTime() + 8 && this.getClosingTime() != -1) {
            if (this.getLinkedPortalEntity() != null) {
                this.getLinkedPortalEntity().setLinkedPortalId(null);
            }
            this.setLinkedPortalId(null);
            this.discard();
        }
    }

    public void setLocation(LocationData location) {
        this.locationData = location;
    }

    @Nullable
    public LocationData getLocation() {
        return this.locationData;
    }

    public int getClosingTime() {
        return (Integer)this.entityData.get(CLOSING_TIME);
    }

    public void setClosingTime(int closingTime) {
        this.entityData.set(CLOSING_TIME, (Object)closingTime);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public UUID getLinkedPortalId() {
        return this.linkedPortalId;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void teleportEntity(ServerLevel destinationLevel, BlockPos pos, Vec3 deltaMovement, Entity entity) {
        void var3_3;
        void var2_2;
        void var1_1;
        TimedoorEntityImpl.teleportEntity(destinationLevel, (BlockPos)var1_1, (Vec3)var2_2, (Entity)var3_3);
    }

    public TimedoorEntity getLinkedPortalEntity() {
        if (!this.level().isClientSide() && this.linkedPortalEntity == null) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            this.linkedPortalEntity = (TimedoorEntity)serverLevel.getEntity(this.linkedPortalId);
        }
        return this.linkedPortalEntity;
    }

    public void setLinkedPortalId(UUID id) {
        this.linkedPortalId = id;
        this.linkedPortalEntity = null;
    }

    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void resetClosingTime() {
        if (this.getClosingTime() != -1) {
            this.setClosingTime(this.tickCount + TempadConfig.timedoorWait);
        }
    }
}

