/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.items;

import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import java.util.List;
import java.util.UUID;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocationCard
extends Item {
    public LocationCard(Item.Properties properties) {
        super(properties);
    }

    public static void setLocation(ItemStack stack, LocationData locationData, String creator) {
        stack.getOrCreateTag().put("Location", (Tag)locationData.toTag());
        stack.getOrCreateTag().putString("Creator", creator);
    }

    @Nullable
    public static LocationData getLocation(ItemStack stack) {
        if (!stack.hasTag() || !stack.getTag().contains("Location")) {
            return null;
        }
        return LocationData.fromTag(stack.getOrCreateTag().getCompound("Location"));
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, level, tooltipComponents, isAdvanced);
        LocationData location = LocationCard.getLocation(stack);
        if (location != null) {
            tooltipComponents.add((Component)Component.translatable((String)"item.tempad.location_card.shift_toolip", (Object[])new Object[]{Component.literal((String)"SHIFT").withStyle(Screen.hasShiftDown() ? ChatFormatting.WHITE : ChatFormatting.GOLD)}).withStyle(ChatFormatting.GRAY));
            if (Screen.hasShiftDown()) {
                tooltipComponents.add((Component)Component.literal((String)location.getName()).withStyle(ChatFormatting.GRAY));
                tooltipComponents.add((Component)Component.translatable((String)"gui.tempad.x", (Object[])new Object[]{location.getBlockPos().getX()}).withStyle(ChatFormatting.GRAY));
                tooltipComponents.add((Component)Component.translatable((String)"gui.tempad.y", (Object[])new Object[]{location.getBlockPos().getY()}).withStyle(ChatFormatting.GRAY));
                tooltipComponents.add((Component)Component.translatable((String)"gui.tempad.z", (Object[])new Object[]{location.getBlockPos().getZ()}).withStyle(ChatFormatting.GRAY));
                tooltipComponents.add((Component)Component.translatable((String)"gui.tempad.dimension", (Object[])new Object[]{Component.translatable((String)location.getLevelKey().location().toLanguageKey("dimension"))}).withStyle(ChatFormatting.GRAY));
                if (stack.hasTag() && stack.getTag().contains("Creator")) {
                    tooltipComponents.add((Component)Component.translatable((String)"item.tempad.location_card.creator_toolip", (Object[])new Object[]{Component.translatable((String)stack.getTag().getString("Creator")).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY));
                }
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.tempad.location_card.add_location").withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.translatable((String)"item.tempad.location_card.set_name").withStyle(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (!level.isClientSide) {
            LocationData location = LocationCard.getLocation(player.getItemInHand(usedHand));
            if (location != null) {
                TempadLocationHandler.addLocation(level, player.getUUID(), location);
                player.getItemInHand(usedHand).shrink(1);
                player.displayClientMessage((Component)Component.translatable((String)"item.tempad.location_card.added_location", (Object[])new Object[]{Component.literal((String)location.getName()).withStyle(ChatFormatting.GOLD)}), true);
            } else {
                LocationData newLocation = new LocationData(player.getItemInHand(usedHand).getHoverName().getString(), (ResourceKey<Level>)level.dimension(), player.blockPosition(), (UUID)CommonUtils.generate(id -> !TempadLocationHandler.containsLocation(level, player.getUUID(), id), UUID::randomUUID));
                LocationCard.setLocation(player.getItemInHand(usedHand), newLocation, player.getDisplayName().getString());
                player.displayClientMessage((Component)Component.translatable((String)"item.tempad.location_card.set_location", (Object[])new Object[]{Component.literal((String)newLocation.getName()).withStyle(ChatFormatting.GOLD)}), true);
            }
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
    }
}

