/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.items;

import com.teamresourceful.resourcefullib.common.network.Packet;
import java.util.ArrayList;
import java.util.List;
import me.codexadrian.tempad.api.options.TempadOption;
import me.codexadrian.tempad.api.options.TempadOptionApi;
import me.codexadrian.tempad.client.config.TempadClientConfig;
import me.codexadrian.tempad.common.Tempad;
import me.codexadrian.tempad.common.config.ConfigCache;
import me.codexadrian.tempad.common.config.TempadConfig;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import me.codexadrian.tempad.common.entity.TimedoorEntity;
import me.codexadrian.tempad.common.items.TempadPower;
import me.codexadrian.tempad.common.network.NetworkHandler;
import me.codexadrian.tempad.common.network.messages.s2c.OpenTempadScreenPacket;
import me.codexadrian.tempad.common.registry.TempadRegistry;
import me.codexadrian.tempad.common.utils.ClientUtils;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TempadItem
extends Item
implements TempadPower {
    public TempadItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public TempadOption getOption() {
        return TempadOptionApi.getOption(ConfigCache.tempadFuelType);
    }

    @Override
    public int getFuelCost() {
        return ConfigCache.tempadFuelConsumptionValue;
    }

    @Override
    public int getFuelCapacity() {
        return ConfigCache.tempadFuelCapacityValue;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack stack = player.getItemInHand(interactionHand);
        if (!player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                OpenTempadScreenPacket packet = new OpenTempadScreenPacket(new ArrayList<LocationData>(TempadLocationHandler.getLocations(level, player.getUUID()).values()), TempadLocationHandler.getFavorite(level, player.getUUID()));
                NetworkHandler.CHANNEL.sendToPlayer((Packet)packet, player);
                return InteractionResultHolder.success((Object)stack);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
        if (level.isClientSide) {
            ClientUtils.openFavorited();
            return InteractionResultHolder.pass((Object)stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public static void summonTimeDoor(LocationData locationData, Player player, int color) {
        TimedoorEntity timedoor = new TimedoorEntity((EntityType<TimedoorEntity>)((EntityType)TempadRegistry.TIMEDOOR_ENTITY.get()), player.level());
        Direction dir = player.getDirection();
        timedoor.setColor(color);
        timedoor.setLocation(locationData);
        timedoor.setOwner(player.getUUID());
        Vec3 position = player.position();
        timedoor.setPos(position.x() + (double)(dir.getStepX() * TempadConfig.distanceFromPlayer), position.y(), position.z() + (double)(dir.getStepZ() * TempadConfig.distanceFromPlayer));
        timedoor.setYRot(dir.getOpposite().toYRot());
        player.level().addFreshEntity((Entity)timedoor);
        timedoor.playSound(Tempad.TIMEDOOR_SOUND.get());
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        this.getOption().addToolTip(stack, level, components, flag);
    }

    public int getBarColor(@NotNull ItemStack $$0) {
        return TempadClientConfig.color;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return this.getOption().isDurabilityBarVisible(stack);
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return this.getOption().durabilityBarWidth(stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        this.getOption().tick(stack, entity);
    }
}

