/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.neoforge;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import me.codexadrian.tempad.client.TempadClient;
import me.codexadrian.tempad.client.render.TimedoorRenderer;
import me.codexadrian.tempad.common.BlurReloader;
import me.codexadrian.tempad.common.registry.TempadRegistry;
import me.codexadrian.tempad.common.utils.ClientUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;

@Mod.EventBusSubscriber(modid="tempad", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ForgeTempadClient {
    public static ShaderInstance timedoorShader;
    public static final BlurReloader BLUR_RELOADER;
    private static final KeyMapping SHORTCUT_KEYBIND;
    private static final KeyMapping FAVORITED_KEYBIND;

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        TempadClient.init();
        EntityRenderers.register((EntityType)((EntityType)TempadRegistry.TIMEDOOR_ENTITY.get()), TimedoorRenderer::new);
        event.enqueueWork(TempadClient::initItemProperties);
        NeoForge.EVENT_BUS.addListener(ForgeTempadClient::onClientTick);
        ((ReloadableResourceManager)Minecraft.getInstance().getResourceManager()).registerReloadListener((PreparableReloadListener)BLUR_RELOADER);
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("rendertype_timedoor"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP), shaderInstance -> {
            timedoorShader = shaderInstance;
        });
    }

    @SubscribeEvent
    public static void registerKeyBinding(RegisterKeyMappingsEvent event) {
        event.register(SHORTCUT_KEYBIND);
        event.register(FAVORITED_KEYBIND);
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (SHORTCUT_KEYBIND.consumeClick()) {
                ClientUtils.openTempadbyShortcut();
            }
            while (FAVORITED_KEYBIND.consumeClick()) {
                ClientUtils.openFavorited();
            }
        }
    }

    static {
        BLUR_RELOADER = new BlurReloader();
        SHORTCUT_KEYBIND = new KeyMapping("key.tempad.shortcut", InputConstants.Type.KEYSYM, 66, "category.tempad.keybinds");
        FAVORITED_KEYBIND = new KeyMapping("key.tempad.favorite", InputConstants.Type.KEYSYM, 71, "category.tempad.keybinds");
    }
}

