/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.network.messages.c2s;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import java.util.UUID;
import java.util.function.Consumer;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import me.codexadrian.tempad.common.utils.TeleportUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public record AddLocationPacket(String name) implements Packet<AddLocationPacket>
{
    public static final Handler HANDLER = new Handler();

    public PacketType<AddLocationPacket> type() {
        return HANDLER;
    }

    public static class Handler
    implements ServerboundPacketType<AddLocationPacket> {
        public static final ResourceLocation ID = new ResourceLocation("tempad", "add_location");

        public Class<AddLocationPacket> type() {
            return AddLocationPacket.class;
        }

        public ResourceLocation id() {
            return ID;
        }

        public void encode(AddLocationPacket message, FriendlyByteBuf buffer) {
            buffer.writeUtf(message.name);
        }

        public AddLocationPacket decode(FriendlyByteBuf buffer) {
            return new AddLocationPacket(buffer.readUtf());
        }

        public Consumer<Player> handle(AddLocationPacket message) {
            return player -> {
                if (!TeleportUtils.hasTempad(player)) {
                    return;
                }
                UUID uuid = (UUID)CommonUtils.generate(id -> !TempadLocationHandler.containsLocation(player.level(), player.getUUID(), id), UUID::randomUUID);
                LocationData tempadLocation = new LocationData(message.name, (ResourceKey<Level>)player.level().dimension(), BlockPos.containing((double)player.getX(), (double)Math.ceil(player.getY()), (double)player.getZ()), uuid);
                TempadLocationHandler.addLocation(player.level(), player.getUUID(), tempadLocation);
            };
        }
    }
}

