/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.network.messages.c2s;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import java.util.UUID;
import java.util.function.Consumer;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import me.codexadrian.tempad.common.utils.TeleportUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record DeleteLocationPacket(UUID location) implements Packet<DeleteLocationPacket>
{
    public static final Handler HANDLER = new Handler();

    public PacketType<DeleteLocationPacket> type() {
        return HANDLER;
    }

    public static class Handler
    implements ServerboundPacketType<DeleteLocationPacket> {
        public static final ResourceLocation ID = new ResourceLocation("tempad", "delete_location");

        public Class<DeleteLocationPacket> type() {
            return DeleteLocationPacket.class;
        }

        public ResourceLocation id() {
            return ID;
        }

        public DeleteLocationPacket decode(FriendlyByteBuf buf) {
            return new DeleteLocationPacket(buf.readUUID());
        }

        public void encode(DeleteLocationPacket packet, FriendlyByteBuf buffer) {
            buffer.writeUUID(packet.location);
        }

        public Consumer<Player> handle(DeleteLocationPacket message) {
            return player -> {
                if (TeleportUtils.hasTempad(player)) {
                    TempadLocationHandler.removeLocation(player.level(), player.getUUID(), message.location);
                }
            };
        }
    }
}

