/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.network.messages.c2s;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import java.util.UUID;
import java.util.function.Consumer;
import me.codexadrian.tempad.common.config.TempadConfig;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import me.codexadrian.tempad.common.items.LocationCard;
import me.codexadrian.tempad.common.items.TempadItem;
import me.codexadrian.tempad.common.registry.TempadRegistry;
import me.codexadrian.tempad.common.utils.TeleportUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record ExportLocationPacket(UUID location) implements Packet<ExportLocationPacket>
{
    public static final Handler HANDLER = new Handler();

    public PacketType<ExportLocationPacket> type() {
        return HANDLER;
    }

    public static class Handler
    implements ServerboundPacketType<ExportLocationPacket> {
        public static final ResourceLocation ID = new ResourceLocation("tempad", "export");

        public Class<ExportLocationPacket> type() {
            return ExportLocationPacket.class;
        }

        public ResourceLocation id() {
            return ID;
        }

        public ExportLocationPacket decode(FriendlyByteBuf buf) {
            return new ExportLocationPacket(buf.readUUID());
        }

        public void encode(ExportLocationPacket packet, FriendlyByteBuf buffer) {
            buffer.writeUUID(packet.location);
        }

        public Consumer<Player> handle(ExportLocationPacket message) {
            return player -> {
                TempadItem tempadItem;
                if (!TeleportUtils.hasTempad(player)) {
                    return;
                }
                ItemStack itemInHand = TeleportUtils.findTempad(player);
                Item patt2245$temp = itemInHand.getItem();
                if (patt2245$temp instanceof TempadItem && (tempadItem = (TempadItem)patt2245$temp).getOption().canTimedoorOpen((Player)player, itemInHand)) {
                    LocationData locationData;
                    if (!player.getAbilities().instabuild) {
                        tempadItem.getOption().onTimedoorOpen((Player)player);
                    }
                    if ((locationData = TempadLocationHandler.getLocation(player.level(), player.getUUID(), message.location)).isDownloadable() && TempadConfig.allowExporting) {
                        ItemStack stack = new ItemStack((ItemLike)TempadRegistry.LOCATION_CARD.get());
                        LocationCard.setLocation(stack, locationData, player.getDisplayName().getString());
                        player.getInventory().placeItemBackInInventory(stack);
                    }
                }
            };
        }
    }
}

