/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.network.messages.c2s;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record FavoriteLocationPacket(@Nullable UUID location) implements Packet<FavoriteLocationPacket>
{
    public static final Handler HANDLER = new Handler();

    public PacketType<FavoriteLocationPacket> type() {
        return HANDLER;
    }

    public static class Handler
    implements ServerboundPacketType<FavoriteLocationPacket> {
        public static final ResourceLocation ID = new ResourceLocation("tempad", "favorite_location");

        public Class<FavoriteLocationPacket> type() {
            return FavoriteLocationPacket.class;
        }

        public ResourceLocation id() {
            return ID;
        }

        public FavoriteLocationPacket decode(FriendlyByteBuf buffer) {
            return new FavoriteLocationPacket(buffer.readOptional(FriendlyByteBuf::readUUID).orElse(null));
        }

        public void encode(FavoriteLocationPacket packet, FriendlyByteBuf buffer) {
            buffer.writeOptional(Optional.ofNullable(packet.location), FriendlyByteBuf::writeUUID);
        }

        public Consumer<Player> handle(FavoriteLocationPacket message) {
            return player -> {
                TempadLocationHandler.getFavorite(player.level(), player.getUUID());
                if (message.location != null) {
                    TempadLocationHandler.favoriteLocation(player.level(), player.getUUID(), message.location);
                } else {
                    TempadLocationHandler.unfavoriteLocation(player.level(), player.getUUID());
                }
            };
        }
    }
}

