/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.network.messages.c2s;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import java.util.function.Consumer;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import me.codexadrian.tempad.common.items.TempadItem;
import me.codexadrian.tempad.common.utils.TeleportUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record OpenFavoritedLocationPacket(int color) implements Packet<OpenFavoritedLocationPacket>
{
    public static final Handler HANDLER = new Handler();

    public PacketType<OpenFavoritedLocationPacket> type() {
        return HANDLER;
    }

    public static class Handler
    implements ServerboundPacketType<OpenFavoritedLocationPacket> {
        public static final ResourceLocation ID = new ResourceLocation("tempad", "shortcut_favorited");

        public Class<OpenFavoritedLocationPacket> type() {
            return OpenFavoritedLocationPacket.class;
        }

        public ResourceLocation id() {
            return ID;
        }

        public OpenFavoritedLocationPacket decode(FriendlyByteBuf buffer) {
            return new OpenFavoritedLocationPacket(buffer.readVarInt());
        }

        public void encode(OpenFavoritedLocationPacket packet, FriendlyByteBuf buffer) {
            buffer.writeVarInt(packet.color);
        }

        public Consumer<Player> handle(OpenFavoritedLocationPacket message) {
            return player -> {
                TempadItem tempadItem;
                Item patt2277$temp;
                ItemStack tempadStack = TeleportUtils.findTempad(player);
                LocationData locationData = TempadLocationHandler.getLocation(player.level(), player.getUUID(), TempadLocationHandler.getFavorite(player.level(), player.getUUID()));
                if (locationData != null && (patt2277$temp = tempadStack.getItem()) instanceof TempadItem && (tempadItem = (TempadItem)patt2277$temp).getOption().canTimedoorOpen((Player)player, tempadStack) && TeleportUtils.mayTeleport(locationData.getLevelKey(), player)) {
                    if (!player.getAbilities().instabuild) {
                        tempadItem.getOption().onTimedoorOpen((Player)player);
                    }
                    TempadItem.summonTimeDoor(locationData, player, message.color);
                }
            };
        }
    }
}

