/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.network.messages.c2s;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import java.util.UUID;
import java.util.function.Consumer;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import me.codexadrian.tempad.common.items.TempadItem;
import me.codexadrian.tempad.common.utils.TeleportUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record SummonTimedoorPacket(UUID location, int color) implements Packet<SummonTimedoorPacket>
{
    public static final Handler HANDLER = new Handler();

    public PacketType<SummonTimedoorPacket> type() {
        return HANDLER;
    }

    public static class Handler
    implements ServerboundPacketType<SummonTimedoorPacket> {
        public static final ResourceLocation ID = new ResourceLocation("tempad", "timedoor");

        public Class<SummonTimedoorPacket> type() {
            return SummonTimedoorPacket.class;
        }

        public ResourceLocation id() {
            return ID;
        }

        public SummonTimedoorPacket decode(FriendlyByteBuf buffer) {
            return new SummonTimedoorPacket(buffer.readUUID(), buffer.readVarInt());
        }

        public void encode(SummonTimedoorPacket packet, FriendlyByteBuf buffer) {
            buffer.writeUUID(packet.location);
            buffer.writeVarInt(packet.color);
        }

        public Consumer<Player> handle(SummonTimedoorPacket message) {
            return player -> {
                TempadItem tempadItem;
                Item patt2248$temp;
                ItemStack itemInHand = TeleportUtils.findTempad(player);
                LocationData locationData = TempadLocationHandler.getLocation(player.level(), player.getUUID(), message.location);
                if (locationData != null && (patt2248$temp = itemInHand.getItem()) instanceof TempadItem && (tempadItem = (TempadItem)patt2248$temp).getOption().canTimedoorOpen((Player)player, itemInHand) && TeleportUtils.mayTeleport(locationData.getLevelKey(), player)) {
                    if (!player.getAbilities().instabuild) {
                        tempadItem.getOption().onTimedoorOpen((Player)player);
                    }
                    TempadItem.summonTimeDoor(locationData, player, message.color);
                }
            };
        }
    }
}

