/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import me.codexadrian.tempad.common.Tempad;
import me.codexadrian.tempad.common.config.ConfigCache;
import me.codexadrian.tempad.common.config.TempadConfig;
import me.codexadrian.tempad.common.items.TempadItem;
import me.codexadrian.tempad.common.utils.BaubleUtils;
import me.codexadrian.tempad.common.utils.neoforge.TeleportUtilsImpl;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TeleportUtils {
    public static boolean mayTeleport(ResourceKey<Level> level, Player player) {
        Optional levelReference;
        if (player.isCreative()) {
            return true;
        }
        Optional lookup = player.level().registryAccess().lookup(Registries.DIMENSION);
        if (lookup.isPresent() && (levelReference = ((HolderLookup.RegistryLookup)lookup.get()).get(level)).isPresent() && ((Holder.Reference)levelReference.get()).is(Tempad.TEMPAD_DIMENSION_BLACKLIST)) {
            return false;
        }
        return level.equals((Object)player.level().dimension()) || (player.level().isClientSide() ? ConfigCache.allowInterdimensionalTravel : TempadConfig.allowInterdimensionalTravel);
    }

    public static ItemStack findAndReplaceTempad(Player player, @Nullable ItemStack replacementTempad) {
        AtomicReference<ItemStack> tempad = new AtomicReference<ItemStack>(ItemStack.EMPTY);
        Consumer<ItemStack> setTempad = null;
        if (TeleportUtils.isBaubleModLoaded()) {
            setTempad = BaubleUtils.findTempadInBaubles(player, tempad::set);
        }
        if (setTempad != null) {
            if (replacementTempad != null) {
                setTempad.accept(replacementTempad);
            }
            return tempad.get();
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof TempadItem)) continue;
            TempadItem tempadItem = (TempadItem)item;
            tempad.set(stack);
            int finalI = i;
            setTempad = itemStack -> player.getInventory().setItem(finalI, itemStack);
            if (tempadItem.getOption().canTimedoorOpen(player, tempad.get())) break;
        }
        if (replacementTempad != null && setTempad != null) {
            setTempad.accept(replacementTempad);
        }
        return tempad.get();
    }

    public static ItemStack findTempad(Player player) {
        return TeleportUtils.findAndReplaceTempad(player, null);
    }

    public static boolean hasTempad(Player player) {
        return !TeleportUtils.findTempad(player).isEmpty();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isBaubleModLoaded() {
        return TeleportUtilsImpl.isBaubleModLoaded();
    }
}

