/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.utils.neoforge;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import me.codexadrian.tempad.common.items.TempadItem;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class BaubleUtilsImpl {
    @Nullable
    public static Consumer<ItemStack> findTempadInBaubles(Player player, Consumer<ItemStack> setTempad) {
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)player);
        AtomicReference<ItemStack> tempad = new AtomicReference<ItemStack>(ItemStack.EMPTY);
        AtomicReference<Object> setter = new AtomicReference<Object>(null);
        if (curiosInventory.isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)curiosInventory.orElseThrow(NullPointerException::new);
            handler.getCurios().forEach((identifier, stackHandler) -> {
                IDynamicStackHandler groupInventory = stackHandler.getStacks();
                for (int i = 0; i < groupInventory.getSlots(); ++i) {
                    ItemStack stack = groupInventory.getStackInSlot(i);
                    Item patt1437$temp = stack.getItem();
                    if (!(patt1437$temp instanceof TempadItem)) continue;
                    TempadItem tempadItem = (TempadItem)patt1437$temp;
                    boolean isViable = tempadItem.getOption().canTimedoorOpen(player, stack);
                    if (tempad.get() != ItemStack.EMPTY && !isViable) continue;
                    setTempad.accept(stack);
                    tempad.set(stack);
                    int tempadSlot = i;
                    setter.set(itemStack -> ((ICurioStacksHandler)handler.getCurios().get(identifier)).getStacks().setStackInSlot(tempadSlot, itemStack));
                    if (!isViable) continue;
                    return;
                }
            });
        }
        return setter.get();
    }
}

