/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.GroupBehaviour;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.object.BrainBehaviourConsumer;
import net.tslat.smartbrainlib.object.BrainBehaviourPredicate;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class SmartBrain<E extends LivingEntity>
extends Brain<E> {
    private final List<MemoryModuleType<?>> expirableMemories = new ObjectArrayList();
    private final List<ActivityBehaviours<E>> behaviours = new ObjectArrayList();
    private final List<Pair<SensorType<ExtendedSensor<? super E>>, ExtendedSensor<? super E>>> sensors = new ObjectArrayList();
    private SmartBrainSchedule schedule = null;
    private boolean sortBehaviours = false;

    public SmartBrain(List<MemoryModuleType<?>> memories, List<? extends ExtendedSensor<E>> sensors, @Nullable List<BrainActivityGroup<E>> taskList, boolean saveMemories) {
        super(memories, (Collection)ImmutableList.of(), ImmutableList.of(), saveMemories ? () -> Brain.codec((Collection)memories, SmartBrain.convertSensorsToTypes(sensors)) : SmartBrain::emptyBrainCodec);
        for (ExtendedSensor<E> extendedSensor : sensors) {
            this.sensors.add(Pair.of(extendedSensor.type(), extendedSensor));
        }
        if (taskList != null) {
            for (BrainActivityGroup brainActivityGroup : taskList) {
                this.addActivity(brainActivityGroup);
            }
        }
    }

    public void tick(ServerLevel level, E entity) {
        entity.level().getProfiler().push("SmartBrain");
        if (this.sortBehaviours) {
            this.behaviours.sort(Comparator.comparingInt(ActivityBehaviours::priority));
        }
        this.forgetOutdatedMemories();
        this.tickSensors(level, entity);
        this.checkForNewBehaviours(level, entity);
        this.tickRunningBehaviours(level, entity);
        this.findAndSetActiveActivity(entity);
        entity.level().getProfiler().pop();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.setAggressive(BrainUtils.hasMemory((LivingEntity)mob, MemoryModuleType.ATTACK_TARGET));
        }
    }

    private void findAndSetActiveActivity(E entity) {
        Activity scheduledActivity;
        if (this.schedule != null && (scheduledActivity = this.schedule.tick((LivingEntity)entity)) != null && !this.getActiveActivities().contains(scheduledActivity) && this.activityRequirementsAreMet(scheduledActivity)) {
            this.setActiveActivity(scheduledActivity);
            return;
        }
        this.setActiveActivityToFirstValid(((SmartBrainOwner)entity).getActivityPriorities());
    }

    private void tickSensors(ServerLevel level, E entity) {
        for (Pair<SensorType<ExtendedSensor<? super E>>, ExtendedSensor<? super E>> pair : this.sensors) {
            ((ExtendedSensor)((Object)pair.getSecond())).tick(level, entity);
        }
    }

    private void checkForNewBehaviours(ServerLevel level, E entity) {
        long gameTime = level.getGameTime();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : behaviourGroup.behaviours) {
                if (!this.getActiveActivities().contains(pair.getFirst())) continue;
                for (BehaviorControl behaviour : (List)pair.getSecond()) {
                    if (behaviour.getStatus() != Behavior.Status.STOPPED) continue;
                    behaviour.tryStart(level, entity, gameTime);
                }
            }
        }
    }

    private void tickRunningBehaviours(ServerLevel level, E entity) {
        long gameTime = level.getGameTime();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : behaviourGroup.behaviours) {
                for (BehaviorControl behaviour : (List)pair.getSecond()) {
                    if (behaviour.getStatus() != Behavior.Status.RUNNING) continue;
                    behaviour.tickOrStop(level, entity, gameTime);
                }
            }
        }
    }

    public void forgetOutdatedMemories() {
        Iterator<MemoryModuleType<?>> expirable = this.expirableMemories.iterator();
        while (expirable.hasNext()) {
            MemoryModuleType<?> memoryType = expirable.next();
            Optional memory = (Optional)this.memories.get(memoryType);
            if (memory.isEmpty()) {
                expirable.remove();
                continue;
            }
            ExpirableValue value = (ExpirableValue)memory.get();
            if (!value.canExpire()) {
                expirable.remove();
                continue;
            }
            if (value.hasExpired()) {
                expirable.remove();
                this.eraseMemory(memoryType);
                continue;
            }
            value.tick();
        }
    }

    public void stopAll(ServerLevel level, E entity) {
        long gameTime = level.getGameTime();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : behaviourGroup.behaviours) {
                for (BehaviorControl behaviour : (List)pair.getSecond()) {
                    if (behaviour.getStatus() != Behavior.Status.RUNNING) continue;
                    behaviour.doStop(level, entity, gameTime);
                }
            }
        }
    }

    public <U> Optional<U> getMemory(MemoryModuleType<U> type) {
        return this.memories.computeIfAbsent(type, key -> Optional.empty()).map(ExpirableValue::getValue);
    }

    public <U> void setMemoryInternal(MemoryModuleType<U> memoryType, Optional<? extends ExpirableValue<?>> memory) {
        Collection collection;
        Object object;
        if (memory.isPresent() && (object = memory.get().getValue()) instanceof Collection && (collection = (Collection)object).isEmpty()) {
            memory = Optional.empty();
        }
        this.memories.put(memoryType, memory);
        if (memory.isPresent() && memory.get().canExpire() && !this.expirableMemories.contains(memoryType)) {
            this.expirableMemories.add(memoryType);
        }
    }

    public <U> boolean isMemoryValue(MemoryModuleType<U> memoryType, U memory) {
        Optional<U> value = this.getMemory(memoryType);
        return value.isPresent() && value.get().equals(memory);
    }

    private static <E extends LivingEntity> Codec<Brain<E>> emptyBrainCodec() {
        MutableObject brainCodec = new MutableObject();
        brainCodec.setValue((Object)Codec.unit(() -> new Brain((Collection)ImmutableList.of(), (Collection)ImmutableList.of(), ImmutableList.of(), () -> ((MutableObject)brainCodec).getValue())));
        return (Codec)brainCodec.getValue();
    }

    private static <E extends LivingEntity> List<? extends SensorType<? extends Sensor<? super E>>> convertSensorsToTypes(List<? extends ExtendedSensor<E>> sensors) {
        ObjectArrayList types = new ObjectArrayList(sensors.size());
        for (ExtendedSensor<E> sensor : sensors) {
            types.add(sensor.type());
        }
        return types;
    }

    public Brain<E> copyWithoutBehaviors() {
        SmartBrain<E> brain = new SmartBrain<E>(this.memories.keySet().stream().toList(), this.sensors.stream().map(pair -> (ExtendedSensor)((Object)((Object)pair.getSecond()))).toList(), null, false);
        for (Map.Entry entry : this.memories.entrySet()) {
            MemoryModuleType memoryType = (MemoryModuleType)entry.getKey();
            if (!((Optional)entry.getValue()).isPresent()) continue;
            brain.memories.put(memoryType, (Optional)entry.getValue());
        }
        return brain;
    }

    public List<BehaviorControl<? super E>> getRunningBehaviors() {
        ObjectArrayList runningBehaviours = new ObjectArrayList();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : behaviourGroup.behaviours) {
                for (BehaviorControl behaviour : (List)pair.getSecond()) {
                    if (behaviour.getStatus() != Behavior.Status.RUNNING) continue;
                    runningBehaviours.add(behaviour);
                }
            }
        }
        return runningBehaviours;
    }

    public Stream<BehaviorControl<? super E>> getBehaviours() {
        return this.behaviours.stream().map(ActivityBehaviours::behaviours).flatMap(list -> list.stream().map(Pair::getSecond).flatMap(Collection::stream));
    }

    public void removeAllBehaviors() {
        this.behaviours.clear();
    }

    public void addActivityAndRemoveMemoriesWhenStopped(Activity activity, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> tasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> memorieStatuses, Set<MemoryModuleType<?>> memoryTypes) {
        this.activityRequirements.put(activity, memorieStatuses);
        if (!memoryTypes.isEmpty()) {
            this.activityMemoriesToEraseWhenStopped.put(activity, memoryTypes);
        }
        for (Pair pair : tasks) {
            this.addBehaviour((Integer)pair.getFirst(), activity, (BehaviorControl)pair.getSecond());
        }
    }

    public void addActivity(BrainActivityGroup<E> activityGroup) {
        this.addActivityAndRemoveMemoriesWhenStopped(activityGroup.getActivity(), activityGroup.pairBehaviourPriorities(), activityGroup.getActivityStartMemoryConditions(), activityGroup.getWipedMemoriesOnFinish());
    }

    public void addBehaviour(int priority, Activity activity, BehaviorControl<? super E> behaviour) {
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            if (behaviourGroup.priority != priority) continue;
            for (Pair pair : behaviourGroup.behaviours) {
                if (pair.getFirst() != activity) continue;
                ((List)pair.getSecond()).add(behaviour);
                return;
            }
            behaviourGroup.behaviours.add(Pair.of((Object)activity, (Object)ObjectArrayList.of((Object[])new BehaviorControl[]{behaviour})));
            return;
        }
        this.behaviours.add(new ActivityBehaviours(priority, ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)activity, (Object)ObjectArrayList.of((Object[])new BehaviorControl[]{behaviour}))})));
        this.sortBehaviours = true;
    }

    public void removeBehaviour(E entity, BrainBehaviourPredicate predicate) {
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            int priority = behaviourGroup.priority;
            for (Pair pair : behaviourGroup.behaviours) {
                Activity activity = (Activity)pair.getFirst();
                Iterator iterator = ((List)pair.getSecond()).iterator();
                while (iterator.hasNext()) {
                    BehaviorControl behaviour = (BehaviorControl)iterator.next();
                    SmartBrain.checkBehaviour(priority, activity, behaviour, null, predicate, () -> {
                        if (behaviour.getStatus() == Behavior.Status.RUNNING) {
                            behaviour.doStop((ServerLevel)entity.level(), entity, entity.level().getGameTime());
                        }
                        iterator.remove();
                    });
                }
            }
        }
    }

    public SmartBrain<E> setSchedule(SmartBrainSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public SmartBrainSchedule getSchedule() {
        return this.schedule;
    }

    public void scheduleTask(E brainOwner, int delay, Consumer<E> task) {
        if (this.schedule == null) {
            this.schedule = new SmartBrainSchedule();
        }
        this.schedule.scheduleTask((LivingEntity)brainOwner, delay, task);
    }

    private static <E extends LivingEntity> void checkBehaviour(int priority, Activity activity, BehaviorControl<E> behaviour, @Nullable BehaviorControl<E> parentBehaviour, BrainBehaviourPredicate predicate, Runnable callback) {
        if (predicate.isBehaviour(priority, activity, behaviour, parentBehaviour)) {
            callback.run();
        } else if (behaviour instanceof GateBehavior) {
            GateBehavior groupBehaviour = (GateBehavior)behaviour;
            Iterator childBehaviourIterator = groupBehaviour.behaviors.iterator();
            while (childBehaviourIterator.hasNext()) {
                SmartBrain.checkBehaviour(priority, activity, (BehaviorControl)childBehaviourIterator.next(), groupBehaviour, predicate, childBehaviourIterator::remove);
            }
            if (!groupBehaviour.behaviors.iterator().hasNext()) {
                callback.run();
            }
        } else if (behaviour instanceof GroupBehaviour) {
            GroupBehaviour groupBehaviour = (GroupBehaviour)behaviour;
            Iterator childBehaviourIterator = groupBehaviour.getBehaviours();
            while (childBehaviourIterator.hasNext()) {
                SmartBrain.checkBehaviour(priority, activity, (BehaviorControl)childBehaviourIterator.next(), groupBehaviour, predicate, childBehaviourIterator::remove);
            }
            if (!groupBehaviour.getBehaviours().hasNext()) {
                callback.run();
            }
        }
    }

    public void forEachBehaviour(BrainBehaviourConsumer consumer) {
        for (ActivityBehaviours<E> behavioursGroup : this.behaviours) {
            int priority = behavioursGroup.priority();
            for (Pair<Activity, List<BehaviorControl<E>>> behaviourList : behavioursGroup.behaviours()) {
                Activity activity = (Activity)behaviourList.getFirst();
                for (BehaviorControl behaviour : (List)behaviourList.getSecond()) {
                    SmartBrain.consumeBehaviour(priority, activity, behaviour, null, consumer);
                }
            }
        }
    }

    private static <E extends LivingEntity> void consumeBehaviour(int priority, Activity activity, BehaviorControl<E> behaviour, @Nullable BehaviorControl<E> parentBehaviour, BrainBehaviourConsumer consumer) {
        consumer.consume(priority, activity, behaviour, parentBehaviour);
        if (behaviour instanceof GateBehavior) {
            GateBehavior groupBehaviour = (GateBehavior)behaviour;
            groupBehaviour.behaviors.stream().forEach(childBehaviour -> SmartBrain.consumeBehaviour(priority, activity, childBehaviour, groupBehaviour, consumer));
        } else if (behaviour instanceof GroupBehaviour) {
            GroupBehaviour groupBehaviour = (GroupBehaviour)behaviour;
            groupBehaviour.getBehaviours().forEachRemaining(childBehaviour -> SmartBrain.consumeBehaviour(priority, activity, childBehaviour, groupBehaviour, consumer));
        }
    }

    public void addSensor(ExtendedSensor<E> sensor) {
        SensorType<ExtendedSensor<?>> sensorType = sensor.type();
        this.sensors.add(Pair.of(sensorType, sensor));
    }

    @Deprecated(forRemoval=true)
    public final void setSchedule(Schedule schedule) {
    }

    private record ActivityBehaviours<E extends LivingEntity>(int priority, List<Pair<Activity, List<BehaviorControl<? super E>>>> behaviours) {
    }
}

