/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.player.Player;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.TriPredicate;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.apache.logging.log4j.util.TriConsumer;

public class SetAdditionalAttackTargets<E extends Mob>
extends ExtendedBehaviour<E> {
    private final List<MemoryModuleType<? extends LivingEntity>> targetingMemories = new ObjectArrayList();
    protected TriPredicate<E, MemoryModuleType<? extends LivingEntity>, LivingEntity> canAttackPredicate = (owner, memory, target) -> {
        if (!target.isAlive()) return false;
        if (!(target instanceof Player)) return false;
        Player player = (Player)target;
        if (player.getAbilities().invulnerable) return false;
        return true;
    };
    protected TriConsumer<E, MemoryModuleType<? extends LivingEntity>, LivingEntity> targetCallback = (owner, memory, target) -> {};
    protected boolean avoidDuplicateTargets = true;

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of();
    }

    public SetAdditionalAttackTargets<E> attackablePredicate(TriPredicate<E, MemoryModuleType<? extends LivingEntity>, LivingEntity> predicate) {
        this.canAttackPredicate = predicate;
        return this;
    }

    public SetAdditionalAttackTargets<E> whenTargeting(TriConsumer<E, MemoryModuleType<? extends LivingEntity>, LivingEntity> callback) {
        this.targetCallback = callback;
        return this;
    }

    public SetAdditionalAttackTargets<E> withMemories(MemoryModuleType<? extends LivingEntity> ... targetMemories) {
        this.targetingMemories.addAll(List.of(targetMemories));
        return this;
    }

    public SetAdditionalAttackTargets<E> allowDuplicateTargeting() {
        this.avoidDuplicateTargets = false;
        return this;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        Brain brain = entity.getBrain();
        for (MemoryModuleType<? extends LivingEntity> memory : this.targetingMemories) {
            if (BrainUtils.hasMemory(brain, memory)) continue;
            return true;
        }
        return BrainUtils.hasMemory(brain, MemoryModuleType.NEAREST_PLAYERS) || BrainUtils.hasMemory(brain, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }

    @Override
    protected void start(E entity) {
        Brain brain = entity.getBrain();
        ObjectOpenHashSet targetPool = new ObjectOpenHashSet();
        BrainUtils.withMemory(brain, MemoryModuleType.NEAREST_PLAYERS, ((Set)targetPool)::addAll);
        BrainUtils.withMemory(brain, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, arg_0 -> SetAdditionalAttackTargets.lambda$start$3((Set)targetPool, arg_0));
        if (targetPool.isEmpty()) {
            return;
        }
        for (MemoryModuleType<? extends LivingEntity> memory : this.targetingMemories) {
            LivingEntity target = BrainUtils.getMemory(brain, memory);
            if (target != null) continue;
            LivingEntity newTarget = null;
            Iterator iterator = targetPool.iterator();
            while (iterator.hasNext()) {
                newTarget = (LivingEntity)iterator.next();
                if (this.canAttackPredicate.test(entity, memory, newTarget)) {
                    BrainUtils.setMemory(brain, memory, newTarget);
                    this.targetCallback.accept(entity, memory, (Object)newTarget);
                    iterator.remove();
                    break;
                }
                newTarget = null;
            }
            if (newTarget == null || this.avoidDuplicateTargets) continue;
            targetPool.add(newTarget);
        }
    }

    private static /* synthetic */ void lambda$start$3(Set targetPool, NearestVisibleLivingEntities memory) {
        memory.findAll(target -> true).forEach(targetPool::add);
    }
}

