/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.inventory;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sunekaer.toolkit.commands.inventory.InventoryCollector;
import com.sunekaer.toolkit.network.Handler;
import com.sunekaer.toolkit.network.SetCopy;
import com.sunekaer.toolkit.utils.CommandUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CopyCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"copy").then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests(InventoryCollector::suggestions).executes(CopyCommand::copy));
    }

    private static int copy(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        InventoryCollector type = InventoryCollector.fromString(StringArgumentType.getString(context, (String)"type"));
        if (type == null) {
            source.sendFailure((Component)Component.literal((String)"Invalid type"));
            return 0;
        }
        ServerPlayer player = source.getPlayerOrException();
        List<ItemStack> itemCollection = type.itemCollector.apply((Player)player);
        StringBuilder clipboard = new StringBuilder();
        for (ItemStack stack : itemCollection) {
            if (stack.isEmpty()) continue;
            String itemName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).toString();
            Object withNBT = "";
            CompoundTag nbt = stack.save(new CompoundTag());
            if (nbt.contains("tag")) {
                withNBT = (String)withNBT + nbt.get("tag");
            }
            clipboard.append(itemName).append((String)withNBT).append(CommandUtils.NEW_LINE);
        }
        source.sendSuccess(() -> Component.translatable((String)"commands.toolkit.clipboard.copied"), true);
        Handler.CHANNEL.sendToPlayer(player, (Object)new SetCopy(clipboard.toString()));
        return 1;
    }
}

