/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.items;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.sunekaer.toolkit.utils.EnchantmentHacks;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;

public class EnchantCommand {
    public static final SimpleCommandExceptionType ERROR_MISSING_PLAYER = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.toolkit.failed.missing_player"));
    private static final Dynamic2CommandExceptionType ERROR_MISSING_ENCHANTMENT = new Dynamic2CommandExceptionType((a, b) -> Component.translatable((String)"commands.toolkit.enchant.failed.missing_enchant", (Object[])new Object[]{a, b}));
    private static final DynamicCommandExceptionType ERROR_INCOMPATIBLE = new DynamicCommandExceptionType(object -> Component.translatable((String)"commands.enchant.failed.incompatible", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(object -> Component.translatable((String)"commands.enchant.failed.itemless", (Object[])new Object[]{object}));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext arg) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"enchant").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"add").then(Commands.argument((String)"enchantment", (ArgumentType)ResourceArgument.resource((CommandBuildContext)arg, (ResourceKey)Registries.ENCHANTMENT)).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(context -> EnchantCommand.enchant((CommandContext<CommandSourceStack>)context, (Holder.Reference<Enchantment>)ResourceArgument.getEnchantment((CommandContext)context, (String)"enchantment"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"enchantment", (ArgumentType)ResourceArgument.resource((CommandBuildContext)arg, (ResourceKey)Registries.ENCHANTMENT)).executes(context -> EnchantCommand.removeEnchantment((CommandContext<CommandSourceStack>)context, (Holder.Reference<Enchantment>)ResourceArgument.getEnchantment((CommandContext)context, (String)"enchantment")))));
    }

    private static int enchant(CommandContext<CommandSourceStack> context, Holder.Reference<Enchantment> arg2, int level) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Enchantment enchantment = (Enchantment)arg2.value();
        ServerPlayer player = source.getPlayer();
        ItemStack mainHandItem = EnchantCommand.getItemInHand(player);
        if (mainHandItem == null) {
            throw ERROR_MISSING_PLAYER.create();
        }
        if (!enchantment.canEnchant(mainHandItem) || !EnchantmentHelper.isEnchantmentCompatible(EnchantmentHelper.getEnchantments((ItemStack)mainHandItem).keySet(), (Enchantment)enchantment)) {
            throw ERROR_INCOMPATIBLE.create((Object)mainHandItem.getItem().getName(mainHandItem).getString());
        }
        EnchantmentHacks.enchantItem(mainHandItem, enchantment, (short)level);
        source.sendSuccess(() -> Component.translatable((String)"commands.toolkit.enchant.success", (Object[])new Object[]{mainHandItem.getItem().getName(mainHandItem).getString(), enchantment.getFullname(level).getString()}), false);
        return 1;
    }

    private static int removeEnchantment(CommandContext<CommandSourceStack> context, Holder.Reference<Enchantment> arg2) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayer();
        ItemStack mainHandItem = EnchantCommand.getItemInHand(player);
        if (mainHandItem == null) {
            throw ERROR_MISSING_PLAYER.create();
        }
        Enchantment enchantment = (Enchantment)arg2.value();
        if (!EnchantmentHelper.getEnchantments((ItemStack)mainHandItem).containsKey(enchantment)) {
            throw ERROR_MISSING_ENCHANTMENT.create((Object)mainHandItem.getItem().getName(mainHandItem).getString(), (Object)enchantment.getFullname(1));
        }
        boolean success = EnchantmentHacks.removeEnchantment(mainHandItem, enchantment);
        if (success) {
            source.sendSuccess(() -> Component.translatable((String)"commands.toolkit.remove_enchant.success", (Object[])new Object[]{mainHandItem.getItem().getName(mainHandItem).getString(), enchantment.getFullname(1).getString()}), false);
        } else {
            source.sendFailure((Component)Component.translatable((String)"commands.toolkit.remove_enchant.failed", (Object[])new Object[]{mainHandItem.getItem().getName(mainHandItem).getString(), enchantment.getFullname(1).getString()}));
        }
        return success ? 1 : 0;
    }

    @Nullable
    public static ItemStack getItemInHand(@Nullable ServerPlayer player) throws CommandSyntaxException {
        if (player == null) {
            return null;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        if (mainHandItem.isEmpty()) {
            throw ERROR_NO_ITEM.create((Object)player.getName().getString());
        }
        return mainHandItem;
    }
}

