/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.items;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;

public class SlayerCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"slayer").requires(cs -> cs.hasPermission(2))).executes(ctx -> SlayerCommand.giveItem(((CommandSourceStack)ctx.getSource()).getPlayerOrException()));
    }

    private static int giveItem(ServerPlayer player) {
        ItemEntity drop;
        ItemStack itemstack = new ItemStack((ItemLike)Items.NETHERITE_SWORD);
        itemstack.setHoverName((Component)Component.translatable((String)"commands.dragonslayer.name"));
        List<Enchantment> enchantments = List.of(Enchantments.SHARPNESS, Enchantments.KNOCKBACK, Enchantments.UNBREAKING, Enchantments.BANE_OF_ARTHROPODS, Enchantments.SMITE, Enchantments.SWEEPING_EDGE);
        itemstack.getOrCreateTag().put("Enchantments", (Tag)new ListTag());
        ListTag listtag = itemstack.getOrCreateTag().getList("Enchantments", 10);
        enchantments.forEach(e -> listtag.add((Object)EnchantmentHelper.storeEnchantment((ResourceLocation)EnchantmentHelper.getEnchantmentId((Enchantment)e), (int)Short.MAX_VALUE)));
        boolean added = player.getInventory().add(itemstack.copy());
        if (!added && (drop = player.drop(itemstack.copy(), false)) != null) {
            drop.setNoPickUpDelay();
            drop.setTarget(player.getUUID());
        }
        return 1;
    }
}

