/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat;

import dev.architectury.hooks.client.screen.ScreenHooks;
import dev.architectury.platform.Platform;
import java.util.Locale;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.chat.ChatAuthImpl;
import net.creeperhost.minetogether.chat.ChatStatistics;
import net.creeperhost.minetogether.chat.ChatTarget;
import net.creeperhost.minetogether.chat.gui.FriendChatGui;
import net.creeperhost.minetogether.chat.gui.PublicChatGui;
import net.creeperhost.minetogether.chat.ingame.MTChatComponent;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.config.LocalConfig;
import net.creeperhost.minetogether.gui.SettingGui;
import net.creeperhost.minetogether.lib.chat.ChatState;
import net.creeperhost.minetogether.lib.chat.MutedUserList;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.irc.IrcClient;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.creeperhost.minetogether.polylib.gui.IconButton;
import net.creeperhost.minetogether.polylib.gui.SimpleToast;
import net.creeperhost.minetogether.util.ModPackInfo;
import net.creeperhost.polylib.client.modulargui.ModularGuiScreen;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MineTogetherChat {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ChatAuthImpl CHAT_AUTH = new ChatAuthImpl(Minecraft.getInstance());
    private static final MutedUserList MUTED_USER_LIST = new MutedUserList(Platform.getGameFolder().resolve("local/minetogether/mutedusers.json"));
    public static ChatState CHAT_STATE = new ChatState(MineTogether.API, CHAT_AUTH, MUTED_USER_LIST, () -> ModPackInfo.getInfo().realName, false);
    public static ChatComponent vanillaChat;
    public static MTChatComponent publicChat;
    public static MTChatComponent groupChat;
    private static boolean hasHitLoadingScreen;

    public static void init() {
        MineTogetherChat.CHAT_STATE.logChatToConsole = Config.instance().logChatToConsole | Config.instance().debugMode;
        if (Config.instance().debugMode) {
            System.setProperty("net.creeperhost.minetogether.repack.net.covers1624.pircbot.logging.info", "INFO");
            System.setProperty("net.creeperhost.minetogether.repack.net.covers1624.pircbot.logging.debug", "INFO");
            System.setProperty("net.creeperhost.minetogether.repack.net.covers1624.pircbot.logging.very_verbose", "true");
        }
        ChatStatistics.pollStats();
    }

    public static void initChat(Gui gui) {
        Minecraft mc = Minecraft.getInstance();
        vanillaChat = gui.chat;
        publicChat = new MTChatComponent(ChatTarget.PUBLIC, mc);
        groupChat = new MTChatComponent(ChatTarget.GROUP, mc);
        if (LocalConfig.instance().chatEnabled) {
            MineTogetherChat.CHAT_STATE.ircClient.start();
        }
        MineTogetherChat.CHAT_STATE.ircClient.addChannelListener(new IrcClient.ChannelListener(){

            @Override
            public void channelJoin(IrcChannel channel) {
                ProfileManager.PrivateGroup group;
                if (MineTogetherChat.CHAT_STATE.ircClient.getPrimaryChannel() == null) {
                    return;
                }
                if (channel == MineTogetherChat.CHAT_STATE.ircClient.getPrimaryChannel()) {
                    ModularGuiScreen mgui;
                    GuiProvider guiProvider;
                    publicChat.attach(channel);
                    Screen screen = Minecraft.getInstance().screen;
                    if (screen instanceof ModularGuiScreen && (guiProvider = (mgui = (ModularGuiScreen)screen).getModularGui().getProvider()) instanceof PublicChatGui) {
                        PublicChatGui chat = (PublicChatGui)guiProvider;
                        chat.chatMonitor.attach(channel);
                    }
                }
                if ((group = MineTogetherChat.CHAT_STATE.profileManager.getPrivateGroup()) != null && group.channelName.equals(channel.getName())) {
                    groupChat.attach(channel);
                }
            }

            @Override
            public void channelLeave(IrcChannel channel) {
            }
        });
        MineTogetherChat.CHAT_STATE.profileManager.addListener(mc, (m, e) -> m.submit(() -> {
            if (e.type == ProfileManager.EventType.FRIEND_REQUEST_ADDED) {
                ProfileManager.FriendRequest fr = (ProfileManager.FriendRequest)e.data;
                MineTogetherChat.addToast(new SimpleToast((Component)Component.translatable((String)"minetogether:toast.fiend_request_received", (Object[])new Object[]{MineTogetherChat.displayName(fr.user)}), (Component)Component.empty(), Constants.MINETOGETHER_LOGO_25));
            } else if (e.type == ProfileManager.EventType.FRIEND_REQUEST_ACCEPTED) {
                Profile fr = (Profile)e.data;
                MineTogetherChat.addToast(new SimpleToast((Component)Component.translatable((String)"minetogether:toast.fiend_request_accepted", (Object[])new Object[]{MineTogetherChat.displayName(fr)}), (Component)Component.empty(), Constants.MINETOGETHER_LOGO_25));
            } else if (e.type == ProfileManager.EventType.FRIEND_ONLINE && LocalConfig.instance().friendNotifications) {
                Profile fr = (Profile)e.data;
                MineTogetherChat.addToast(new SimpleToast((Component)Component.translatable((String)"minetogether:toast.user_online", (Object[])new Object[]{MineTogetherChat.displayName(fr)}), (Component)Component.empty(), Constants.MINETOGETHER_LOGO_25));
            } else if (e.type == ProfileManager.EventType.FRIEND_OFFLINE && LocalConfig.instance().friendNotifications) {
                Profile fr = (Profile)e.data;
                MineTogetherChat.addToast(new SimpleToast((Component)Component.translatable((String)"minetogether:toast.user_offline", (Object[])new Object[]{MineTogetherChat.displayName(fr)}), (Component)Component.empty(), Constants.MINETOGETHER_LOGO_25));
            } else if (e.type == ProfileManager.EventType.GROUP_INVITE_RECEIVED) {
                ProfileManager.PrivateGroup group = (ProfileManager.PrivateGroup)e.data;
                if (group != null && group.ownerHash != null) {
                    Profile sender = MineTogetherChat.CHAT_STATE.profileManager.lookupProfile(group.ownerHash);
                    MineTogetherChat.addToast(new SimpleToast((Component)Component.translatable((String)"minetogether:toast.group_invite_received", (Object[])new Object[]{MineTogetherChat.displayName(sender)}), (Component)Component.empty(), Constants.MINETOGETHER_LOGO_25));
                }
            } else if (e.type == ProfileManager.EventType.LEFT_GROUP) {
                if (MineTogetherChat.getTarget() == ChatTarget.GROUP) {
                    MineTogetherChat.setTarget(ChatTarget.VANILLA);
                }
                MineTogetherChat.addToast(new SimpleToast((Component)Component.translatable((String)"minetogether:toast.left_group"), (Component)Component.translatable((String)("minetogether:toast.left_group." + e.data)), Constants.MINETOGETHER_LOGO_25));
            }
        }));
        String lowerHash = CHAT_AUTH.getHash().toLowerCase(Locale.ROOT);
        if (!LocalConfig.instance().firstConnect.contains(lowerHash) && MineTogetherChat.CHAT_STATE.profileManager.getOwnProfile().hasAccount()) {
            LocalConfig.instance().firstConnect.add(lowerHash);
            LocalConfig.save();
        }
    }

    public static void simpleToast(Component toastText) {
        MineTogetherChat.addToast(new SimpleToast(toastText, (Component)Component.empty(), Constants.MINETOGETHER_LOGO_25));
    }

    public static void simpleToast(Component toastTitle, Component toastText) {
        MineTogetherChat.addToast(new SimpleToast(toastTitle, toastText, Constants.MINETOGETHER_LOGO_25));
    }

    private static void addToast(Toast toast) {
        if (hasHitLoadingScreen) {
            Minecraft.getInstance().getToasts().addToast(toast);
        }
    }

    public static Profile getOurProfile() {
        return MineTogetherChat.CHAT_STATE.profileManager.getOwnProfile();
    }

    public static void onScreenPostInit(Screen screen) {
        if (screen instanceof TitleScreen) {
            if (!hasHitLoadingScreen) {
                hasHitLoadingScreen = true;
            }
            if (LocalConfig.instance().mainMenuButtons) {
                MineTogetherChat.addMenuButtons(screen);
            }
        } else if (screen instanceof PauseScreen && Config.instance().pauseScreenButtons) {
            MineTogetherChat.addMenuButtons(screen);
        }
    }

    private static void addMenuButtons(Screen screen) {
        int buttonPos = 4;
        IconButton settings = new IconButton(screen.width - (buttonPos += 21), 5, 3, Constants.WIDGETS_SHEET, e -> Minecraft.getInstance().setScreen((Screen)new SettingGui.Screen(screen)));
        settings.setTooltip(Tooltip.create((Component)Component.translatable((String)"minetogether:gui.button.settings.info")));
        ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)settings);
        IconButton friendChat = new IconButton(screen.width - (buttonPos += 21), 5, 7, Constants.WIDGETS_SHEET, e -> Minecraft.getInstance().setScreen((Screen)new FriendChatGui.Screen(screen)));
        friendChat.setTooltip(Tooltip.create((Component)Component.translatable((String)"minetogether:gui.button.friends.info")));
        ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)friendChat);
        if (LocalConfig.instance().chatEnabled) {
            IconButton publicChat = new IconButton(screen.width - (buttonPos += 21), 5, 1, Constants.WIDGETS_SHEET, e -> Minecraft.getInstance().setScreen((Screen)new PublicChatGui.Screen(screen)));
            publicChat.setTooltip(Tooltip.create((Component)Component.translatable((String)"minetogether:gui.button.global_chat.info")));
            ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)publicChat);
        }
    }

    public static boolean isNewUser() {
        if (MineTogetherChat.getOurProfile().hasAccount()) {
            return false;
        }
        return !LocalConfig.instance().firstConnect.contains(CHAT_AUTH.getHash().toLowerCase(Locale.ROOT));
    }

    public static void setNewUserResponded() {
        LocalConfig.instance().firstConnect.add(CHAT_AUTH.getHash().toLowerCase(Locale.ROOT));
        LocalConfig.save();
    }

    public static void disableChat() {
        MineTogetherChat.CHAT_STATE.ircClient.stop();
    }

    public static void enableChat() {
        MineTogetherChat.CHAT_STATE.ircClient.start();
    }

    public static void setTarget(ChatTarget target) {
        LocalConfig.instance().selectedTab = target;
        LocalConfig.save();
    }

    public static ChatTarget getTarget() {
        return LocalConfig.instance().chatEnabled ? LocalConfig.instance().selectedTab : ChatTarget.VANILLA;
    }

    public static String displayName(@Nullable Profile profile) {
        return profile == null ? "" : (profile.isFriend() && profile.hasFriendName() ? profile.getFriendName() : profile.getDisplayName());
    }

    static {
        hasHitLoadingScreen = false;
    }
}

