/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.message.Message;
import org.jetbrains.annotations.Nullable;

public class ChatMonitor {
    @Nullable
    private IrcChannel channel;
    @Nullable
    private IrcChannel.ChatListener listener;
    private final List<Message> pendingMessages = new LinkedList<Message>();
    private final List<Message> messages = new LinkedList<Message>();
    @Nullable
    private Consumer<List<Message>> onMessagesUpdated;

    public void onMessagesUpdated(Consumer<List<Message>> onMessagesUpdated) {
        this.onMessagesUpdated = onMessagesUpdated;
    }

    public void attach(@Nullable IrcChannel channel) {
        if (this.channel == channel) {
            return;
        }
        if (this.channel != null) {
            assert (this.listener != null);
            this.channel.removeListener(this.listener);
            this.listener = null;
        }
        this.pendingMessages.clear();
        this.messages.clear();
        if (this.onMessagesUpdated != null) {
            this.onMessagesUpdated.accept(this.messages);
        }
        this.channel = channel;
        if (channel != null) {
            this.pendingMessages.addAll(channel.getMessages());
            this.listener = channel.addListener(e -> {
                List<Message> list = this.pendingMessages;
                synchronized (list) {
                    this.pendingMessages.add(e);
                }
            });
        }
    }

    @Nullable
    public IrcChannel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (!this.pendingMessages.isEmpty()) {
            List<Message> list = this.pendingMessages;
            synchronized (list) {
                this.messages.addAll(this.pendingMessages);
                this.pendingMessages.clear();
            }
            if (this.onMessagesUpdated != null) {
                this.onMessagesUpdated.accept(this.messages);
            }
        }
    }

    public void onGuiClose() {
        if (this.channel != null) {
            assert (this.listener != null);
            this.channel.removeListener(this.listener);
        }
    }
}

