/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import net.creeperhost.minetogether.chat.FriendChatNotifier;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.FriendChatGui;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.chat.gui.PlayerIconElement;
import net.creeperhost.minetogether.gui.dialogs.ContextMenu;
import net.creeperhost.minetogether.gui.dialogs.TextInputDialog;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.creeperhost.minetogether.util.ProfileUpdater;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiDialog;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FriendElement
extends GuiElement<FriendElement>
implements BackgroundRender {
    @Nullable
    private final ProfileManager.FriendRequest request;
    @Nullable
    private final Profile profile;
    @Nullable
    private GameProfile iconProfile = null;
    private PlayerIconElement icon;
    @Nullable
    private Component divider = null;

    public FriendElement(@NotNull GuiParent<?> parent, @Nullable Profile profile) {
        this(parent, (ProfileManager.FriendRequest)null, profile);
    }

    public FriendElement(@NotNull GuiParent<?> parent, ProfileManager.FriendRequest request) {
        this(parent, request, request.user);
    }

    public FriendElement(@NotNull GuiParent<?> parent, @Nullable ProfileManager.FriendRequest request, @Nullable Profile profile) {
        super(parent);
        this.request = request;
        this.profile = profile;
        this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)(profile == null ? 12.0 : 32.0)));
        if (profile == null) {
            return;
        }
        this.icon = (PlayerIconElement)((PlayerIconElement)((PlayerIconElement)((PlayerIconElement)new PlayerIconElement((GuiParent<?>)this, null).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)28.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)28.0));
        this.icon.setTooltip(() -> {
            if (!profile.isOnline()) {
                return Collections.singletonList(Component.translatable((String)"minetogether:gui.friends.icon.offline"));
            }
            if (!profile.hasFriendUUID()) {
                return Collections.singletonList(Component.translatable((String)"minetogether:gui.friends.icon.no_uuid"));
            }
            if (this.icon.textureFail) {
                return Collections.singletonList(Component.translatable((String)"minetogether:gui.friends.icon.fail"));
            }
            return Collections.emptyList();
        }, 0);
        GuiText name = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)Component.empty()).setTextSupplier(() -> Component.literal((String)FriendChatGui.displayName(profile))).setShadow(false).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)5.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.icon.get(GeoParam.RIGHT), (double)3.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0));
        if (request == null) {
            GuiText status = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)Component.empty()).setShadow(false).setTextSupplier(() -> profile.isOnline() ? Component.translatable((String)"minetogether:gui.friends.online").withStyle(ChatFormatting.DARK_GREEN) : Component.translatable((String)"minetogether:gui.friends.offline")).setAlignment(Align.LEFT).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.BOTTOM), (double)-5.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.icon.get(GeoParam.RIGHT), (double)3.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0));
            GuiRectangle unreadBg = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle((GuiParent)this).setEnabled(() -> FriendChatNotifier.getUnreadMessageCount(profile) > 0)).fill(-65536).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)this.icon.get(GeoParam.BOTTOM), (double)-1.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.icon.get(GeoParam.RIGHT), (double)-1.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)10.0));
            GuiText unread = (GuiText)((GuiText)new GuiText((GuiParent)unreadBg, () -> Component.literal((String)String.valueOf(FriendChatNotifier.getUnreadMessageCount(profile)))).setScroll(false).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)20.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
            unreadBg.constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> (double)this.font().width((FormattedText)unread.getText()) + 2.0));
            Constraints.center((ConstrainedGeometry)unread, (ConstrainedGeometry)unreadBg);
        } else {
            GuiButton accept = (GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.buttonPrimary(this, (Component)Component.translatable((String)"minetogether:gui.friends.button.accept")).onPress(() -> {
                ProfileManager profileManager = MineTogetherChat.CHAT_STATE.profileManager;
                new TextInputDialog((GuiParent<?>)this.getModularGui().getRoot(), (Component)Component.translatable((String)"minetogether:screen.friendreq.desc.request"), FriendChatGui.displayName(profile)).setResultCallback(friendName -> profileManager.acceptFriendRequest(request, friendName.trim()));
            }).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.BOTTOM), (double)-2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)34.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
            GuiButton reject = (GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.buttonCaution(this, (Component)Component.translatable((String)"minetogether:gui.friends.button.reject")).onPress(() -> MineTogetherChat.CHAT_STATE.profileManager.denyFriendRequest(request)).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.BOTTOM), (double)-2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-2.0));
            accept.constrain(GeoParam.RIGHT, (Constraint)Constraint.midPoint((GeoRef)accept.get(GeoParam.LEFT), (GeoRef)reject.get(GeoParam.RIGHT), (double)-0.5));
            reject.constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)accept.get(GeoParam.LEFT), (GeoRef)reject.get(GeoParam.RIGHT), (double)0.5));
        }
    }

    public FriendElement(@NotNull GuiParent<?> parent, ProfileManager.PrivateGroup invite, Profile sender) {
        super(parent);
        this.profile = sender;
        this.request = null;
        this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)32.0));
        this.icon = (PlayerIconElement)((PlayerIconElement)((PlayerIconElement)((PlayerIconElement)new PlayerIconElement((GuiParent<?>)this, null).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)28.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)28.0));
        this.icon.setTooltip(() -> {
            if (!sender.isOnline()) {
                return Collections.singletonList(Component.translatable((String)"minetogether:gui.friends.icon.offline"));
            }
            if (!sender.hasFriendUUID()) {
                return Collections.singletonList(Component.translatable((String)"minetogether:gui.friends.icon.no_uuid"));
            }
            if (this.icon.textureFail) {
                return Collections.singletonList(Component.translatable((String)"minetogether:gui.friends.icon.fail"));
            }
            return Collections.emptyList();
        }, 0);
        GuiText name = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)Component.empty()).setTextSupplier(() -> Component.literal((String)FriendChatGui.displayName(sender))).setShadow(false).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)5.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.icon.get(GeoParam.RIGHT), (double)3.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0));
        GuiButton accept = (GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.buttonPrimary(this, (Component)Component.translatable((String)"minetogether:gui.friends.button.accept")).onPress(() -> {
            ProfileManager profileManager = MineTogetherChat.CHAT_STATE.profileManager;
            ProfileManager.PrivateGroup current = profileManager.getPrivateGroup();
            if (current == null) {
                profileManager.acceptGroupInvite(invite);
                FriendChatGui.selectGroupChat();
            } else {
                GuiDialog.optionsDialog((GuiParent)this.getModularGui().getRoot(), (Component)Component.translatable((String)(current.ownerHash == null ? "minetogether:gui.friends.group.confirm_leave_own" : "minetogether:gui.friends.group.confirm_leave")), (int)250, (GuiDialog.Option[])new GuiDialog.Option[]{GuiDialog.primary((Component)Component.translatable((String)"gui.yes"), () -> {
                    profileManager.acceptGroupInvite(invite);
                    FriendChatGui.selectGroupChat();
                }), GuiDialog.neutral((Component)Component.translatable((String)"gui.cancel"), () -> {})});
            }
        }).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.BOTTOM), (double)-2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)34.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton reject = (GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.buttonCaution(this, (Component)Component.translatable((String)"minetogether:gui.friends.button.reject")).onPress(() -> MineTogetherChat.CHAT_STATE.profileManager.rejectGroupInvite(invite)).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.BOTTOM), (double)-2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-2.0));
        accept.constrain(GeoParam.RIGHT, (Constraint)Constraint.midPoint((GeoRef)accept.get(GeoParam.LEFT), (GeoRef)reject.get(GeoParam.RIGHT), (double)-0.5));
        reject.constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)accept.get(GeoParam.LEFT), (GeoRef)reject.get(GeoParam.RIGHT), (double)0.5));
    }

    public FriendElement setDivider(@Nullable Component divider) {
        this.divider = divider;
        return this;
    }

    public void tick(double mouseX, double mouseY) {
        super.tick(mouseX, mouseY);
        if (this.profile != null && this.profile.hasFriendUUID() && this.iconProfile == null) {
            this.iconProfile = new GameProfile(this.profile.getFriendUUID(), "");
            ProfileUpdater.updateProfile(this.profile.getFriendUUID(), e -> {
                this.iconProfile = e;
                this.icon.setProfile((GameProfile)e);
            });
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.profile == null || !this.isMouseOver()) {
            return false;
        }
        if (button == 0) {
            if (this.request == null) {
                if (FriendChatGui.getSelected() == this.profile) {
                    this.showOptions(mouseX, mouseY);
                } else {
                    FriendChatGui.setSelected(this.profile);
                    FriendChatNotifier.setActiveChat(this.profile);
                    this.mc().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                }
                return true;
            }
        } else if (button == 1) {
            this.showOptions(mouseX, mouseY);
            return true;
        }
        return false;
    }

    private void showOptions(double mouseX, double mouseY) {
        if (this.profile == null) {
            return;
        }
        ContextMenu menu = new ContextMenu((GuiParent<?>)this.getModularGui().getRoot());
        menu.addTitle((Component)Component.literal((String)FriendChatGui.displayName(this.profile)).withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD}));
        if (this.request == null) {
            menu.addOption((Component)Component.translatable((String)"minetogether:gui.friends.button.invite").withStyle(ChatFormatting.GREEN), () -> {
                ProfileManager profileManager = MineTogetherChat.CHAT_STATE.profileManager;
                ProfileManager.PrivateGroup group = profileManager.getPrivateGroup();
                if (group != null && group.ownerHash != null) {
                    GuiDialog.optionsDialog((GuiParent)this.getModularGui().getRoot(), (Component)Component.translatable((String)"minetogether:gui.friends.group.confirm_leave"), (int)250, (GuiDialog.Option[])new GuiDialog.Option[]{GuiDialog.primary((Component)Component.translatable((String)"gui.yes"), () -> {
                        FriendChatGui.selectGroupChat();
                        MineTogetherChat.CHAT_STATE.profileManager.sendGroupInvite(this.profile);
                    }), GuiDialog.neutral((Component)Component.translatable((String)"gui.cancel"), () -> {})});
                } else {
                    FriendChatGui.selectGroupChat();
                    MineTogetherChat.CHAT_STATE.profileManager.sendGroupInvite(this.profile);
                }
            });
            menu.addOption((Component)Component.translatable((String)"minetogether:gui.friends.button.rename").withStyle(ChatFormatting.AQUA), () -> {
                ProfileManager profileManager = MineTogetherChat.CHAT_STATE.profileManager;
                new TextInputDialog((GuiParent<?>)this.getModularGui().getRoot(), (Component)Component.translatable((String)"minetogether:screen.friendreq.desc.request"), FriendChatGui.displayName(this.profile)).setResultCallback(friendName -> profileManager.updateFriendName(this.profile, friendName.trim(), success -> MineTogetherChat.simpleToast((Component)Component.translatable((String)(success != false ? "minetogether:gui.friends.update_friend" : "minetogether:gui.friends.update_fail")))));
            });
            menu.addOption((Component)Component.translatable((String)"minetogether:gui.friends.button.remove").withStyle(ChatFormatting.YELLOW), () -> {
                MineTogetherChat.CHAT_STATE.profileManager.removeFriend(this.profile);
                FriendChatGui.setSelected(null);
            });
        }
        menu.addOption((Component)Component.translatable((String)"minetogether:gui.friends.button.block").withStyle(ChatFormatting.RED), () -> {
            this.profile.mute();
            FriendChatGui.setSelected(null);
        });
        menu.setPosition(mouseX, mouseY);
    }

    public double getBackgroundDepth() {
        return super.getBackgroundDepth();
    }

    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        if (this.divider != null) {
            render.drawCenteredString(this.divider, this.xCenter(), this.yMin() + 2.0, 0xFFFFFF, false);
            return;
        }
        render.rect(this.getRectangle(), MTStyle.Flat.listEntryBackground(this.isMouseOver() && this.request == null || FriendChatGui.getSelected() == this.profile));
    }
}

