/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.irc.IrcState;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FriendRequestScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Screen previous;
    @Nullable
    private final ProfileManager.FriendRequest request;
    private final Profile target;
    private final Type type;
    private Button cancelButton;
    private Button acceptButton;
    private EditBox nameBox;

    public FriendRequestScreen(Screen previous, ProfileManager.FriendRequest request) {
        this(previous, request, request.user, Type.ACCEPT);
    }

    public FriendRequestScreen(Screen previous, Profile target, Type type) {
        this(previous, null, target, type);
    }

    private FriendRequestScreen(Screen previous, @Nullable ProfileManager.FriendRequest request, Profile target, Type type) {
        super(type.title);
        this.previous = previous;
        this.request = request;
        this.target = target;
        this.type = type;
        assert (type != Type.ACCEPT || request != null);
    }

    protected void init() {
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"minetogether:button.cancel"), e -> this.minecraft.setScreen(this.previous)).bounds(this.width / 2 - 180, this.height - 50, 80, 20).build());
        this.acceptButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.type.button, this::onAccept).bounds(this.width / 2 + 100, this.height - 50, 80, 20).build());
        String boxString = this.nameBox != null ? this.nameBox.getValue() : (this.target.isFriend() ? this.target.getFriendName() : this.target.getDisplayName());
        this.nameBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.minecraft.font, this.width / 2 - 100, this.height / 2 - 10, 200, 20, (Component)Component.empty()));
        this.nameBox.setValue(boxString);
        this.acceptButton.active = this.nameBox.getValue().trim().length() >= 3;
        this.nameBox.setFocused(true);
        this.nameBox.setCanLoseFocus(false);
    }

    public boolean charTyped(char c, int i) {
        boolean ret = super.charTyped(c, i);
        if (this.nameBox.isFocused()) {
            this.acceptButton.active = this.nameBox.getValue().trim().length() >= 3;
        }
        return ret;
    }

    public boolean keyPressed(int i, int j, int k) {
        boolean ret = super.keyPressed(i, j, k);
        if (this.nameBox.isFocused()) {
            this.acceptButton.active = this.nameBox.getValue().trim().length() >= 3;
        }
        return ret;
    }

    public void render(GuiGraphics graphics, int i, int j, float f) {
        this.renderDirtBackground(graphics);
        super.render(graphics, i, j, f);
        graphics.drawCenteredString(this.minecraft.font, this.type.title, this.width / 2, 5, -1);
        graphics.drawCenteredString(this.minecraft.font, this.type.desc, this.width / 2, this.height / 2 - 30, -1);
    }

    private void onAccept(Button b) {
        if (MineTogetherChat.CHAT_STATE.ircClient.getState() == IrcState.CONNECTED) {
            ProfileManager profileManager = MineTogetherChat.CHAT_STATE.profileManager;
            if (this.type == Type.REQUEST) {
                if (this.target.hasFriendCode()) {
                    profileManager.sendFriendRequest(this.target.getFriendCode(), this.nameBox.getValue().trim(), success -> MineTogetherChat.simpleToast((Component)Component.translatable((String)(success != false ? "minetogether:gui.friends.request_sent" : "minetogether:gui.friends.request_fail"))));
                } else {
                    MineTogetherChat.simpleToast((Component)Component.literal((String)"Error, Profile Incomplete").withStyle(ChatFormatting.RED));
                }
            } else if (this.type == Type.ACCEPT) {
                assert (this.request != null);
                profileManager.acceptFriendRequest(this.request, this.nameBox.getValue().trim());
            } else {
                assert (this.type == Type.UPDATE);
                LOGGER.fatal("Not currently implemented!");
            }
        } else {
            LOGGER.warn("IRC not connected. Did nothing.");
        }
        Minecraft.getInstance().setScreen(this.previous);
    }

    public static enum Type {
        REQUEST((Component)Component.translatable((String)"minetogether:screen.friendreq.title.request"), (Component)Component.translatable((String)"minetogether:screen.friendreq.button.request"), (Component)Component.translatable((String)"minetogether:screen.friendreq.desc.request")),
        ACCEPT((Component)Component.translatable((String)"minetogether:screen.friendreq.title.accept"), (Component)Component.translatable((String)"minetogether:screen.friendreq.button.accept"), (Component)Component.translatable((String)"minetogether:screen.friendreq.desc.accept")),
        UPDATE((Component)Component.translatable((String)"minetogether:screen.friendreq.title.update"), (Component)Component.translatable((String)"minetogether:screen.friendreq.button.update"), (Component)Component.translatable((String)"minetogether:screen.friendreq.desc.update"));

        private final Component title;
        private final Component button;
        private final Component desc;

        private Type(Component title, Component button, Component desc) {
            this.title = title;
            this.button = button;
            this.desc = desc;
        }
    }
}

