/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.concurrent.Executor;
import net.creeperhost.minetogether.gui.MTTextures;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class PlayerIconElement
extends GuiElement<PlayerIconElement>
implements BackgroundRender {
    @Nullable
    private RenderType skinType;
    public boolean textureFail = false;
    @Nullable
    private GameProfile profile;
    private Material fallback = MTTextures.get("player_offline");

    public PlayerIconElement(@NotNull GuiParent<?> parent, @Nullable GameProfile profile) {
        super(parent);
        this.profile = profile;
    }

    public void setProfile(GameProfile profile) {
        this.profile = profile;
        this.skinType = null;
        this.textureFail = false;
    }

    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        if (this.skinType == null && this.profile != null && !this.textureFail) {
            this.updateGameProfile();
        }
        if (this.skinType != null) {
            this.draw(render);
        } else {
            render.texRect(this.fallback, this.getRectangle());
        }
    }

    public void draw(GuiRender render) {
        float texMin = 0.125f;
        float texMax = 0.25f;
        VertexConsumer buffer = render.buffers().getBuffer(this.skinType);
        Matrix4f mat = render.pose().last().pose();
        buffer.vertex(mat, (float)this.xMax(), (float)this.yMax(), 0.0f).uv(texMax, texMax).endVertex();
        buffer.vertex(mat, (float)this.xMax(), (float)this.yMin(), 0.0f).uv(texMax, texMin).endVertex();
        buffer.vertex(mat, (float)this.xMin(), (float)this.yMin(), 0.0f).uv(texMin, texMin).endVertex();
        buffer.vertex(mat, (float)this.xMin(), (float)this.yMax(), 0.0f).uv(texMin, texMax).endVertex();
        render.flush();
    }

    private void updateGameProfile() {
        if (this.profile == null) {
            return;
        }
        if (!this.profile.getProperties().containsKey((Object)"textures")) {
            this.mc().getMinecraftSessionService().fetchProfile(this.profile.getId(), true);
        }
        this.mc().getSkinManager().getOrLoad(this.profile).thenAcceptAsync(e -> {
            if (!e.texture().equals((Object)DefaultPlayerSkin.getDefaultTexture())) {
                this.skinType = GuiRender.texType((ResourceLocation)e.texture());
            } else {
                this.textureFail = true;
            }
        }, (Executor)Minecraft.getInstance());
    }
}

