/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.ingame;

import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.creeperhost.minetogether.chat.ChatTarget;
import net.creeperhost.minetogether.chat.DisplayableMessage;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.lib.chat.message.MessageComponent;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.FastStream;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MTChatComponent
extends ChatComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_MESSAGE_HISTORY = 150;
    private final ChatTarget target;
    private final Minecraft minecraft;
    private boolean internalUpdate = false;
    private final List<InGameDisplayableMessage> changedMessages = new LinkedList<InGameDisplayableMessage>();
    private final LinkedList<Message> pendingMessages = new LinkedList();
    private final List<InGameDisplayableMessage> processedMessages = new ArrayList<InGameDisplayableMessage>();
    @Nullable
    private IrcChannel channel;
    @Nullable
    private Message clickedMessage;

    public MTChatComponent(ChatTarget target, Minecraft minecraft) {
        super(minecraft);
        this.target = target;
        this.minecraft = minecraft;
        assert (target != ChatTarget.VANILLA) : "MTChatComponent doesn't work this way";
    }

    public void attach(IrcChannel channel) {
        if (this.channel != null) {
            return;
        }
        this.channel = channel;
        channel.addListener(message -> {
            LinkedList<Message> linkedList = this.pendingMessages;
            synchronized (linkedList) {
                this.pendingMessages.add(message);
            }
        });
    }

    public void tick() {
        IrcChannel channel;
        super.tick();
        if (this.channel == null && this.target == ChatTarget.PUBLIC && (channel = MineTogetherChat.CHAT_STATE.ircClient.getPrimaryChannel()) != null) {
            this.attach(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GuiGraphics graphics, int i, int j, int k) {
        List<Object> list;
        if (!this.pendingMessages.isEmpty()) {
            this.internalUpdate = true;
            list = this.pendingMessages;
            synchronized (list) {
                for (Message pendingMessage : this.pendingMessages) {
                    this.addMessage(pendingMessage);
                }
                this.pendingMessages.clear();
            }
            this.internalUpdate = false;
        }
        if (!this.changedMessages.isEmpty()) {
            list = this.changedMessages;
            synchronized (list) {
                for (InGameDisplayableMessage changedMessage : this.changedMessages) {
                    changedMessage.reformat();
                }
                this.changedMessages.clear();
            }
        }
        super.render(graphics, i, j, k);
    }

    public void rescaleChat() {
        if (MineTogetherChat.getTarget() == this.target) {
            MineTogetherChat.vanillaChat.rescaleChat();
        }
        this.trimmedMessages.clear();
        this.resetChatScroll();
        for (InGameDisplayableMessage message : this.processedMessages) {
            message.format();
            message.display();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMessages(boolean bl) {
        if (MineTogetherChat.getTarget() == this.target) {
            MineTogetherChat.vanillaChat.clearMessages(bl);
        }
        LinkedList<Message> linkedList = this.pendingMessages;
        synchronized (linkedList) {
            this.pendingMessages.clear();
        }
        for (InGameDisplayableMessage message : this.processedMessages) {
            message.onDead();
        }
        this.processedMessages.clear();
        this.trimmedMessages.clear();
    }

    public void addRecentChat(String string) {
        if (this.channel == null) {
            LOGGER.error("Can't send message, chat is not bound!");
            return;
        }
        this.channel.sendMessage(string);
    }

    private void addMessage(Message message) {
        InGameDisplayableMessage newMessage = new InGameDisplayableMessage(message);
        this.processedMessages.add(newMessage);
        newMessage.display();
        if (this.isChatFocused() && this.chatScrollbarPos > 0) {
            this.newMessageSinceScroll = true;
            this.scrollChat(1);
        }
        while (this.processedMessages.size() > 150) {
            InGameDisplayableMessage toRemove = this.processedMessages.remove(0);
            this.trimmedMessages.removeAll(toRemove.getTrimmedLines());
            toRemove.onDead();
        }
    }

    public void localMessage(@Nullable Component message, MessageSignature signature) {
        LocalMessage oldMessage = FastStream.of(this.processedMessages).filter(e -> {
            if (!(e instanceof LocalMessage)) return false;
            LocalMessage msg = (LocalMessage)e;
            if (!msg.signature.equals((Object)signature)) return false;
            return true;
        }).map(e -> (LocalMessage)e).findFirst().orElse(null);
        if (oldMessage != null) {
            this.processedMessages.remove(oldMessage);
            if (oldMessage.line != null) {
                this.trimmedMessages.remove(oldMessage.line);
            }
        }
        if (message == null) {
            return;
        }
        LocalMessage newMessage = new LocalMessage(message, signature);
        this.processedMessages.add(newMessage);
        newMessage.display();
        if (this.isChatFocused() && this.chatScrollbarPos > 0) {
            this.newMessageSinceScroll = true;
            this.scrollChat(1);
        }
        while (this.processedMessages.size() > 150) {
            InGameDisplayableMessage toRemove = this.processedMessages.remove(0);
            this.trimmedMessages.removeAll(toRemove.getTrimmedLines());
            toRemove.onDead();
        }
    }

    public void addMessage(Component component) {
        assert (!this.internalUpdate);
        MineTogetherChat.vanillaChat.addMessage(component);
    }

    public void addMessage(Component component, @Nullable MessageSignature messageSignature, @Nullable GuiMessageTag guiMessageTag) {
        assert (!this.internalUpdate);
        MineTogetherChat.vanillaChat.addMessage(component, messageSignature, guiMessageTag);
    }

    public void addMessage(Component component, @Nullable MessageSignature messageSignature, int i, @Nullable GuiMessageTag guiMessageTag, boolean bl) {
        assert (!this.internalUpdate);
        MineTogetherChat.vanillaChat.addMessage(component, messageSignature, i, guiMessageTag, bl);
    }

    public void deleteMessage(MessageSignature messageSignature) {
        assert (!this.internalUpdate);
        MineTogetherChat.vanillaChat.deleteMessage(messageSignature);
    }

    public boolean handleClick(double mouseX, double mouseY) {
        if (!this.isChatFocused()) {
            return false;
        }
        double x = mouseX - 2.0;
        double y = (double)this.minecraft.getWindow().getGuiScaledHeight() - mouseY - 40.0;
        x = Mth.floor((double)(x / this.getScale()));
        y = Mth.floor((double)(y / (this.getScale() * ((Double)this.minecraft.options.chatLineSpacing().get() + 1.0))));
        if (x < 0.0 || y < 0.0) {
            return false;
        }
        int i = Math.min(this.getLinesPerPage(), this.trimmedMessages.size());
        if (x <= (double)Mth.floor((double)((double)this.getWidth() / this.getScale()))) {
            Objects.requireNonNull(this.minecraft.font);
            if (y < (double)(9 * i + i)) {
                Objects.requireNonNull(this.minecraft.font);
                int j = (int)(y / 9.0 + (double)this.chatScrollbarPos);
                if (j >= 0 && j < this.trimmedMessages.size()) {
                    return this.handleClickedMessage(this.findMessageForTrimmedMessage((GuiMessage.Line)this.trimmedMessages.get(j)), x);
                }
            }
        }
        return false;
    }

    @Nullable
    public Style getStyleUnderMouse(double mouseX, double mouseY) {
        if (!this.isChatFocused()) {
            return null;
        }
        double x = mouseX - 2.0;
        double y = (double)this.minecraft.getWindow().getGuiScaledHeight() - mouseY - 40.0;
        x = Mth.floor((double)(x / this.getScale()));
        y = Mth.floor((double)(y / (this.getScale() * ((Double)this.minecraft.options.chatLineSpacing().get() + 1.0))));
        if (x < 0.0 || y < 0.0) {
            return null;
        }
        int i = Math.min(this.getLinesPerPage(), this.trimmedMessages.size());
        if (x <= (double)Mth.floor((double)((double)this.getWidth() / this.getScale()))) {
            Objects.requireNonNull(this.minecraft.font);
            if (y < (double)(9 * i + i)) {
                Objects.requireNonNull(this.minecraft.font);
                int j = (int)(y / 9.0 + (double)this.chatScrollbarPos);
                if (j >= 0 && j < this.trimmedMessages.size()) {
                    InGameDisplayableMessage message = this.findMessageForTrimmedMessage((GuiMessage.Line)this.trimmedMessages.get(j));
                    if (message == null) {
                        return null;
                    }
                    return this.minecraft.font.getSplitter().componentStyleAtWidth((FormattedText)message.getBuiltMessage(), (int)x);
                }
            }
        }
        return null;
    }

    @Nullable
    public Message getMessageUnderMouse(double mouseX, double mouseY) {
        if (!this.isChatFocused()) {
            return null;
        }
        double x = mouseX - 2.0;
        double y = (double)this.minecraft.getWindow().getGuiScaledHeight() - mouseY - 40.0;
        x = Mth.floor((double)(x / this.getScale()));
        y = Mth.floor((double)(y / (this.getScale() * ((Double)this.minecraft.options.chatLineSpacing().get() + 1.0))));
        if (x < 0.0 || y < 0.0) {
            return null;
        }
        int i = Math.min(this.getLinesPerPage(), this.trimmedMessages.size());
        if (x <= (double)Mth.floor((double)((double)this.getWidth() / this.getScale()))) {
            Objects.requireNonNull(this.minecraft.font);
            if (y < (double)(9 * i + i)) {
                Objects.requireNonNull(this.minecraft.font);
                int j = (int)(y / 9.0 + (double)this.chatScrollbarPos);
                if (j >= 0 && j < this.trimmedMessages.size()) {
                    InGameDisplayableMessage message = this.findMessageForTrimmedMessage((GuiMessage.Line)this.trimmedMessages.get(j));
                    return message == null ? null : message.getMessage();
                }
            }
        }
        return null;
    }

    private boolean handleClickedMessage(@Nullable InGameDisplayableMessage clickedMessage, double x) {
        if (clickedMessage == null) {
            return false;
        }
        Message message = clickedMessage.getMessage();
        if (message.sender == null) {
            return false;
        }
        if (message.sender == MineTogetherChat.getOurProfile()) {
            return false;
        }
        Style style = this.minecraft.font.getSplitter().componentStyleAtWidth((FormattedText)clickedMessage.getBuiltMessage(), (int)x);
        if (style == null) {
            return false;
        }
        ClickEvent event = style.getClickEvent();
        if (event == null) {
            return false;
        }
        if (!event.getValue().equals("CE:CLICK_NAME")) {
            return false;
        }
        this.clickedMessage = message;
        return true;
    }

    @Nullable
    private InGameDisplayableMessage findMessageForTrimmedMessage(GuiMessage.Line trimmedMessage) {
        for (InGameDisplayableMessage processedMessage : this.processedMessages) {
            if (!processedMessage.getTrimmedLines().contains(trimmedMessage)) continue;
            return processedMessage;
        }
        return null;
    }

    @Nullable
    public Message getClickedMessage() {
        return this.clickedMessage;
    }

    public void clearClickedMessage() {
        this.clickedMessage = null;
    }

    private class InGameDisplayableMessage
    extends DisplayableMessage<GuiMessage.Line> {
        private InGameDisplayableMessage(Message message) {
            super(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onModified() {
            List<InGameDisplayableMessage> list = MTChatComponent.this.changedMessages;
            synchronized (list) {
                MTChatComponent.this.changedMessages.add(this);
            }
        }

        @Override
        protected boolean isForward() {
            return false;
        }

        @Override
        protected GuiMessage.Line createMessage(int addTime, FormattedCharSequence message) {
            return new GuiMessage.Line(addTime, message, null, true);
        }

        @Override
        protected int getMessageIndex(GuiMessage.Line message) {
            return MTChatComponent.this.trimmedMessages.indexOf(message);
        }

        @Override
        protected void clearMessages() {
            MTChatComponent.this.trimmedMessages.removeAll(this.getTrimmedLines());
        }

        @Override
        protected void addMessage(int index, GuiMessage.Line message) {
            MTChatComponent.this.trimmedMessages.add(index, message);
        }

        @Override
        protected double getChatWidth() {
            return (double)MTChatComponent.this.getWidth() / MTChatComponent.this.getScale();
        }
    }

    private class LocalMessage
    extends InGameDisplayableMessage {
        private final Component message;
        private final MessageSignature signature;
        @Nullable
        private GuiMessage.Line line;

        private LocalMessage(Component message, MessageSignature signature) {
            super(new Message(Instant.now(), MineTogetherChat.getOurProfile(), MessageComponent.of(), MessageComponent.of()));
            this.message = message;
            this.signature = signature;
        }

        @Override
        protected GuiMessage.Line createMessage(int addTime, FormattedCharSequence formattedCharSequence) {
            this.line = new GuiMessage.Line(addTime, this.message.getVisualOrderText(), null, true);
            return this.line;
        }
    }
}

