/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.hooks.client.screen.ScreenHooks;
import java.util.List;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.connect.ConnectHandler;
import net.creeperhost.minetogether.connect.gui.GuiShareToFriends;
import net.creeperhost.polylib.client.screen.ButtonHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MineTogetherConnect {
    public static boolean isInitted = false;

    public static void init() {
        isInitted = true;
        ConnectHandler.init();
        ClientGuiEvent.INIT_POST.register(MineTogetherConnect::onScreenOpen);
    }

    private static void onScreenOpen(Screen screen, ScreenAccess screenAccess) {
        if (!(screen instanceof PauseScreen)) {
            return;
        }
        IntegratedServer integratedServer = Minecraft.getInstance().getSingleplayerServer();
        if (integratedServer == null) {
            return;
        }
        boolean isConnectPublished = ConnectHandler.isPublished();
        MutableComponent buttonText = isConnectPublished ? Component.translatable((String)"minetogether.connect.close") : Component.translatable((String)"minetogether.connect.open");
        Button.OnPress action = button -> {
            if (isConnectPublished) {
                ConnectHandler.unPublish();
                Minecraft.getInstance().setScreen((Screen)new PauseScreen(true));
            } else {
                Minecraft.getInstance().setScreen((Screen)new GuiShareToFriends(screen));
            }
        };
        List children = screen.children();
        List renderables = screenAccess.getRenderables();
        List narratables = screenAccess.getNarratables();
        Button feedBack = ButtonHelper.findButton((String)"menu.sendFeedback", (Screen)screen);
        Button options = ButtonHelper.findButton((String)"menu.options", (Screen)screen);
        if (!Config.instance().moveButtonsOnPauseMenu || feedBack == null || options == null) {
            Button openToFriends = Button.builder((Component)buttonText, (Button.OnPress)action).bounds(screen.width - 105, 25, 100, 20).build();
            ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)openToFriends);
            return;
        }
        Button openToFriends = Button.builder((Component)buttonText, (Button.OnPress)action).bounds(options.getX(), options.getY(), 98, 20).build();
        ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)openToFriends);
        options.setY(feedBack.getY());
        options.setX(feedBack.getX());
        children.remove(options);
        renderables.remove(options);
        narratables.remove(options);
        children.set(children.indexOf(feedBack), options);
        renderables.set(renderables.indexOf(feedBack), options);
        narratables.set(narratables.indexOf(feedBack), options);
    }
}

