/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.gui;

import com.mojang.logging.LogUtils;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import net.creeperhost.minetogether.connect.ConnectHandler;
import net.creeperhost.minetogether.connect.ConnectHost;
import net.creeperhost.minetogether.connect.RemoteServer;
import net.creeperhost.minetogether.connect.netty.NettyClient;
import net.creeperhost.minetogether.session.JWebToken;
import net.creeperhost.minetogether.session.MineTogetherSession;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.quickplay.QuickPlayLog;
import net.minecraft.client.server.LanServer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientLoginPacketListener;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import org.slf4j.Logger;

public class FriendConnectScreen
extends ConnectScreen {
    private static final AtomicInteger UNIQUE_THREAD_ID = new AtomicInteger(0);
    private static final Logger LOGGER = LogUtils.getLogger();
    private volatile boolean aborted;
    private final Screen parent;
    private Component status = Component.translatable((String)"connect.connecting");
    private long lastNarration = -1L;

    private FriendConnectScreen(Screen screen) {
        super(screen, CommonComponents.CONNECT_FAILED);
        this.parent = screen;
    }

    public static void startConnecting(Screen screen, Minecraft minecraft, RemoteServer server, LanServer serverData) {
        FriendConnectScreen connectScreen = new FriendConnectScreen(screen);
        minecraft.disconnect();
        minecraft.prepareForMultiplayer();
        minecraft.updateReportEnvironment(ReportEnvironment.thirdParty((String)serverData.getAddress()));
        minecraft.quickPlayLog().setWorldData(QuickPlayLog.Type.MULTIPLAYER, serverData.getAddress(), "MT Friend Server");
        minecraft.setScreen((Screen)connectScreen);
        connectScreen.connect(minecraft, server);
    }

    private void connect(final Minecraft minecraft, final RemoteServer server) {
        LOGGER.info("Connecting to friend server, {}", (Object)server.friend);
        Thread thread = new Thread("MT Server Connector #" + UNIQUE_THREAD_ID.incrementAndGet()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (FriendConnectScreen.this.aborted) {
                        return;
                    }
                    FriendConnectScreen friendConnectScreen = FriendConnectScreen.this;
                    synchronized (friendConnectScreen) {
                        ConnectHost endpoint = ConnectHandler.getSpecificEndpoint(server.node);
                        JWebToken token = MineTogetherSession.getDefault().getTokenAsync().get();
                        FriendConnectScreen.this.connection = NettyClient.connect(endpoint, token, server.serverToken, minecraft.getDebugOverlay().getBandwidthLogger());
                        FriendConnectScreen.this.connection.initiateServerboundPlayConnection(endpoint.address(), endpoint.proxyPort(), (ClientLoginPacketListener)new ClientHandshakePacketListenerImpl(FriendConnectScreen.this.connection, minecraft, new ServerData("", "", ServerData.Type.OTHER), FriendConnectScreen.this.parent, false, (Duration)null, FriendConnectScreen.this::updateStatus));
                        FriendConnectScreen.this.connection.send((Packet)new ServerboundHelloPacket(minecraft.getUser().getName(), minecraft.getUser().getProfileId()));
                    }
                }
                catch (Exception ex) {
                    Exception e;
                    if (FriendConnectScreen.this.aborted) {
                        return;
                    }
                    LOGGER.error("Couldn't connect to server", (Throwable)ex);
                    Throwable throwable = ex.getCause();
                    Exception loggedException = throwable instanceof Exception ? (e = (Exception)throwable) : ex;
                    String string = loggedException.getMessage();
                    minecraft.execute(() -> minecraft.setScreen((Screen)new DisconnectedScreen(FriendConnectScreen.this.parent, CommonComponents.CONNECT_FAILED, (Component)Component.translatable((String)"disconnect.genericReason", (Object[])new Object[]{string}))));
                }
            }
        };
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER));
        thread.start();
    }

    private void updateStatus(Component component) {
        this.status = component;
    }

    public void tick() {
        if (this.connection != null) {
            if (this.connection.isConnected()) {
                this.connection.tick();
            } else {
                this.connection.handleDisconnection();
            }
        }
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            this.aborted = true;
            if (this.connection != null) {
                this.connection.disconnect((Component)Component.translatable((String)"connect.aborted"));
            }
            this.minecraft.setScreen(this.parent);
        }).bounds(this.width / 2 - 100, this.height / 4 + 120 + 12, 200, 20).build());
    }

    public void render(GuiGraphics graphics, int i, int j, float f) {
        this.renderBackground(graphics, i, j, f);
        long l = Util.getMillis();
        if (l - this.lastNarration > 2000L) {
            this.lastNarration = l;
            this.minecraft.getNarrator().sayNow((Component)Component.translatable((String)"narrator.joining"));
        }
        graphics.drawCenteredString(this.font, this.status, this.width / 2, this.height / 2 - 50, 0xFFFFFF);
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, i, j, f);
        }
    }
}

