/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.gui;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.creeperhost.minetogether.connect.RemoteServer;
import net.creeperhost.minetogether.connect.gui.ServerListAppender;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.server.LanServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class FriendServerEntry
extends ServerSelectionList.NetworkServerEntry {
    private static final ResourceLocation INCOMPATIBLE_SPRITE = new ResourceLocation("server_list/incompatible");
    private static final ResourceLocation UNREACHABLE_SPRITE = new ResourceLocation("server_list/unreachable");
    private static final ResourceLocation PING_1_SPRITE = new ResourceLocation("server_list/ping_1");
    private static final ResourceLocation PING_2_SPRITE = new ResourceLocation("server_list/ping_2");
    private static final ResourceLocation PING_3_SPRITE = new ResourceLocation("server_list/ping_3");
    private static final ResourceLocation PING_4_SPRITE = new ResourceLocation("server_list/ping_4");
    private static final ResourceLocation PING_5_SPRITE = new ResourceLocation("server_list/ping_5");
    private static final ResourceLocation PINGING_1_SPRITE = new ResourceLocation("server_list/pinging_1");
    private static final ResourceLocation PINGING_2_SPRITE = new ResourceLocation("server_list/pinging_2");
    private static final ResourceLocation PINGING_3_SPRITE = new ResourceLocation("server_list/pinging_3");
    private static final ResourceLocation PINGING_4_SPRITE = new ResourceLocation("server_list/pinging_4");
    private static final ResourceLocation PINGING_5_SPRITE = new ResourceLocation("server_list/pinging_5");
    private static final ResourceLocation JOIN_HIGHLIGHTED_SPRITE = new ResourceLocation("server_list/join_highlighted");
    private static final ResourceLocation JOIN_SPRITE = new ResourceLocation("server_list/join");
    private static final Component INCOMPATIBLE_TOOLTIP = Component.translatable((String)"multiplayer.status.incompatible");
    private static final Component NO_CONNECTION_TOOLTIP = Component.translatable((String)"multiplayer.status.no_connection");
    private static final Component PINGING_TOOLTIP = Component.translatable((String)"multiplayer.status.pinging");
    private final JoinMultiplayerScreen screen;
    private final FaviconTexture icon;
    public final RemoteServer remoteServer;
    public final Profile friendProfile;
    private final ServerListAppender listAppender;
    @Nullable
    private byte[] lastIconBytes;

    protected FriendServerEntry(JoinMultiplayerScreen joinMultiplayerScreen, RemoteServer remoteServer, Profile friendProfile, ServerListAppender listAppender) {
        super(joinMultiplayerScreen, new LanServer("Dummy Server", "0.0.0.0"));
        this.screen = joinMultiplayerScreen;
        this.remoteServer = remoteServer;
        this.friendProfile = friendProfile;
        this.listAppender = listAppender;
        this.icon = FaviconTexture.forServer((TextureManager)this.minecraft.getTextureManager(), (String)friendProfile.getFullHash().toLowerCase(Locale.ROOT));
    }

    public void render(GuiGraphics graphics, int entryIndex, int y, int x, int entryWidth, int m, int mouseX, int mouseY, boolean selected, float f) {
        byte[] bs;
        List<Object> playersToolTip;
        Component statusToolTip;
        if (!this.remoteServer.pinged) {
            this.remoteServer.pinged = true;
            this.remoteServer.ping = -2L;
            this.remoteServer.motd = Component.empty();
            this.remoteServer.status = Component.empty();
            ServerSelectionList.THREAD_POOL.submit(() -> {
                try {
                    this.listAppender.pingServer(this.remoteServer, this.friendProfile);
                }
                catch (Exception var2) {
                    this.remoteServer.ping = -1L;
                }
            });
        }
        graphics.drawString(this.minecraft.font, (Component)Component.translatable((String)"minetogether.connect.friend.server.title", (Object[])new Object[]{this.getDisplayName()}), x + 32 + 3, y + 1, 0xFFFFFF);
        List list = this.minecraft.font.split((FormattedText)this.remoteServer.motd, entryWidth - 32 - 2);
        for (int line = 0; line < Math.min(list.size(), 2); ++line) {
            Font var10000 = this.minecraft.font;
            FormattedCharSequence var10002 = (FormattedCharSequence)list.get(line);
            int var10003 = x + 32 + 3;
            int var10004 = y + 12;
            Objects.requireNonNull(this.minecraft.font);
            graphics.drawString(var10000, var10002, var10003, var10004 + 9 * line, 0x808080);
        }
        boolean versionMismatch = this.remoteServer.protocol != SharedConstants.getCurrentVersion().getProtocolVersion();
        Component statusText = versionMismatch ? this.remoteServer.version.copy().withStyle(ChatFormatting.RED) : this.remoteServer.status;
        int statusWidth = this.minecraft.font.width((FormattedText)statusText);
        graphics.drawString(this.minecraft.font, statusText, x + entryWidth - statusWidth - 15 - 2, y + 1, 0x808080);
        ResourceLocation statusIcon = null;
        if (versionMismatch) {
            statusIcon = INCOMPATIBLE_SPRITE;
            statusToolTip = INCOMPATIBLE_TOOLTIP;
            playersToolTip = this.remoteServer.playerList;
        } else if (this.remoteServer.pinged && this.remoteServer.ping != -2L) {
            statusIcon = this.remoteServer.ping < 150L ? PING_5_SPRITE : (this.remoteServer.ping < 300L ? PING_4_SPRITE : (this.remoteServer.ping < 600L ? PING_3_SPRITE : (this.remoteServer.ping < 1000L ? PING_2_SPRITE : PING_1_SPRITE)));
            if (this.remoteServer.ping < 0L) {
                statusToolTip = NO_CONNECTION_TOOLTIP;
                statusIcon = UNREACHABLE_SPRITE;
                playersToolTip = Collections.emptyList();
            } else {
                statusToolTip = Component.translatable((String)"multiplayer.status.ping", (Object[])new Object[]{this.remoteServer.ping});
                playersToolTip = this.remoteServer.playerList;
            }
        } else {
            int time = (int)(Util.getMillis() / 100L + (long)(entryIndex * 2) & 7L);
            if (time > 4) {
                time = 8 - time;
            }
            switch (time) {
                case 1: {
                    statusIcon = PINGING_2_SPRITE;
                    break;
                }
                case 2: {
                    statusIcon = PINGING_3_SPRITE;
                    break;
                }
                case 3: {
                    statusIcon = PINGING_4_SPRITE;
                    break;
                }
                case 4: {
                    statusIcon = PINGING_5_SPRITE;
                    break;
                }
                default: {
                    statusIcon = PINGING_1_SPRITE;
                }
            }
            statusToolTip = PINGING_TOOLTIP;
            playersToolTip = Collections.emptyList();
        }
        if (statusIcon != null) {
            graphics.blitSprite(statusIcon, x + entryWidth - 15, y, 10, 8);
        }
        if (!Arrays.equals(bs = this.remoteServer.getIconBytes(), this.lastIconBytes)) {
            if (this.uploadServerIcon(bs)) {
                this.lastIconBytes = bs;
            } else {
                this.remoteServer.setIconBytes(null);
            }
        }
        this.drawIcon(graphics, x, y, this.icon.textureLocation());
        int t = mouseX - x;
        int u = mouseY - y;
        if (t >= entryWidth - 15 && t <= entryWidth - 5 && u >= 0 && u <= 8) {
            this.screen.setToolTip(Collections.singletonList(statusToolTip));
        } else if (t >= entryWidth - statusWidth - 15 - 2 && t <= entryWidth - 15 - 2 && u >= 0 && u <= 8) {
            this.screen.setToolTip(playersToolTip);
        }
        if (((Boolean)this.minecraft.options.touchscreen().get()).booleanValue() || selected) {
            graphics.fill(x, y, x + 32, y + 32, -1601138544);
            int v = mouseX - x;
            if (v < 32 && v > 16) {
                graphics.blitSprite(JOIN_HIGHLIGHTED_SPRITE, x, y, 32, 32);
            } else {
                graphics.blitSprite(JOIN_SPRITE, x, y, 32, 32);
            }
        }
    }

    public String getDisplayName() {
        return this.friendProfile.isFriend() ? this.friendProfile.getFriendName() : this.friendProfile.getDisplayName();
    }

    protected void drawIcon(GuiGraphics graphics, int i, int j, ResourceLocation resourceLocation) {
        graphics.blit(resourceLocation, i, j, 0.0f, 0.0f, 32, 32, 32, 32);
    }

    private boolean uploadServerIcon(@Nullable byte[] bs) {
        if (bs == null) {
            this.icon.clear();
        } else {
            try {
                this.icon.upload(NativeImage.read((byte[])bs));
            }
            catch (Throwable var3) {
                return false;
            }
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double f;
        if (this.listAppender.getServerList() != null && (f = mouseX - (double)this.listAppender.getServerList().getRowLeft()) < 32.0 && f > 16.0) {
            this.screen.setSelected((ServerSelectionList.Entry)this);
            this.screen.joinSelectedServer();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

