/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.gui;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.creeperhost.minetogether.connect.ConnectHandler;
import net.creeperhost.minetogether.connect.ConnectHost;
import net.creeperhost.minetogether.connect.RemoteServer;
import net.creeperhost.minetogether.connect.gui.FriendServerEntry;
import net.creeperhost.minetogether.connect.netty.NettyClient;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.session.JWebToken;
import net.creeperhost.minetogether.session.MineTogetherSession;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.status.ClientStatusPacketListener;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ServerListAppender {
    public static final ServerListAppender INSTANCE = new ServerListAppender();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Component CANT_CONNECT_MESSAGE = Component.translatable((String)"multiplayer.status.cannot_connect").withStyle(ChatFormatting.DARK_RED);
    private final List<Connection> connections = Collections.synchronizedList(Lists.newArrayList());
    private ServerSelectionList serverList;
    private JoinMultiplayerScreen multiplayerScreen;
    private Map<RemoteServer, FriendServerEntry> serverEntries = new HashMap<RemoteServer, FriendServerEntry>();
    private int tick = 0;

    public void init(ServerSelectionList serverList, JoinMultiplayerScreen multiplayerScreen) {
        this.serverList = serverList;
        this.multiplayerScreen = multiplayerScreen;
        ConnectHandler.clearAndReset();
        ConnectHandler.updateFriendsSearch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (this.tick++ % 20 != 0 || this.serverList == null || this.multiplayerScreen == null) {
            return;
        }
        ConnectHandler.updateFriendsSearch();
        boolean dirty = false;
        ArrayList<RemoteServer> remoteServers = new ArrayList<RemoteServer>(ConnectHandler.getRemoteServers());
        for (RemoteServer remoteServer : remoteServers) {
            Profile profile;
            if (this.serverEntries.containsKey(remoteServer) || (profile = ConnectHandler.getServerProfile(remoteServer)).isStale()) continue;
            this.serverEntries.put(remoteServer, new FriendServerEntry(this.multiplayerScreen, remoteServer, profile, this));
            dirty = true;
        }
        ArrayList toRemove = new ArrayList();
        this.serverEntries.forEach((server, entry) -> {
            if (!remoteServers.contains(server)) {
                toRemove.add(server);
            }
        });
        if (!toRemove.isEmpty()) {
            toRemove.forEach(this.serverEntries::remove);
            dirty = true;
        }
        if (dirty) {
            this.serverList.refreshEntries();
        }
        List<Connection> list = this.connections;
        synchronized (list) {
            Iterator<Connection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                Connection connection = iterator.next();
                if (connection.isConnected()) {
                    connection.tick();
                    continue;
                }
                iterator.remove();
                connection.handleDisconnection();
            }
        }
    }

    public void remove() {
        this.serverList = null;
        this.multiplayerScreen = null;
        this.serverEntries.clear();
        this.removeAll();
    }

    public void addEntries() {
        if (this.serverList == null) {
            return;
        }
        for (FriendServerEntry entry : this.serverEntries.values()) {
            this.serverList.addEntry((AbstractSelectionList.Entry)entry);
        }
    }

    public void pingServer(final RemoteServer server, final Profile profile) throws Exception {
        JWebToken token = MineTogetherSession.getDefault().getTokenAsync().get();
        final Connection connection = NettyClient.connect(ConnectHandler.getSpecificEndpoint(server.node), token, server.serverToken, Minecraft.getInstance().getDebugOverlay().getBandwidthLogger());
        this.connections.add(connection);
        server.motd = Component.translatable((String)"multiplayer.status.pinging");
        server.ping = -1L;
        server.playerList = null;
        ClientStatusPacketListener listener = new ClientStatusPacketListener(){
            private boolean success;
            private boolean receivedPing;
            private long pingStart;

            public void handleStatusResponse(ClientboundStatusResponsePacket clientboundStatusResponsePacket) {
                if (this.receivedPing) {
                    connection.disconnect((Component)Component.translatable((String)"multiplayer.status.unrequested"));
                } else {
                    this.receivedPing = true;
                    ServerStatus serverStatus = clientboundStatusResponsePacket.status();
                    server.motd = serverStatus.description() != null ? serverStatus.description() : CommonComponents.EMPTY;
                    serverStatus.version().ifPresentOrElse(version -> {
                        server2.version = Component.literal((String)version.name());
                        server2.protocol = version.protocol();
                    }, () -> {
                        server2.version = Component.translatable((String)"multiplayer.status.old");
                        server2.protocol = 0;
                    });
                    serverStatus.players().ifPresentOrElse(players -> {
                        server2.status = ServerListAppender.formatPlayerCount(players.online(), players.max());
                        ArrayList list = Lists.newArrayList();
                        List gameProfiles = players.sample();
                        if (!gameProfiles.isEmpty()) {
                            for (GameProfile gameProfile : gameProfiles) {
                                list.add(Component.literal((String)gameProfile.getName()));
                            }
                            if (gameProfiles.size() < players.online()) {
                                list.add(Component.translatable((String)"multiplayer.status.and_more", (Object[])new Object[]{players.online() - gameProfiles.size()}));
                            }
                            server2.playerList = list;
                        }
                    }, () -> {
                        server2.status = Component.translatable((String)"multiplayer.status.unknown").withStyle(ChatFormatting.DARK_GRAY);
                    });
                    serverStatus.favicon().ifPresent(favicon -> {
                        if (!Arrays.equals(favicon.iconBytes(), server.getIconBytes())) {
                            server.setIconBytes(favicon.iconBytes());
                        }
                    });
                    this.pingStart = Util.getMillis();
                    connection.send((Packet)new ServerboundPingRequestPacket(this.pingStart));
                    this.success = true;
                }
            }

            public void handlePongResponse(ClientboundPongResponsePacket clientboundPongResponsePacket) {
                long l = this.pingStart;
                long m = Util.getMillis();
                server.ping = m - l;
                connection.disconnect((Component)Component.translatable((String)"multiplayer.status.finished"));
            }

            public void onDisconnect(Component component) {
                if (!this.success) {
                    ServerListAppender.this.onPingFailed(component, server, profile);
                }
            }

            public boolean isAcceptingMessages() {
                return connection.isConnected();
            }
        };
        try {
            ConnectHost endpoint = ConnectHandler.getEndpoint();
            connection.initiateServerboundStatusConnection(endpoint.address(), endpoint.proxyPort(), listener);
            connection.send((Packet)new ServerboundStatusRequestPacket());
        }
        catch (Throwable var8) {
            LOGGER.error("Failed to ping friend server {}", (Object)server.friend, (Object)var8);
        }
    }

    private static Component formatPlayerCount(int i, int j) {
        return Component.literal((String)Integer.toString(i)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.DARK_GRAY)).append(Integer.toString(j)).withStyle(ChatFormatting.GRAY);
    }

    private void onPingFailed(Component component, RemoteServer server, Profile profile) {
        LOGGER.error("Can't ping {}: {}", (Object)(profile.isFriend() ? profile.getFriendName() : profile.getDisplayName()), (Object)component.getString());
        server.motd = CANT_CONNECT_MESSAGE;
        server.status = CommonComponents.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        List<Connection> list = this.connections;
        synchronized (list) {
            Iterator<Connection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                Connection connection = iterator.next();
                if (!connection.isConnected()) continue;
                iterator.remove();
                connection.disconnect((Component)Component.translatable((String)"multiplayer.status.cancelled"));
            }
        }
    }

    @Nullable
    public ServerSelectionList getServerList() {
        return this.serverList;
    }
}

