/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class DataUtils {
    public static int readVarInt(ByteBuf buf) {
        byte b0;
        int i = 0;
        int j = 0;
        do {
            b0 = buf.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    public static long readVarLong(ByteBuf buf) {
        byte b0;
        long i = 0L;
        int j = 0;
        do {
            b0 = buf.readByte();
            i |= (long)(b0 & 0x7F) << j++ * 7;
            if (j <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    public static int readSignedVarInt(ByteBuf buf) {
        int i = DataUtils.readVarInt(buf);
        return (i & 1) == 0 ? i >>> 1 : -(i >>> 1) - 1;
    }

    public static long readSignedVarLong(ByteBuf buf) {
        long i = DataUtils.readVarLong(buf);
        return (i & 1L) == 0L ? i >>> 1 : -(i >>> 1) - 1L;
    }

    public static byte[] readBytes(ByteBuf buf) {
        int len = DataUtils.readVarInt(buf);
        byte[] bytes = new byte[len];
        buf.readBytes(bytes, 0, len);
        return bytes;
    }

    public static String readString(ByteBuf buf) {
        return new String(DataUtils.readBytes(buf), StandardCharsets.UTF_8);
    }

    public static String readNullableString(ByteBuf buf) {
        if (!buf.readBoolean()) {
            return null;
        }
        return DataUtils.readString(buf);
    }

    public static UUID readUUID(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    public static <T extends Enum<T>> T readEnum(ByteBuf buf, Class<T> clazz) {
        return (T)((Enum[])clazz.getEnumConstants())[DataUtils.readVarInt(buf)];
    }

    public static void writeVarInt(ByteBuf buf, int i) {
        while ((i & 0xFFFFFF80) != 0) {
            buf.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        buf.writeByte(i);
    }

    public static void writeVarLong(ByteBuf buf, long l) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buf.writeByte((int)(l & 0x7FL) | 0x80);
            l >>>= 7;
        }
        buf.writeByte((int)l);
    }

    public static void writeSignedVarInt(ByteBuf buf, int i) {
        DataUtils.writeVarInt(buf, i >= 0 ? 2 * i : -2 * (i + 1) + 1);
    }

    public static void writeSignedVarLong(ByteBuf buf, long i) {
        DataUtils.writeVarLong(buf, i >= 0L ? 2L * i : -2L * (i + 1L) + 1L);
    }

    public static void writeBytes(ByteBuf buf, byte[] b) {
        DataUtils.writeBytes(buf, b, 0, b.length);
    }

    public static void writeBytes(ByteBuf buf, byte[] b, int off, int len) {
        Objects.requireNonNull(b);
        DataUtils.checkLen(b.length, off, len);
        DataUtils.writeVarInt(buf, len);
        buf.writeBytes(b, off, len);
    }

    public static void writeString(ByteBuf buf, String s) {
        DataUtils.writeBytes(buf, s.getBytes(StandardCharsets.UTF_8));
    }

    public static void writeNullableString(ByteBuf buf, @Nullable String s) {
        if (s == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            DataUtils.writeString(buf, s);
        }
    }

    public static void writeUUID(ByteBuf buf, UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    public static void writeEnum(ByteBuf buf, Enum<?> value) {
        DataUtils.writeVarInt(buf, value.ordinal());
    }

    private static void checkLen(int arrLen, int off, int len) {
        if (off < 0 || off > arrLen || len < 0 || off + len > arrLen || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
    }
}

