/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import java.util.function.Function;
import net.creeperhost.minetogether.connect.lib.netty.NetworkAttrs;
import net.creeperhost.minetogether.connect.lib.netty.PacketCtx;
import net.creeperhost.minetogether.connect.lib.netty.PacketType;
import net.creeperhost.minetogether.connect.lib.netty.packet.Packet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketCodec
extends ByteToMessageCodec<Packet<?>> {
    private static final Logger LOGGER = LogManager.getLogger();

    protected void encode(ChannelHandlerContext ctx, Packet<?> msg, ByteBuf out) {
        Integer protocolVersion = (Integer)ctx.channel().attr(NetworkAttrs.PROTOCOL_VERSION_ATTR).get();
        PacketType.PacketHandle<Packet<?>> handle = PacketType.getPacketHandle(msg);
        if (protocolVersion != null && handle.requiresVersion > protocolVersion) {
            LOGGER.info("Skipping packet {} to {}. Wrong protocol version, Has: {} Requires: {}", (Object)msg.getClass().getName(), (Object)ctx.channel().remoteAddress(), (Object)protocolVersion, (Object)handle.requiresVersion);
            return;
        }
        out.writeByte(handle.id);
        msg.write(out);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        Function<PacketCtx, Packet<?>> func = PacketType.getPacketFactory(in.readUnsignedByte());
        Integer protocolVersion = (Integer)ctx.channel().attr(NetworkAttrs.PROTOCOL_VERSION_ATTR).get();
        out.add(func.apply(new PacketCtx(in, protocolVersion != null ? protocolVersion : -1)));
    }
}

