/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.crypto.SecretKey;
import net.creeperhost.minetogether.MineTogetherPlatform;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.connect.ConnectHandler;
import net.creeperhost.minetogether.connect.ConnectHost;
import net.creeperhost.minetogether.connect.lib.netty.AbstractChannelHandler;
import net.creeperhost.minetogether.connect.lib.netty.CipherCodec;
import net.creeperhost.minetogether.connect.lib.netty.FrameCodec;
import net.creeperhost.minetogether.connect.lib.netty.LoggingPacketCodec;
import net.creeperhost.minetogether.connect.lib.netty.PacketCodec;
import net.creeperhost.minetogether.connect.lib.netty.packet.CAccepted;
import net.creeperhost.minetogether.connect.lib.netty.packet.CBeginRaw;
import net.creeperhost.minetogether.connect.lib.netty.packet.CDisconnect;
import net.creeperhost.minetogether.connect.lib.netty.packet.CFriendServers;
import net.creeperhost.minetogether.connect.lib.netty.packet.CHello;
import net.creeperhost.minetogether.connect.lib.netty.packet.CMessage;
import net.creeperhost.minetogether.connect.lib.netty.packet.CPong;
import net.creeperhost.minetogether.connect.lib.netty.packet.CRaw;
import net.creeperhost.minetogether.connect.lib.netty.packet.CServerLink;
import net.creeperhost.minetogether.connect.lib.netty.packet.ClientPacketHandler;
import net.creeperhost.minetogether.connect.lib.netty.packet.Packet;
import net.creeperhost.minetogether.connect.lib.netty.packet.SAccepted;
import net.creeperhost.minetogether.connect.lib.netty.packet.SHello;
import net.creeperhost.minetogether.connect.lib.netty.packet.SHostConnect;
import net.creeperhost.minetogether.connect.lib.netty.packet.SHostRegister;
import net.creeperhost.minetogether.connect.lib.netty.packet.SRequestFriendServers;
import net.creeperhost.minetogether.connect.lib.netty.packet.SUserConnect;
import net.creeperhost.minetogether.connect.lib.util.AESUtils;
import net.creeperhost.minetogether.connect.lib.util.RSAUtils;
import net.creeperhost.minetogether.connect.netty.RawCodec;
import net.creeperhost.minetogether.repack.net.covers1624.quack.util.SneakyUtils;
import net.creeperhost.minetogether.session.JWebToken;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.network.LegacyQueryHandler;
import net.minecraft.server.network.ServerConnectionListener;
import net.minecraft.server.network.ServerHandshakePacketListenerImpl;
import net.minecraft.util.SampleLogger;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NettyClient {
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProxyConnection publishServer(final IntegratedServer server, final ConnectHost endpoint, final JWebToken session, final @Nullable String modpackKey) {
        final Throwable[] error = new Throwable[1];
        ProxyConnection connection = new ProxyConnection(endpoint){
            private boolean disconnectRequested;
            {
                super(endpoint2);
                this.disconnectRequested = false;
            }

            @Override
            public void channelReady() {
                super.channelReady();
                this.sendPacket(new SHostRegister(session.toString(), modpackKey));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisconnected(String message) {
                error[0] = new IOException("Failed to host server: " + message);
                Throwable[] throwableArray = error;
                synchronized (error) {
                    error.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    Minecraft.getInstance().gui.getChat().addMessage((Component)Component.translatable((String)"minetogether.connect.open.failed", (Object[])new Object[]{message}));
                    ConnectHandler.unPublish();
                    return;
                }
            }

            @Override
            public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
                super.channelInactive(ctx);
                if (this.disconnectRequested) {
                    Minecraft.getInstance().gui.getChat().addMessage((Component)Component.translatable((String)"minetogether.connect.open.proxy.closed"));
                } else {
                    Minecraft.getInstance().gui.getChat().addMessage((Component)Component.translatable((String)"minetogether.connect.open.proxy.disconnect").withStyle(ChatFormatting.RED));
                    ConnectHandler.unPublish();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleAccepted(ChannelHandlerContext ctx, CAccepted cAccepted) {
                super.handleAccepted(ctx, cAccepted);
                Throwable[] throwableArray = error;
                synchronized (error) {
                    error.notifyAll();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    Minecraft.getInstance().gui.getChat().addMessage((Component)Component.translatable((String)"minetogether.connect.open.success"));
                    return;
                }
            }

            @Override
            public void handleServerLink(ChannelHandlerContext ctx, CServerLink packet) {
                NettyClient.link(server, endpoint, session, packet.linkToken);
            }

            @Override
            public void disconnect() {
                if (this.disconnectRequested) {
                    return;
                }
                this.disconnectRequested = true;
                this.channel.close();
            }
        };
        ChannelFuture channelFuture = NettyClient.openConnection(endpoint, connection, ((Supplier)ServerConnectionListener.SERVER_EPOLL_EVENT_GROUP)::get, ((Supplier)ServerConnectionListener.SERVER_EVENT_GROUP)::get);
        Throwable[] throwableArray = error;
        synchronized (error) {
            try {
                error.wait();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted whilst waiting.", ex);
            }
            if (error[0] != null) {
                SneakyUtils.throwUnchecked(error[0]);
            }
            ServerConnectionListener listener = server.getConnection();
            assert (listener != null);
            List list = listener.channels;
            synchronized (list) {
                listener.channels.add(channelFuture);
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connect(ConnectHost endpoint, final JWebToken session, final String serverToken, @Nullable SampleLogger bwLogger) {
        final boolean[] isConnecting = new boolean[]{true};
        final Throwable[] error = new Throwable[1];
        final Connection connection = new Connection(PacketFlow.CLIENTBOUND);
        connection.setBandwidthLogger(bwLogger);
        ProxyConnection proxyConnection = new ProxyConnection(endpoint){

            @Override
            protected void buildPipeline(ChannelPipeline pipeline) {
                Connection.setInitialProtocolAttributes((Channel)pipeline.channel());
                pipeline.addLast("mt:raw", (ChannelHandler)new RawCodec());
                Connection.configureSerialization((ChannelPipeline)pipeline, (PacketFlow)PacketFlow.CLIENTBOUND, (BandwidthDebugMonitor)connection.bandwidthDebugMonitor);
                connection.configurePacketHandler(pipeline);
            }

            @Override
            public void channelReady() {
                super.channelReady();
                this.sendPacket(new SUserConnect(session.toString(), serverToken));
                MineTogetherPlatform.prepareClientConnection(connection);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisconnected(String message) {
                if (isConnecting[0]) {
                    error[0] = new IOException("Failed to connect to server: " + message);
                    Throwable[] throwableArray = error;
                    synchronized (error) {
                        error.notifyAll();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                    }
                } else {
                    connection.disconnect((Component)Component.literal((String)message));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleBeginRaw(ChannelHandlerContext ctx, CBeginRaw packet) {
                Throwable[] throwableArray = error;
                synchronized (error) {
                    error.notifyAll();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        };
        ChannelFuture channelFuture = NettyClient.openConnection(endpoint, proxyConnection, ((Supplier)Connection.NETWORK_EPOLL_WORKER_GROUP)::get, ((Supplier)Connection.NETWORK_WORKER_GROUP)::get);
        Throwable[] throwableArray = error;
        synchronized (error) {
            try {
                error.wait();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted whilst waiting.", ex);
            }
            if (error[0] != null) {
                SneakyUtils.throwUnchecked(error[0]);
            }
            isConnecting[0] = false;
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void link(final IntegratedServer server, ConnectHost endpoint, final JWebToken session, final String linkToken) {
        ServerConnectionListener listener = server.getConnection();
        assert (listener != null);
        final Connection connection = new Connection(PacketFlow.SERVERBOUND);
        ProxyConnection proxyConnection = new ProxyConnection(endpoint){

            @Override
            protected void buildPipeline(ChannelPipeline pipeline) {
                Connection.setInitialProtocolAttributes((Channel)pipeline.channel());
                pipeline.addLast("mt:raw", (ChannelHandler)new RawCodec());
                pipeline.addLast("legacy_query", (ChannelHandler)new LegacyQueryHandler((ServerInfo)server));
                Connection.configureSerialization((ChannelPipeline)pipeline, (PacketFlow)PacketFlow.SERVERBOUND, null);
                connection.configurePacketHandler(pipeline);
            }

            @Override
            public void channelReady() {
                super.channelReady();
                connection.setListener((PacketListener)new ServerHandshakePacketListenerImpl((MinecraftServer)server, connection));
                this.sendPacket(new SHostConnect(session.toString(), linkToken));
            }

            @Override
            public void onDisconnected(String message) {
                LOGGER.warn("Link connection terminated: {}", (Object)message);
            }

            @Override
            public void handleAccepted(ChannelHandlerContext ctx, CAccepted cAccepted) {
                super.handleAccepted(ctx, cAccepted);
            }
        };
        ChannelFuture channelFuture = NettyClient.openConnection(endpoint, proxyConnection, ((Supplier)ServerConnectionListener.SERVER_EPOLL_EVENT_GROUP)::get, ((Supplier)ServerConnectionListener.SERVER_EVENT_GROUP)::get);
        List list = listener.connections;
        synchronized (list) {
            listener.connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFriendServers getFriendServers(ConnectHost endpoint, final JWebToken session, final @Nullable String modpackKey) throws IOException {
        final IOException[] error = new IOException[1];
        final CFriendServers[] result = new CFriendServers[1];
        ProxyConnection connection = new ProxyConnection(endpoint){

            @Override
            protected void channelReady() {
                super.channelReady();
                this.sendPacket(new SRequestFriendServers(session.toString(), modpackKey));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleFriendServers(ChannelHandlerContext channelHandlerContext, CFriendServers packet) {
                result[0] = packet;
                IOException[] iOExceptionArray = error;
                synchronized (error) {
                    error.notifyAll();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    this.channel.close();
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisconnected(String message) {
                error[0] = new IOException("Failed to host server: " + message);
                IOException[] iOExceptionArray = error;
                synchronized (error) {
                    error.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        ChannelFuture channelFuture = NettyClient.openConnection(endpoint, connection, ((Supplier)Connection.NETWORK_EPOLL_WORKER_GROUP)::get, ((Supplier)Connection.NETWORK_WORKER_GROUP)::get);
        IOException[] iOExceptionArray = error;
        synchronized (error) {
            try {
                error.wait(TimeUnit.MINUTES.toMillis(1L));
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted whilst waiting.", ex);
            }
            if (error[0] != null) {
                throw error[0];
            }
            if (result[0] == null) {
                channelFuture.channel().close();
                throw new IOException("Timeout reached whilst waiting for server response.");
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return result[0];
        }
    }

    private static ChannelFuture openConnection(ConnectHost endpoint, final ProxyConnection connection, Supplier<EventLoopGroup> epollGroup, Supplier<EventLoopGroup> nioGroup) {
        Class<EpollSocketChannel> channelClass;
        EventLoopGroup eventGroup;
        if (Epoll.isAvailable()) {
            eventGroup = epollGroup.get();
            channelClass = EpollSocketChannel.class;
        } else {
            eventGroup = nioGroup.get();
            channelClass = NioSocketChannel.class;
        }
        return ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventGroup)).channel(channelClass)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(@NotNull Channel ch) throws Exception {
                try {
                    ch.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline pipe = ch.pipeline();
                pipe.addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(240));
                pipe.addLast("mt:frame_codec", (ChannelHandler)new FrameCodec());
                pipe.addLast("mt:packet_codec", (ChannelHandler)new PacketCodec());
                if (Config.instance().dumpConnectPackets) {
                    pipe.addLast("mt:logging_codec", (ChannelHandler)new LoggingPacketCodec(LOGGER, true));
                }
                pipe.addLast("mt:packet_handler", (ChannelHandler)connection);
                connection.buildPipeline(pipe);
            }
        })).connect(endpoint.address(), endpoint.proxyPort()).syncUninterruptibly();
    }

    public static class ProxyConnection
    extends AbstractChannelHandler<ClientPacketHandler>
    implements ClientPacketHandler {
        private final ConnectHost endpoint;
        private final byte[] nonce = new byte[32];
        private final SecretKey aesSecret;

        public ProxyConnection(ConnectHost endpoint) {
            this.endpoint = endpoint;
            new SecureRandom().nextBytes(this.nonce);
            this.aesSecret = AESUtils.generateAESKey();
        }

        protected void buildPipeline(ChannelPipeline pipeline) {
        }

        protected void channelReady() {
            this.sendPacket(new SAccepted());
        }

        protected void onDisconnected(String message) {
        }

        public void disconnect() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, Packet<ClientPacketHandler> packet) throws Exception {
            packet.handle(ctx, this);
        }

        @Override
        public final void channelActive(@NotNull ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            this.sendPacket(new SHello(this.nonce, RSAUtils.encrypt(this.aesSecret.getEncoded(), this.endpoint.publicKey()), 4));
        }

        @Override
        public void handleHello(ChannelHandlerContext ctx, CHello packet) {
            if (!RSAUtils.isValid(this.nonce, packet.signedNonce, this.endpoint.publicKey())) {
                LOGGER.error("Failed to validate server signature.");
                this.onDisconnected("Handshake failed.");
                this.channel.close();
                return;
            }
            this.channel.pipeline().addBefore("mt:frame_codec", "aes_codec", (ChannelHandler)new CipherCodec(AESUtils.loadCipher(1, this.aesSecret), AESUtils.loadCipher(2, this.aesSecret)));
            this.channelReady();
        }

        @Override
        public void handleFriendServers(ChannelHandlerContext channelHandlerContext, CFriendServers cFriendServers) {
            throw new NotImplementedException();
        }

        @Override
        public final void handleDisconnect(ChannelHandlerContext ctx, CDisconnect packet) {
            LOGGER.error("Disconnected from proxy: {}", (Object)packet.message);
            this.onDisconnected(packet.message);
        }

        @Override
        public void handleAccepted(ChannelHandlerContext ctx, CAccepted cAccepted) {
        }

        @Override
        public void handleServerLink(ChannelHandlerContext ctx, CServerLink packet) {
            throw new NotImplementedException();
        }

        @Override
        public void handleBeginRaw(ChannelHandlerContext ctx, CBeginRaw packet) {
            throw new NotImplementedException();
        }

        @Override
        public void handleRaw(ChannelHandlerContext ctx, CRaw packet) {
            ctx.fireChannelRead((Object)packet.data);
        }

        @Override
        public void handlePong(ChannelHandlerContext channelHandlerContext, CPong cPong) {
        }

        @Override
        public void handleMessage(ChannelHandlerContext ctx, CMessage packet) {
            Minecraft.getInstance().gui.getChat().addMessage((Component)Component.literal((String)("[MTConnect Broadcast] " + packet.message)));
        }
    }
}

