/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui;

import java.util.List;
import java.util.Random;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.gui.ConsoleFeedbackElement;
import net.creeperhost.minetogether.gui.LoadingSpinner;
import net.creeperhost.minetogether.gui.ProfileRequests;
import net.creeperhost.minetogether.gui.dialogs.ItemSelectDialog;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.ModularGuiScreen;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiDialog;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextField;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextList;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.TextState;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class ProfileGui
implements GuiProvider {
    private static final Random RANDOM = new Random();
    private boolean selectingName = false;
    private String nameLeft = "";
    private String nameRight = "";
    private ConsoleFeedbackElement feedbackElement;
    private TextState nameState;
    private GuiButton submitButton;

    public GuiElement<?> createRootElement(ModularGui gui) {
        return MTStyle.Flat.background(gui);
    }

    public void buildGui(ModularGui gui) {
        gui.renderScreenBackground(false);
        gui.initFullscreenGui();
        gui.setGuiTitle((Component)Component.translatable((String)"minetogether:gui.profile.title"));
        Profile profile = MineTogetherChat.CHAT_STATE.profileManager.getOwnProfile();
        boolean premium = profile.isPremium();
        GuiElement root = gui.getRoot();
        int uiWidth = 250;
        GuiText screenTitle = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, gui.getGuiTitle()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)10.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)10.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-10.0));
        GuiText nameTitle = new GuiText((GuiParent)root, (Component)Component.translatable((String)"minetogether:gui.profile.display_name").withStyle(ChatFormatting.UNDERLINE)).setAlignment(Align.LEFT);
        Constraints.size((ConstrainedGeometry)nameTitle, (double)uiWidth, (double)8.0);
        Constraints.placeOutside((ConstrainedGeometry)nameTitle, (ConstrainedGeometry)screenTitle, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)50.0);
        Assembly nameField = GuiTextField.create((GuiElement)root, (int)-16777216, (int)-13619152, (int)0xFFFFFF);
        ((GuiTextField)nameField.primary).setFocusable(premium);
        Constraints.size((ConstrainedGeometry)nameField.container, (double)(uiWidth - 50), (double)14.0);
        Constraints.placeInside((ConstrainedGeometry)nameField.container, (ConstrainedGeometry)nameTitle, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_LEFT, (double)0.0, (double)18.0);
        this.nameState = ((GuiTextField)nameField.primary).getTextState();
        this.nameState.setText(this.trimHash(profile.getDisplayName()));
        GuiButton nameButton = MTStyle.Flat.buttonPrimary(root, (Component)Component.translatable((String)("minetogether:gui.profile.button." + (premium ? "save" : "change")))).onPress(() -> this.handleNameChange(premium, (GuiTextField)nameField.primary));
        Constraints.size((ConstrainedGeometry)nameButton, (double)((double)uiWidth - ((GuiRectangle)nameField.container).xSize() - 1.0), (double)14.0);
        Constraints.placeOutside((ConstrainedGeometry)nameButton, (ConstrainedGeometry)nameField.container, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)1.0, (double)0.0);
        GuiTextList nextChange = ((GuiTextList)((GuiTextList)new GuiTextList((GuiParent)root, () -> List.of(Component.translatable((String)"minetogether:gui.profile.next_name_change").withStyle(ChatFormatting.YELLOW), ProfileRequests.getCanChangeComp().withStyle(ChatFormatting.GRAY))).setEnabled(() -> !ProfileRequests.canChangeName())).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).autoHeight();
        Constraints.placeOutside((ConstrainedGeometry)nextChange, (ConstrainedGeometry)nameTitle, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)20.0);
        GuiText canChange = ((GuiText)((GuiText)new GuiText((GuiParent)root, () -> Component.translatable((String)"minetogether:gui.profile.name_can_be_changed").withStyle(ChatFormatting.GRAY)).setEnabled(ProfileRequests::canChangeName)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).autoHeight();
        Constraints.placeOutside((ConstrainedGeometry)canChange, (ConstrainedGeometry)nameTitle, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)20.0);
        GuiButton back = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Component)Component.translatable((String)"minetogether:gui.button.back")).onPress(() -> gui.mc().setScreen(gui.getParentScreen())).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-30.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)root.get(GeoParam.LEFT), (GeoRef)root.get(GeoParam.RIGHT), (double)-75.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)150.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0));
        this.buildNameSelectionScreen(root, uiWidth);
        this.buildBanScreen(root, uiWidth);
        GuiRectangle spinnerBg = ((GuiRectangle)((GuiRectangle)new GuiRectangle((GuiParent)root).setEnabled(ProfileRequests::requestsInProgress)).setOpaque(true)).fill(Integer.MIN_VALUE);
        Constraints.bind((ConstrainedGeometry)spinnerBg, (ConstrainedGeometry)root);
        LoadingSpinner spinner = new LoadingSpinner((GuiParent)spinnerBg);
        Constraints.size((ConstrainedGeometry)spinner, (double)80.0, (double)80.0);
        Constraints.center((ConstrainedGeometry)spinner, (ConstrainedGeometry)root);
        this.feedbackElement = new ConsoleFeedbackElement((GuiParent<?>)root);
        Constraints.bind((ConstrainedGeometry)this.feedbackElement, (ConstrainedGeometry)root);
        gui.onTick(this::tick);
        this.feedbackElement.addMessage((Component)Component.translatable((String)"minetogether:gui.profile.fetching_data").withStyle(ChatFormatting.GRAY));
        ProfileRequests.fetchBannedStatus(null);
        ProfileRequests.fetchNameOptions(this::randomizeName);
        ProfileRequests.fetchName(null);
        ProfileRequests.guiOpened(this.feedbackElement::addMessage);
    }

    private void buildNameSelectionScreen(GuiElement<?> uiRoot, int uiWidth) {
        GuiRectangle root = ((GuiRectangle)((GuiRectangle)new GuiRectangle(uiRoot).setOpaque(true)).setEnabled(() -> this.selectingName)).fill(-1073741824);
        Constraints.bind((ConstrainedGeometry)root, uiRoot);
        Constraints.bind((ConstrainedGeometry)new GuiButton((GuiParent)root).onPress(() -> {
            this.selectingName = false;
        }), (ConstrainedGeometry)root);
        GuiText title = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, (Component)Component.translatable((String)"minetogether:gui.profile.choose_name").withStyle(ChatFormatting.UNDERLINE)).constrain(GeoParam.TOP, (Constraint)Constraint.midPoint((GeoRef)root.get(GeoParam.TOP), (GeoRef)root.get(GeoParam.BOTTOM), (double)-40.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)root.get(GeoParam.LEFT), (GeoRef)root.get(GeoParam.RIGHT), (double)(-((double)uiWidth / 2.0))));
        GuiButton left = MTStyle.Flat.button(root, () -> Component.literal((String)this.nameLeft)).onPress(() -> new ItemSelectDialog<String>((GuiParent<?>)root, (Component)Component.translatable((String)"minetogether:gui.profile.select_option"), ProfileRequests.getNameOptions()).setCloseOnOutsideClick(true).setOnItemSelected(s -> {
            this.nameLeft = s;
        }));
        Constraints.size((ConstrainedGeometry)left, (double)((double)(uiWidth - 50) / 2.0 - 0.5), (double)14.0);
        Constraints.placeInside((ConstrainedGeometry)left, (ConstrainedGeometry)title, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_LEFT, (double)0.0, (double)20.0);
        GuiButton right = MTStyle.Flat.button(root, () -> Component.literal((String)this.nameRight)).onPress(() -> new ItemSelectDialog<String>((GuiParent<?>)root, (Component)Component.translatable((String)"minetogether:gui.profile.select_option"), ProfileRequests.getNameOptions()).setCloseOnOutsideClick(true).setOnItemSelected(s -> {
            this.nameRight = s;
        }));
        Constraints.size((ConstrainedGeometry)right, (double)((double)(uiWidth - 50) / 2.0 - 0.5), (double)14.0);
        Constraints.placeOutside((ConstrainedGeometry)right, (ConstrainedGeometry)left, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)1.0, (double)0.0);
        GuiButton save = MTStyle.Flat.buttonPrimary(root, (Component)Component.translatable((String)"minetogether:gui.profile.button.save")).onPress(() -> {
            ProfileRequests.setName(this.nameLeft + this.nameRight, this::updateName);
            this.selectingName = false;
        });
        Constraints.size((ConstrainedGeometry)save, (double)((double)uiWidth - (right.xMax() - left.xMin())), (double)14.0);
        Constraints.placeOutside((ConstrainedGeometry)save, (ConstrainedGeometry)right, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)1.0, (double)0.0);
        GuiButton randomize = MTStyle.Flat.button(root, (Component)Component.translatable((String)"minetogether:gui.profile.button.randomize")).onPress(this::randomizeName);
        Constraints.size((ConstrainedGeometry)randomize, (double)((double)uiWidth / 2.0 - 0.5), (double)14.0);
        Constraints.placeInside((ConstrainedGeometry)randomize, (ConstrainedGeometry)left, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_LEFT, (double)0.0, (double)40.0);
        GuiButton cancel = MTStyle.Flat.buttonCaution(root, (Component)Component.translatable((String)"minetogether:gui.button.cancel"));
        Constraints.size((ConstrainedGeometry)cancel, (double)((double)uiWidth / 2.0 - 0.5), (double)14.0);
        Constraints.placeInside((ConstrainedGeometry)cancel, (ConstrainedGeometry)save, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_RIGHT, (double)0.0, (double)40.0);
    }

    private void buildBanScreen(GuiElement<?> uiRoot, int uiWidth) {
        GuiRectangle root = (GuiRectangle)((GuiRectangle)new GuiRectangle(uiRoot).setOpaque(true)).fill(-16777216).setEnabled(ProfileRequests::isBanned);
        Constraints.bind((ConstrainedGeometry)root, uiRoot);
        GuiText youAreBanned = ((GuiText)new GuiText((GuiParent)root, () -> Component.translatable((String)"minetogether:gui.profile.ban.you_are_banned").withStyle(ChatFormatting.RED)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).setWrap(true).autoHeight();
        Constraints.placeInside((ConstrainedGeometry)youAreBanned, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)20.0);
        GuiText currentBan = ((GuiText)new GuiText((GuiParent)root, () -> Component.translatable((String)"minetogether:gui.profile.ban.current_ban").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE})).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).setWrap(true).autoHeight();
        Constraints.placeOutside((ConstrainedGeometry)currentBan, (ConstrainedGeometry)youAreBanned, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)10.0);
        GuiText banId = ((GuiText)new GuiText((GuiParent)root, () -> Component.translatable((String)"minetogether:gui.profile.ban.ban_id", (Object[])new Object[]{ProfileRequests.getBanId().withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.YELLOW)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).setAlignment(Align.LEFT).setWrap(true).autoHeight();
        Constraints.placeOutside((ConstrainedGeometry)banId, (ConstrainedGeometry)currentBan, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)3.0);
        GuiText moderator = ((GuiText)new GuiText((GuiParent)root, () -> Component.translatable((String)"minetogether:gui.profile.ban.moderator", (Object[])new Object[]{ProfileRequests.getModerator().withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.YELLOW)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).setAlignment(Align.LEFT).setWrap(true).autoHeight();
        Constraints.placeOutside((ConstrainedGeometry)moderator, (ConstrainedGeometry)banId, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)1.0);
        GuiText reason = ((GuiText)new GuiText((GuiParent)root, () -> Component.translatable((String)"minetogether:gui.profile.ban.reason", (Object[])new Object[]{ProfileRequests.getReason().withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.YELLOW)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).setAlignment(Align.LEFT).setWrap(true).autoHeight();
        Constraints.placeOutside((ConstrainedGeometry)reason, (ConstrainedGeometry)moderator, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)1.0);
        GuiText timeStamp = ((GuiText)new GuiText((GuiParent)root, () -> Component.translatable((String)"minetogether:gui.profile.ban.timestamp", (Object[])new Object[]{ProfileRequests.getTimestamp().withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.YELLOW)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).setAlignment(Align.LEFT).setWrap(true).autoHeight();
        Constraints.placeOutside((ConstrainedGeometry)timeStamp, (ConstrainedGeometry)reason, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)1.0);
        GuiText appealStatus = ((GuiText)new GuiText((GuiParent)root, () -> Component.translatable((String)"minetogether:gui.profile.ban.appeal_status", (Object[])new Object[]{ProfileRequests.getAppealStatus().withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.BLUE)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).setAlignment(Align.LEFT).setWrap(true).autoHeight();
        Constraints.placeOutside((ConstrainedGeometry)appealStatus, (ConstrainedGeometry)timeStamp, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)1.0);
        GuiText appealNotes = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, () -> Component.translatable((String)"minetogether:gui.profile.ban.appeal_notes").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE})).setEnabled(() -> !ProfileRequests.getNotes().isEmpty())).setTooltip(ProfileRequests::getNotesTooltip)).setTooltipDelay(0)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).setAlignment(Align.LEFT).setWrap(true).autoHeight();
        Constraints.placeOutside((ConstrainedGeometry)appealNotes, (ConstrainedGeometry)appealStatus, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)2.0);
        GuiText nextAppeal = ((GuiText)((GuiText)new GuiText((GuiParent)root, () -> Component.translatable((String)"minetogether:gui.profile.ban.next_appeal", (Object[])new Object[]{ProfileRequests.getNextAppealComp().withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.YELLOW)).setEnabled(() -> ProfileRequests.getNextAppeal() != -1L)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).setAlignment(Align.LEFT).setWrap(true).autoHeight();
        Constraints.placeOutside((ConstrainedGeometry)nextAppeal, (ConstrainedGeometry)appealNotes, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)2.0);
        GuiText submitAppeal = ((GuiText)new GuiText((GuiParent)root, () -> Component.translatable((String)"minetogether:gui.profile.ban.submit_an_appeal").withStyle(ChatFormatting.BLUE)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).setWrap(true).autoHeight();
        Constraints.placeOutside((ConstrainedGeometry)submitAppeal, (ConstrainedGeometry)nextAppeal, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)15.0);
        Assembly appealText = GuiTextField.create((GuiElement)root, (int)-1608507360, (int)-1608507360, (int)0xE0E0E0);
        ((GuiRectangle)((GuiRectangle)appealText.container).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)uiWidth))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        ((GuiTextField)appealText.primary).setMaxLength(140).setSuggestion((Component)Component.translatable((String)"minetogether:gui.profile.ban.submit_an_appeal_hint"));
        Constraints.placeOutside((ConstrainedGeometry)appealText.container, (ConstrainedGeometry)submitAppeal, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)2.0);
        this.submitButton = (GuiButton)((GuiButton)MTStyle.Flat.buttonPrimary(root, (Component)Component.translatable((String)"minetogether:gui.profile.button.submit")).onPress(() -> ProfileRequests.submitAppeal(((GuiTextField)appealText.primary).getValue(), (success, message) -> this.onAppealSubmitted(root.getModularGui(), (boolean)success, (Component)message))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)150.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0));
        Constraints.placeOutside((ConstrainedGeometry)this.submitButton, (ConstrainedGeometry)appealText.container, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)2.0);
        GuiButton back = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Component)Component.translatable((String)"minetogether:gui.button.back")).onPress(() -> root.mc().setScreen(root.getModularGui().getParentScreen())).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-30.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)root.get(GeoParam.LEFT), (GeoRef)root.get(GeoParam.RIGHT), (double)-75.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)150.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0));
    }

    private void onAppealSubmitted(ModularGui gui, boolean success, Component message) {
        if (success) {
            this.submitButton.setEnabled(false);
        }
        GuiDialog.infoDialog((GuiParent)gui.getRoot(), null, (Component)message, (int)250, () -> {
            if (success) {
                gui.getScreen().onClose();
            }
        }).setBlockMouseInput(true);
    }

    private void randomizeName() {
        List<String> nams = ProfileRequests.getNameOptions();
        if (nams.isEmpty()) {
            return;
        }
        this.nameLeft = nams.get(RANDOM.nextInt(nams.size()));
        this.nameRight = nams.get(RANDOM.nextInt(nams.size()));
    }

    private void handleNameChange(boolean premium, GuiTextField nameField) {
        if (!premium) {
            this.selectingName = true;
        } else {
            ProfileRequests.setName(nameField.getValue(), null);
        }
    }

    private String trimHash(String displayName) {
        return displayName.contains("#") ? displayName.substring(0, displayName.lastIndexOf("#")) : displayName;
    }

    private void updateName() {
        String custom = ProfileRequests.getCustomName();
        if (custom != null && !custom.isEmpty()) {
            this.nameState.setText(custom);
        } else {
            Profile profile = MineTogetherChat.CHAT_STATE.profileManager.getOwnProfile();
            this.nameState.setText(this.trimHash(profile.getDisplayName()));
        }
    }

    private void tick() {
        ProfileRequests.updateRequests();
    }

    public static class Screen
    extends ModularGuiScreen {
        public Screen(net.minecraft.client.gui.screens.Screen parent) {
            super((GuiProvider)new ProfileGui(), parent);
        }
    }
}

